/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.function.BiPredicate;
import org.apache.camel.Ordered;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.ThrowingBiConsumer;
import org.apache.camel.util.function.ThrowingConsumer;

@FunctionalInterface
public interface DataFormatCustomizer
extends Ordered {
    public static Builder<DataFormat> builder() {
        return DataFormatCustomizer.builder(DataFormat.class);
    }

    public static <T extends DataFormat> Builder<T> builder(Class<T> type) {
        return new Builder<T>(type);
    }

    public static <T extends DataFormat> DataFormatCustomizer forType(Class<T> type, ThrowingConsumer<T, Exception> consumer) {
        return DataFormatCustomizer.builder(type).build(consumer);
    }

    public void configure(String var1, DataFormat var2);

    default public boolean isEnabled(String name, DataFormat target) {
        return true;
    }

    @Override
    default public int getOrder() {
        return 0;
    }

    public static class Builder<T extends DataFormat> {
        private final Class<T> type;
        private BiPredicate<String, DataFormat> condition;
        private int order;

        public Builder(Class<T> type) {
            this.type = type;
        }

        public Builder<T> withOrder(int order) {
            this.order = order;
            return this;
        }

        public Builder<T> withCondition(BiPredicate<String, DataFormat> condition) {
            this.condition = condition;
            return this;
        }

        public DataFormatCustomizer build(final ThrowingConsumer<T, Exception> consumer) {
            return this.build(new ThrowingBiConsumer<String, T, Exception>(){

                @Override
                public void accept(String name, T target) throws Exception {
                    consumer.accept(target);
                }
            });
        }

        public DataFormatCustomizer build(final ThrowingBiConsumer<String, T, Exception> consumer) {
            final int order = this.order;
            final BiPredicate<String, DataFormat> condition = this.condition();
            return new DataFormatCustomizer(){

                @Override
                public void configure(String name, DataFormat target) {
                    ObjectHelper.notNull(name, "data format name");
                    ObjectHelper.notNull(target, "data format instance");
                    try {
                        consumer.accept(name, target);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public boolean isEnabled(String name, DataFormat target) {
                    ObjectHelper.notNull(name, "data format name");
                    ObjectHelper.notNull(target, "data format instance");
                    return condition.test(name, target);
                }

                @Override
                public int getOrder() {
                    return order;
                }
            };
        }

        private BiPredicate<String, DataFormat> condition() {
            if (this.type.equals(DataFormat.class)) {
                return this.condition != null ? this.condition : new BiPredicate<String, DataFormat>(){

                    @Override
                    public boolean test(String s2, DataFormat language) {
                        return true;
                    }
                };
            }
            if (this.condition == null) {
                return new BiPredicate<String, DataFormat>(){

                    @Override
                    public boolean test(String name, DataFormat target) {
                        return type.isAssignableFrom(target.getClass());
                    }
                };
            }
            return new BiPredicate<String, DataFormat>(){

                @Override
                public boolean test(String name, DataFormat target) {
                    return type.isAssignableFrom(target.getClass()) && condition.test(name, target);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Policy
    extends BiPredicate<String, DataFormat> {
        public static Policy none() {
            return new Policy(){

                @Override
                public boolean test(String s2, DataFormat target) {
                    return false;
                }
            };
        }

        public static Policy any() {
            return new Policy(){

                @Override
                public boolean test(String s2, DataFormat target) {
                    return true;
                }
            };
        }
    }
}

