/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.agent.ServiceProxyUpstream;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="ServiceProxyUpstream", generator="Immutables")
public final class ImmutableServiceProxyUpstream
extends ServiceProxyUpstream {
    private final String destinationType;
    private final String destinationName;
    private final int localBindPort;

    private ImmutableServiceProxyUpstream(String destinationType, String destinationName, int localBindPort) {
        this.destinationType = destinationType;
        this.destinationName = destinationName;
        this.localBindPort = localBindPort;
    }

    @Override
    @JsonProperty(value="DestinationType")
    public String getDestinationType() {
        return this.destinationType;
    }

    @Override
    @JsonProperty(value="DestinationName")
    public String getDestinationName() {
        return this.destinationName;
    }

    @Override
    @JsonProperty(value="LocalBindPort")
    public int getLocalBindPort() {
        return this.localBindPort;
    }

    public final ImmutableServiceProxyUpstream withDestinationType(String value) {
        String newValue = Objects.requireNonNull(value, "destinationType");
        if (this.destinationType.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceProxyUpstream(newValue, this.destinationName, this.localBindPort);
    }

    public final ImmutableServiceProxyUpstream withDestinationName(String value) {
        String newValue = Objects.requireNonNull(value, "destinationName");
        if (this.destinationName.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceProxyUpstream(this.destinationType, newValue, this.localBindPort);
    }

    public final ImmutableServiceProxyUpstream withLocalBindPort(int value) {
        if (this.localBindPort == value) {
            return this;
        }
        return new ImmutableServiceProxyUpstream(this.destinationType, this.destinationName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceProxyUpstream && this.equalTo(0, (ImmutableServiceProxyUpstream)another);
    }

    private boolean equalTo(int synthetic, ImmutableServiceProxyUpstream another) {
        return this.destinationType.equals(another.destinationType) && this.destinationName.equals(another.destinationName) && this.localBindPort == another.localBindPort;
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.destinationType.hashCode();
        h2 += (h2 << 5) + this.destinationName.hashCode();
        h2 += (h2 << 5) + this.localBindPort;
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ServiceProxyUpstream").omitNullValues().add("destinationType", this.destinationType).add("destinationName", this.destinationName).add("localBindPort", this.localBindPort).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceProxyUpstream fromJson(Json json) {
        Builder builder = ImmutableServiceProxyUpstream.builder();
        if (json.destinationType != null) {
            builder.destinationType(json.destinationType);
        }
        if (json.destinationName != null) {
            builder.destinationName(json.destinationName);
        }
        if (json.localBindPortIsSet) {
            builder.localBindPort(json.localBindPort);
        }
        return builder.build();
    }

    public static ImmutableServiceProxyUpstream copyOf(ServiceProxyUpstream instance) {
        if (instance instanceof ImmutableServiceProxyUpstream) {
            return (ImmutableServiceProxyUpstream)instance;
        }
        return ImmutableServiceProxyUpstream.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServiceProxyUpstream", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DESTINATION_TYPE = 1L;
        private static final long INIT_BIT_DESTINATION_NAME = 2L;
        private static final long INIT_BIT_LOCAL_BIND_PORT = 4L;
        private long initBits = 7L;
        @Nullable
        private String destinationType;
        @Nullable
        private String destinationName;
        private int localBindPort;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceProxyUpstream instance) {
            Objects.requireNonNull(instance, "instance");
            this.destinationType(instance.getDestinationType());
            this.destinationName(instance.getDestinationName());
            this.localBindPort(instance.getLocalBindPort());
            return this;
        }

        @JsonProperty(value="DestinationType")
        @CanIgnoreReturnValue
        public final Builder destinationType(String destinationType) {
            this.destinationType = Objects.requireNonNull(destinationType, "destinationType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="DestinationName")
        @CanIgnoreReturnValue
        public final Builder destinationName(String destinationName) {
            this.destinationName = Objects.requireNonNull(destinationName, "destinationName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="LocalBindPort")
        @CanIgnoreReturnValue
        public final Builder localBindPort(int localBindPort) {
            this.localBindPort = localBindPort;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableServiceProxyUpstream build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceProxyUpstream(this.destinationType, this.destinationName, this.localBindPort);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("destinationType");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destinationName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("localBindPort");
            }
            return "Cannot build ServiceProxyUpstream, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ServiceProxyUpstream", generator="Immutables")
    static final class Json
    extends ServiceProxyUpstream {
        @Nullable
        String destinationType;
        @Nullable
        String destinationName;
        int localBindPort;
        boolean localBindPortIsSet;

        Json() {
        }

        @JsonProperty(value="DestinationType")
        public void setDestinationType(String destinationType) {
            this.destinationType = destinationType;
        }

        @JsonProperty(value="DestinationName")
        public void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @JsonProperty(value="LocalBindPort")
        public void setLocalBindPort(int localBindPort) {
            this.localBindPort = localBindPort;
            this.localBindPortIsSet = true;
        }

        @Override
        public String getDestinationType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDestinationName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLocalBindPort() {
            throw new UnsupportedOperationException();
        }
    }
}

