/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.cloudant.v1.model.Attachment;
import com.ibm.cloud.cloudant.v1.model.DesignDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DesignDocumentViewsMapReduce;
import com.ibm.cloud.cloudant.v1.model.DocumentRevisionStatus;
import com.ibm.cloud.cloudant.v1.model.Revisions;
import com.ibm.cloud.cloudant.v1.model.SearchIndexDefinition;
import com.ibm.cloud.sdk.core.service.model.DynamicModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DesignDocument
extends DynamicModel<Object> {
    @SerializedName(value="_attachments")
    protected Map<String, Attachment> attachments;
    @SerializedName(value="_conflicts")
    protected List<String> conflicts;
    @SerializedName(value="_deleted")
    protected Boolean deleted;
    @SerializedName(value="_deleted_conflicts")
    protected List<String> deletedConflicts;
    @SerializedName(value="_id")
    protected String id;
    @SerializedName(value="_local_seq")
    protected String localSeq;
    @SerializedName(value="_rev")
    protected String rev;
    @SerializedName(value="_revisions")
    protected Revisions revisions;
    @SerializedName(value="_revs_info")
    protected List<DocumentRevisionStatus> revsInfo;
    @SerializedName(value="autoupdate")
    protected Boolean autoupdate;
    @SerializedName(value="filters")
    protected Map<String, String> filters;
    @SerializedName(value="indexes")
    protected Map<String, SearchIndexDefinition> indexes;
    @SerializedName(value="language")
    protected String language;
    @SerializedName(value="options")
    protected DesignDocumentOptions options;
    @SerializedName(value="validate_doc_update")
    protected String validateDocUpdate;
    @SerializedName(value="views")
    protected Map<String, DesignDocumentViewsMapReduce> views;

    public DesignDocument() {
        super(new TypeToken<Object>(){});
    }

    protected DesignDocument(Builder builder) {
        super(new TypeToken<Object>(){});
        this.attachments = builder.attachments;
        this.conflicts = builder.conflicts;
        this.deleted = builder.deleted;
        this.deletedConflicts = builder.deletedConflicts;
        this.id = builder.id;
        this.localSeq = builder.localSeq;
        this.rev = builder.rev;
        this.revisions = builder.revisions;
        this.revsInfo = builder.revsInfo;
        this.autoupdate = builder.autoupdate;
        this.filters = builder.filters;
        this.indexes = builder.indexes;
        this.language = builder.language;
        this.options = builder.options;
        this.validateDocUpdate = builder.validateDocUpdate;
        this.views = builder.views;
        this.setProperties(builder.dynamicProperties);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public Map<String, Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Map<String, Attachment> attachments) {
        this.attachments = attachments;
    }

    public List<String> getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(List<String> conflicts) {
        this.conflicts = conflicts;
    }

    public Boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    public List<String> getDeletedConflicts() {
        return this.deletedConflicts;
    }

    public void setDeletedConflicts(List<String> deletedConflicts) {
        this.deletedConflicts = deletedConflicts;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getLocalSeq() {
        return this.localSeq;
    }

    public void setLocalSeq(String localSeq) {
        this.localSeq = localSeq;
    }

    public String getRev() {
        return this.rev;
    }

    public void setRev(String rev) {
        this.rev = rev;
    }

    public Revisions getRevisions() {
        return this.revisions;
    }

    public void setRevisions(Revisions revisions) {
        this.revisions = revisions;
    }

    public List<DocumentRevisionStatus> getRevsInfo() {
        return this.revsInfo;
    }

    public void setRevsInfo(List<DocumentRevisionStatus> revsInfo) {
        this.revsInfo = revsInfo;
    }

    public Boolean isAutoupdate() {
        return this.autoupdate;
    }

    public void setAutoupdate(Boolean autoupdate) {
        this.autoupdate = autoupdate;
    }

    public Map<String, String> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, String> filters) {
        this.filters = filters;
    }

    public Map<String, SearchIndexDefinition> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Map<String, SearchIndexDefinition> indexes) {
        this.indexes = indexes;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public DesignDocumentOptions getOptions() {
        return this.options;
    }

    public void setOptions(DesignDocumentOptions options) {
        this.options = options;
    }

    public String getValidateDocUpdate() {
        return this.validateDocUpdate;
    }

    public void setValidateDocUpdate(String validateDocUpdate) {
        this.validateDocUpdate = validateDocUpdate;
    }

    public Map<String, DesignDocumentViewsMapReduce> getViews() {
        return this.views;
    }

    public void setViews(Map<String, DesignDocumentViewsMapReduce> views) {
        this.views = views;
    }

    public static class Builder {
        private Map<String, Attachment> attachments;
        private List<String> conflicts;
        private Boolean deleted;
        private List<String> deletedConflicts;
        private String id;
        private String localSeq;
        private String rev;
        private Revisions revisions;
        private List<DocumentRevisionStatus> revsInfo;
        private Boolean autoupdate;
        private Map<String, String> filters;
        private Map<String, SearchIndexDefinition> indexes;
        private String language;
        private DesignDocumentOptions options;
        private String validateDocUpdate;
        private Map<String, DesignDocumentViewsMapReduce> views;
        private Map<String, Object> dynamicProperties;

        private Builder(DesignDocument designDocument) {
            this.attachments = designDocument.attachments;
            this.conflicts = designDocument.conflicts;
            this.deleted = designDocument.deleted;
            this.deletedConflicts = designDocument.deletedConflicts;
            this.id = designDocument.id;
            this.localSeq = designDocument.localSeq;
            this.rev = designDocument.rev;
            this.revisions = designDocument.revisions;
            this.revsInfo = designDocument.revsInfo;
            this.autoupdate = designDocument.autoupdate;
            this.filters = designDocument.filters;
            this.indexes = designDocument.indexes;
            this.language = designDocument.language;
            this.options = designDocument.options;
            this.validateDocUpdate = designDocument.validateDocUpdate;
            this.views = designDocument.views;
            this.dynamicProperties = designDocument.getProperties();
        }

        public Builder() {
        }

        public DesignDocument build() {
            return new DesignDocument(this);
        }

        public Builder addConflicts(String conflicts) {
            Validator.notNull(conflicts, "conflicts cannot be null");
            if (this.conflicts == null) {
                this.conflicts = new ArrayList<String>();
            }
            this.conflicts.add(conflicts);
            return this;
        }

        public Builder addDeletedConflicts(String deletedConflicts) {
            Validator.notNull(deletedConflicts, "deletedConflicts cannot be null");
            if (this.deletedConflicts == null) {
                this.deletedConflicts = new ArrayList<String>();
            }
            this.deletedConflicts.add(deletedConflicts);
            return this;
        }

        public Builder addRevsInfo(DocumentRevisionStatus revsInfo) {
            Validator.notNull(revsInfo, "revsInfo cannot be null");
            if (this.revsInfo == null) {
                this.revsInfo = new ArrayList<DocumentRevisionStatus>();
            }
            this.revsInfo.add(revsInfo);
            return this;
        }

        public Builder attachments(Map<String, Attachment> attachments) {
            this.attachments = attachments;
            return this;
        }

        public Builder conflicts(List<String> conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder deleted(Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder deletedConflicts(List<String> deletedConflicts) {
            this.deletedConflicts = deletedConflicts;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder localSeq(String localSeq) {
            this.localSeq = localSeq;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }

        public Builder revisions(Revisions revisions) {
            this.revisions = revisions;
            return this;
        }

        public Builder revsInfo(List<DocumentRevisionStatus> revsInfo) {
            this.revsInfo = revsInfo;
            return this;
        }

        public Builder autoupdate(Boolean autoupdate) {
            this.autoupdate = autoupdate;
            return this;
        }

        public Builder filters(Map<String, String> filters) {
            this.filters = filters;
            return this;
        }

        public Builder indexes(Map<String, SearchIndexDefinition> indexes) {
            this.indexes = indexes;
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            return this;
        }

        public Builder options(DesignDocumentOptions options) {
            this.options = options;
            return this;
        }

        public Builder validateDocUpdate(String validateDocUpdate) {
            this.validateDocUpdate = validateDocUpdate;
            return this;
        }

        public Builder views(Map<String, DesignDocumentViewsMapReduce> views) {
            this.views = views;
            return this;
        }

        public Builder add(String name, Object value) {
            Validator.notNull(name, "name cannot be null");
            if (this.dynamicProperties == null) {
                this.dynamicProperties = new HashMap<String, Object>();
            }
            this.dynamicProperties.put(name, value);
            return this;
        }
    }
}

