/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.util;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class BooleanToStringTypeAdapter
extends TypeAdapter<Boolean> {
    private static final String YES = "yes";
    private static final String TRUE = "true";
    private static final String NO = "no";
    private static final String FALSE = "false";

    @Override
    public void write(JsonWriter out, Boolean value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            out.value(value != false ? YES : NO);
        }
    }

    @Override
    public Boolean read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        String value = in.nextString();
        if (YES.equals(value) || TRUE.equals(value)) {
            return Boolean.TRUE;
        }
        if (NO.equals(value) || FALSE.equals(value)) {
            return Boolean.FALSE;
        }
        if (value.isEmpty()) {
            return null;
        }
        throw new IllegalArgumentException("Cannot parse JSON value '" + value + "' to Boolean.");
    }
}

