/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.observable;

import io.reactivex.Notification;
import io.reactivex.ObservableSource;
import io.reactivex.Observer;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.Function;
import io.reactivex.internal.disposables.DisposableHelper;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.operators.observable.AbstractObservableWithUpstream;
import io.reactivex.plugins.RxJavaPlugins;

public final class ObservableDematerialize<T, R>
extends AbstractObservableWithUpstream<T, R> {
    final Function<? super T, ? extends Notification<R>> selector;

    public ObservableDematerialize(ObservableSource<T> source2, Function<? super T, ? extends Notification<R>> selector) {
        super(source2);
        this.selector = selector;
    }

    @Override
    public void subscribeActual(Observer<? super R> observer) {
        this.source.subscribe(new DematerializeObserver<T, R>(observer, this.selector));
    }

    static final class DematerializeObserver<T, R>
    implements Observer<T>,
    Disposable {
        final Observer<? super R> downstream;
        final Function<? super T, ? extends Notification<R>> selector;
        boolean done;
        Disposable upstream;

        DematerializeObserver(Observer<? super R> downstream, Function<? super T, ? extends Notification<R>> selector) {
            this.downstream = downstream;
            this.selector = selector;
        }

        @Override
        public void onSubscribe(Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void dispose() {
            this.upstream.dispose();
        }

        @Override
        public boolean isDisposed() {
            return this.upstream.isDisposed();
        }

        @Override
        public void onNext(T item) {
            Notification<R> notification;
            if (this.done) {
                Notification notification2;
                if (item instanceof Notification && (notification2 = (Notification)item).isOnError()) {
                    RxJavaPlugins.onError(notification2.getError());
                }
                return;
            }
            try {
                notification = ObjectHelper.requireNonNull(this.selector.apply(item), "The selector returned a null Notification");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.dispose();
                this.onError(ex);
                return;
            }
            if (notification.isOnError()) {
                this.upstream.dispose();
                this.onError(notification.getError());
            } else if (notification.isOnComplete()) {
                this.upstream.dispose();
                this.onComplete();
            } else {
                this.downstream.onNext(notification.getValue());
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }
    }
}

