/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.internal;

import com.ibm.cloud.cloudant.security.CouchDbSessionAuthenticator;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.ConfigBasedAuthenticatorFactory;
import com.ibm.cloud.sdk.core.util.CredentialUtils;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DelegatingAuthenticatorFactory
extends ConfigBasedAuthenticatorFactory {
    private DelegatingAuthenticatorFactory() {
    }

    public static Authenticator getAuthenticator(String serviceName) {
        return DelegatingAuthenticatorFactory.createAuthenticator(CredentialUtils.getServiceProperties(serviceName));
    }

    protected static Authenticator createAuthenticator(Map<String, String> serviceProperties) {
        if (serviceProperties != null && !serviceProperties.isEmpty()) {
            String authType = serviceProperties.get("AUTH_TYPE");
            if (StringUtils.isEmpty(authType)) {
                authType = serviceProperties.get("AUTHTYPE");
            }
            if ("COUCHDB_SESSION".equalsIgnoreCase(authType)) {
                return CouchDbSessionAuthenticator.newAuthenticator(serviceProperties.get("USERNAME"), serviceProperties.get("PASSWORD"));
            }
        }
        return ConfigBasedAuthenticatorFactory.createAuthenticator(serviceProperties);
    }

    static Authenticator getAuthenticator(Map<String, String> dottedProperties) {
        String cloudantPrefix = "cloudant.";
        return DelegatingAuthenticatorFactory.createAuthenticator(dottedProperties.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("cloudant.")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring("cloudant.".length()).toUpperCase(Locale.ENGLISH).replace(".", "_"), entry -> (String)entry.getValue())));
    }
}

