/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1;

import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.ibm.cloud.cloudant.common.SdkCommon;
import com.ibm.cloud.cloudant.internal.CloudantBaseService;
import com.ibm.cloud.cloudant.internal.DelegatingAuthenticatorFactory;
import com.ibm.cloud.cloudant.v1.model.ActiveTask;
import com.ibm.cloud.cloudant.v1.model.ActivityTrackerEvents;
import com.ibm.cloud.cloudant.v1.model.AllDocsQueriesResult;
import com.ibm.cloud.cloudant.v1.model.AllDocsResult;
import com.ibm.cloud.cloudant.v1.model.ApiKeysResult;
import com.ibm.cloud.cloudant.v1.model.BulkGetResult;
import com.ibm.cloud.cloudant.v1.model.CapacityThroughputInformation;
import com.ibm.cloud.cloudant.v1.model.ChangesResult;
import com.ibm.cloud.cloudant.v1.model.CorsInformation;
import com.ibm.cloud.cloudant.v1.model.CurrentThroughputInformation;
import com.ibm.cloud.cloudant.v1.model.DatabaseInformation;
import com.ibm.cloud.cloudant.v1.model.DbUpdates;
import com.ibm.cloud.cloudant.v1.model.DbsInfoResult;
import com.ibm.cloud.cloudant.v1.model.DeleteAttachmentOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteDatabaseOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteDesignDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteIndexOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteLocalDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DeleteReplicationDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.DesignDocument;
import com.ibm.cloud.cloudant.v1.model.DesignDocumentInformation;
import com.ibm.cloud.cloudant.v1.model.Document;
import com.ibm.cloud.cloudant.v1.model.DocumentResult;
import com.ibm.cloud.cloudant.v1.model.DocumentShardInfo;
import com.ibm.cloud.cloudant.v1.model.ExplainResult;
import com.ibm.cloud.cloudant.v1.model.FindResult;
import com.ibm.cloud.cloudant.v1.model.GetActiveTasksOptions;
import com.ibm.cloud.cloudant.v1.model.GetActivityTrackerEventsOptions;
import com.ibm.cloud.cloudant.v1.model.GetAllDbsOptions;
import com.ibm.cloud.cloudant.v1.model.GetAttachmentOptions;
import com.ibm.cloud.cloudant.v1.model.GetCapacityThroughputInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetCorsInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetCurrentThroughputInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetDatabaseInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetDbUpdatesOptions;
import com.ibm.cloud.cloudant.v1.model.GetDesignDocumentInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetDesignDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetDocumentShardsInfoOptions;
import com.ibm.cloud.cloudant.v1.model.GetIndexesInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetLocalDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetMembershipInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetPartitionInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetReplicationDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetSchedulerDocsOptions;
import com.ibm.cloud.cloudant.v1.model.GetSchedulerDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.GetSchedulerJobOptions;
import com.ibm.cloud.cloudant.v1.model.GetSchedulerJobsOptions;
import com.ibm.cloud.cloudant.v1.model.GetSearchInfoOptions;
import com.ibm.cloud.cloudant.v1.model.GetSecurityOptions;
import com.ibm.cloud.cloudant.v1.model.GetServerInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetSessionInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetShardsInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetUpInformationOptions;
import com.ibm.cloud.cloudant.v1.model.GetUuidsOptions;
import com.ibm.cloud.cloudant.v1.model.HeadAttachmentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadDatabaseOptions;
import com.ibm.cloud.cloudant.v1.model.HeadDesignDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadLocalDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadReplicationDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadSchedulerDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.HeadSchedulerJobOptions;
import com.ibm.cloud.cloudant.v1.model.HeadUpInformationOptions;
import com.ibm.cloud.cloudant.v1.model.IndexResult;
import com.ibm.cloud.cloudant.v1.model.IndexesInformation;
import com.ibm.cloud.cloudant.v1.model.MembershipInformation;
import com.ibm.cloud.cloudant.v1.model.Ok;
import com.ibm.cloud.cloudant.v1.model.PartitionInformation;
import com.ibm.cloud.cloudant.v1.model.PostActivityTrackerEventsOptions;
import com.ibm.cloud.cloudant.v1.model.PostAllDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostAllDocsQueriesOptions;
import com.ibm.cloud.cloudant.v1.model.PostApiKeysOptions;
import com.ibm.cloud.cloudant.v1.model.PostBulkDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostBulkGetOptions;
import com.ibm.cloud.cloudant.v1.model.PostChangesOptions;
import com.ibm.cloud.cloudant.v1.model.PostDbsInfoOptions;
import com.ibm.cloud.cloudant.v1.model.PostDesignDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostDesignDocsQueriesOptions;
import com.ibm.cloud.cloudant.v1.model.PostDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PostExplainOptions;
import com.ibm.cloud.cloudant.v1.model.PostFindOptions;
import com.ibm.cloud.cloudant.v1.model.PostIndexOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionAllDocsOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionExplainOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionFindOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionSearchOptions;
import com.ibm.cloud.cloudant.v1.model.PostPartitionViewOptions;
import com.ibm.cloud.cloudant.v1.model.PostRevsDiffOptions;
import com.ibm.cloud.cloudant.v1.model.PostSearchAnalyzeOptions;
import com.ibm.cloud.cloudant.v1.model.PostSearchOptions;
import com.ibm.cloud.cloudant.v1.model.PostViewOptions;
import com.ibm.cloud.cloudant.v1.model.PostViewQueriesOptions;
import com.ibm.cloud.cloudant.v1.model.PutAttachmentOptions;
import com.ibm.cloud.cloudant.v1.model.PutCapacityThroughputConfigurationOptions;
import com.ibm.cloud.cloudant.v1.model.PutCloudantSecurityConfigurationOptions;
import com.ibm.cloud.cloudant.v1.model.PutCorsConfigurationOptions;
import com.ibm.cloud.cloudant.v1.model.PutDatabaseOptions;
import com.ibm.cloud.cloudant.v1.model.PutDesignDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutLocalDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutReplicationDocumentOptions;
import com.ibm.cloud.cloudant.v1.model.PutSecurityOptions;
import com.ibm.cloud.cloudant.v1.model.ReplicationDocument;
import com.ibm.cloud.cloudant.v1.model.RevsDiff;
import com.ibm.cloud.cloudant.v1.model.SchedulerDocsResult;
import com.ibm.cloud.cloudant.v1.model.SchedulerDocument;
import com.ibm.cloud.cloudant.v1.model.SchedulerJob;
import com.ibm.cloud.cloudant.v1.model.SchedulerJobsResult;
import com.ibm.cloud.cloudant.v1.model.SearchAnalyzeResult;
import com.ibm.cloud.cloudant.v1.model.SearchInfoResult;
import com.ibm.cloud.cloudant.v1.model.SearchResult;
import com.ibm.cloud.cloudant.v1.model.Security;
import com.ibm.cloud.cloudant.v1.model.ServerInformation;
import com.ibm.cloud.cloudant.v1.model.SessionInformation;
import com.ibm.cloud.cloudant.v1.model.ShardsInformation;
import com.ibm.cloud.cloudant.v1.model.UpInformation;
import com.ibm.cloud.cloudant.v1.model.UuidsResult;
import com.ibm.cloud.cloudant.v1.model.ViewQueriesResult;
import com.ibm.cloud.cloudant.v1.model.ViewResult;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ResponseConverter;
import com.ibm.cloud.sdk.core.http.ServiceCall;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.util.GsonSingleton;
import com.ibm.cloud.sdk.core.util.RequestUtils;
import com.ibm.cloud.sdk.core.util.ResponseConverterUtils;
import com.ibm.cloud.sdk.core.util.Validator;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class Cloudant
extends CloudantBaseService {
    private static final Logger LOGGER = Logger.getLogger(Cloudant.class.getName());
    public static final String DEFAULT_SERVICE_NAME = "cloudant";
    public static final String DEFAULT_SERVICE_URL = "https://~replace-with-cloudant-host~.cloudantnosqldb.appdomain.cloud";

    public static Cloudant newInstance() {
        return Cloudant.newInstance(DEFAULT_SERVICE_NAME);
    }

    public static Cloudant newInstance(String serviceName) {
        Authenticator authenticator = DelegatingAuthenticatorFactory.getAuthenticator(serviceName);
        Cloudant service = new Cloudant(serviceName, authenticator);
        service.configureService(serviceName);
        return service;
    }

    public Cloudant(String serviceName, Authenticator authenticator) {
        super(serviceName, authenticator);
        this.setServiceUrl(DEFAULT_SERVICE_URL);
        this.enableGzipCompression(true);
    }

    public ServiceCall<ServerInformation> getServerInformation(GetServerInformationOptions getServerInformationOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getServerInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ServerInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ServerInformation> getServerInformation() {
        return this.getServerInformation(null);
    }

    public ServiceCall<MembershipInformation> getMembershipInformation(GetMembershipInformationOptions getMembershipInformationOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_membership"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getMembershipInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<MembershipInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<MembershipInformation> getMembershipInformation() {
        return this.getMembershipInformation(null);
    }

    public ServiceCall<UuidsResult> getUuids(GetUuidsOptions getUuidsOptions) {
        if (getUuidsOptions == null) {
            getUuidsOptions = new GetUuidsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_uuids"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getUuids");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (getUuidsOptions.count() != null) {
            builder.query("count", String.valueOf(getUuidsOptions.count()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<UuidsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<UuidsResult> getUuids() {
        return this.getUuids(null);
    }

    public ServiceCall<CapacityThroughputInformation> getCapacityThroughputInformation(GetCapacityThroughputInformationOptions getCapacityThroughputInformationOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_api/v2/user/capacity/throughput"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getCapacityThroughputInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<CapacityThroughputInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CapacityThroughputInformation> getCapacityThroughputInformation() {
        return this.getCapacityThroughputInformation(null);
    }

    public ServiceCall<CapacityThroughputInformation> putCapacityThroughputConfiguration(PutCapacityThroughputConfigurationOptions putCapacityThroughputConfigurationOptions) {
        Validator.notNull(putCapacityThroughputConfigurationOptions, "putCapacityThroughputConfigurationOptions cannot be null");
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_api/v2/user/capacity/throughput"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putCapacityThroughputConfiguration");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("blocks", putCapacityThroughputConfigurationOptions.blocks());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<CapacityThroughputInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    @Deprecated
    public ServiceCall<DbUpdates> getDbUpdates(GetDbUpdatesOptions getDbUpdatesOptions) {
        LOGGER.warning("A deprecated operation has been invoked: getDbUpdates");
        if (getDbUpdatesOptions == null) {
            getDbUpdatesOptions = new GetDbUpdatesOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_db_updates"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getDbUpdates");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (getDbUpdatesOptions.descending() != null) {
            builder.query("descending", String.valueOf(getDbUpdatesOptions.descending()));
        }
        if (getDbUpdatesOptions.feed() != null) {
            builder.query("feed", String.valueOf(getDbUpdatesOptions.feed()));
        }
        if (getDbUpdatesOptions.heartbeat() != null) {
            builder.query("heartbeat", String.valueOf(getDbUpdatesOptions.heartbeat()));
        }
        if (getDbUpdatesOptions.limit() != null) {
            builder.query("limit", String.valueOf(getDbUpdatesOptions.limit()));
        }
        if (getDbUpdatesOptions.timeout() != null) {
            builder.query("timeout", String.valueOf(getDbUpdatesOptions.timeout()));
        }
        if (getDbUpdatesOptions.since() != null) {
            builder.query("since", String.valueOf(getDbUpdatesOptions.since()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DbUpdates>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    @Deprecated
    public ServiceCall<DbUpdates> getDbUpdates() {
        return this.getDbUpdates(null);
    }

    public ServiceCall<ChangesResult> postChanges(PostChangesOptions postChangesOptions) {
        Validator.notNull(postChangesOptions, "postChangesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postChangesOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_changes", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postChanges");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (postChangesOptions.lastEventId() != null) {
            builder.header("Last-Event-ID", postChangesOptions.lastEventId());
        }
        if (postChangesOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(postChangesOptions.attEncodingInfo()));
        }
        if (postChangesOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(postChangesOptions.attachments()));
        }
        if (postChangesOptions.conflicts() != null) {
            builder.query("conflicts", String.valueOf(postChangesOptions.conflicts()));
        }
        if (postChangesOptions.descending() != null) {
            builder.query("descending", String.valueOf(postChangesOptions.descending()));
        }
        if (postChangesOptions.feed() != null) {
            builder.query("feed", String.valueOf(postChangesOptions.feed()));
        }
        if (postChangesOptions.filter() != null) {
            builder.query("filter", String.valueOf(postChangesOptions.filter()));
        }
        if (postChangesOptions.heartbeat() != null) {
            builder.query("heartbeat", String.valueOf(postChangesOptions.heartbeat()));
        }
        if (postChangesOptions.includeDocs() != null) {
            builder.query("include_docs", String.valueOf(postChangesOptions.includeDocs()));
        }
        if (postChangesOptions.limit() != null) {
            builder.query("limit", String.valueOf(postChangesOptions.limit()));
        }
        if (postChangesOptions.seqInterval() != null) {
            builder.query("seq_interval", String.valueOf(postChangesOptions.seqInterval()));
        }
        if (postChangesOptions.since() != null) {
            builder.query("since", String.valueOf(postChangesOptions.since()));
        }
        if (postChangesOptions.style() != null) {
            builder.query("style", String.valueOf(postChangesOptions.style()));
        }
        if (postChangesOptions.timeout() != null) {
            builder.query("timeout", String.valueOf(postChangesOptions.timeout()));
        }
        if (postChangesOptions.view() != null) {
            builder.query("view", String.valueOf(postChangesOptions.view()));
        }
        JsonObject contentJson = new JsonObject();
        if (postChangesOptions.docIds() != null) {
            contentJson.add("doc_ids", GsonSingleton.getGson().toJsonTree(postChangesOptions.docIds()));
        }
        if (postChangesOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postChangesOptions.fields()));
        }
        if (postChangesOptions.selector() != null) {
            contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postChangesOptions.selector()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ChangesResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postChangesAsStream(PostChangesOptions postChangesOptions) {
        Validator.notNull(postChangesOptions, "postChangesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postChangesOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_changes", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postChangesAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (postChangesOptions.lastEventId() != null) {
            builder.header("Last-Event-ID", postChangesOptions.lastEventId());
        }
        if (postChangesOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(postChangesOptions.attEncodingInfo()));
        }
        if (postChangesOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(postChangesOptions.attachments()));
        }
        if (postChangesOptions.conflicts() != null) {
            builder.query("conflicts", String.valueOf(postChangesOptions.conflicts()));
        }
        if (postChangesOptions.descending() != null) {
            builder.query("descending", String.valueOf(postChangesOptions.descending()));
        }
        if (postChangesOptions.feed() != null) {
            builder.query("feed", String.valueOf(postChangesOptions.feed()));
        }
        if (postChangesOptions.filter() != null) {
            builder.query("filter", String.valueOf(postChangesOptions.filter()));
        }
        if (postChangesOptions.heartbeat() != null) {
            builder.query("heartbeat", String.valueOf(postChangesOptions.heartbeat()));
        }
        if (postChangesOptions.includeDocs() != null) {
            builder.query("include_docs", String.valueOf(postChangesOptions.includeDocs()));
        }
        if (postChangesOptions.limit() != null) {
            builder.query("limit", String.valueOf(postChangesOptions.limit()));
        }
        if (postChangesOptions.seqInterval() != null) {
            builder.query("seq_interval", String.valueOf(postChangesOptions.seqInterval()));
        }
        if (postChangesOptions.since() != null) {
            builder.query("since", String.valueOf(postChangesOptions.since()));
        }
        if (postChangesOptions.style() != null) {
            builder.query("style", String.valueOf(postChangesOptions.style()));
        }
        if (postChangesOptions.timeout() != null) {
            builder.query("timeout", String.valueOf(postChangesOptions.timeout()));
        }
        if (postChangesOptions.view() != null) {
            builder.query("view", String.valueOf(postChangesOptions.view()));
        }
        JsonObject contentJson = new JsonObject();
        if (postChangesOptions.docIds() != null) {
            contentJson.add("doc_ids", GsonSingleton.getGson().toJsonTree(postChangesOptions.docIds()));
        }
        if (postChangesOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postChangesOptions.fields()));
        }
        if (postChangesOptions.selector() != null) {
            contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postChangesOptions.selector()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headDatabase(HeadDatabaseOptions headDatabaseOptions) {
        Validator.notNull(headDatabaseOptions, "headDatabaseOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", headDatabaseOptions.db());
        RequestBuilder builder = RequestBuilder.head(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "headDatabase");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<String>> getAllDbs(GetAllDbsOptions getAllDbsOptions) {
        if (getAllDbsOptions == null) {
            getAllDbsOptions = new GetAllDbsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_all_dbs"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getAllDbs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (getAllDbsOptions.descending() != null) {
            builder.query("descending", String.valueOf(getAllDbsOptions.descending()));
        }
        if (getAllDbsOptions.endKey() != null) {
            builder.query("end_key", String.valueOf(getAllDbsOptions.endKey()));
        }
        if (getAllDbsOptions.limit() != null) {
            builder.query("limit", String.valueOf(getAllDbsOptions.limit()));
        }
        if (getAllDbsOptions.skip() != null) {
            builder.query("skip", String.valueOf(getAllDbsOptions.skip()));
        }
        if (getAllDbsOptions.startKey() != null) {
            builder.query("start_key", String.valueOf(getAllDbsOptions.startKey()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<List<String>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<String>> getAllDbs() {
        return this.getAllDbs(null);
    }

    public ServiceCall<List<DbsInfoResult>> postDbsInfo(PostDbsInfoOptions postDbsInfoOptions) {
        Validator.notNull(postDbsInfoOptions, "postDbsInfoOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_dbs_info"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postDbsInfo");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postDbsInfoOptions.keys()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<List<DbsInfoResult>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> deleteDatabase(DeleteDatabaseOptions deleteDatabaseOptions) {
        Validator.notNull(deleteDatabaseOptions, "deleteDatabaseOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", deleteDatabaseOptions.db());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "deleteDatabase");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DatabaseInformation> getDatabaseInformation(GetDatabaseInformationOptions getDatabaseInformationOptions) {
        Validator.notNull(getDatabaseInformationOptions, "getDatabaseInformationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getDatabaseInformationOptions.db());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getDatabaseInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DatabaseInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> putDatabase(PutDatabaseOptions putDatabaseOptions) {
        Validator.notNull(putDatabaseOptions, "putDatabaseOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", putDatabaseOptions.db());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putDatabase");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (putDatabaseOptions.partitioned() != null) {
            builder.query("partitioned", String.valueOf(putDatabaseOptions.partitioned()));
        }
        if (putDatabaseOptions.q() != null) {
            builder.query("q", String.valueOf(putDatabaseOptions.q()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headDocument(HeadDocumentOptions headDocumentOptions) {
        Validator.notNull(headDocumentOptions, "headDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", headDocumentOptions.db());
        pathParamsMap.put("doc_id", headDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.head(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "headDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (headDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", headDocumentOptions.ifNoneMatch());
        }
        if (headDocumentOptions.latest() != null) {
            builder.query("latest", String.valueOf(headDocumentOptions.latest()));
        }
        if (headDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(headDocumentOptions.rev()));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> postDocument(PostDocumentOptions postDocumentOptions) {
        Validator.notNull(postDocumentOptions, "postDocumentOptions cannot be null");
        Validator.isTrue(postDocumentOptions.document() != null || postDocumentOptions.body() != null, "One of [postDocumentOptions.document(), postDocumentOptions.body()] must be specified");
        if (postDocumentOptions.document() != null && postDocumentOptions.contentType() == null) {
            postDocumentOptions = postDocumentOptions.newBuilder().contentType("application/json").build();
        }
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postDocumentOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (postDocumentOptions.contentType() != null) {
            builder.header("Content-Type", postDocumentOptions.contentType());
        }
        if (postDocumentOptions.batch() != null) {
            builder.query("batch", String.valueOf(postDocumentOptions.batch()));
        }
        builder.bodyContent(postDocumentOptions.contentType(), (Object)postDocumentOptions.document(), null, postDocumentOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsResult> postAllDocs(PostAllDocsOptions postAllDocsOptions) {
        Validator.notNull(postAllDocsOptions, "postAllDocsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postAllDocsOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_all_docs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postAllDocs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (postAllDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postAllDocsOptions.attEncodingInfo());
        }
        if (postAllDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postAllDocsOptions.attachments());
        }
        if (postAllDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postAllDocsOptions.conflicts());
        }
        if (postAllDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postAllDocsOptions.descending());
        }
        if (postAllDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postAllDocsOptions.includeDocs());
        }
        if (postAllDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postAllDocsOptions.inclusiveEnd());
        }
        if (postAllDocsOptions.limit() != null) {
            contentJson.addProperty("limit", postAllDocsOptions.limit());
        }
        if (postAllDocsOptions.skip() != null) {
            contentJson.addProperty("skip", postAllDocsOptions.skip());
        }
        if (postAllDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postAllDocsOptions.updateSeq());
        }
        if (postAllDocsOptions.endKey() != null) {
            contentJson.addProperty("end_key", postAllDocsOptions.endKey());
        }
        if (postAllDocsOptions.key() != null) {
            contentJson.addProperty("key", postAllDocsOptions.key());
        }
        if (postAllDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postAllDocsOptions.keys()));
        }
        if (postAllDocsOptions.startKey() != null) {
            contentJson.addProperty("start_key", postAllDocsOptions.startKey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AllDocsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postAllDocsAsStream(PostAllDocsOptions postAllDocsOptions) {
        Validator.notNull(postAllDocsOptions, "postAllDocsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postAllDocsOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_all_docs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postAllDocsAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (postAllDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postAllDocsOptions.attEncodingInfo());
        }
        if (postAllDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postAllDocsOptions.attachments());
        }
        if (postAllDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postAllDocsOptions.conflicts());
        }
        if (postAllDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postAllDocsOptions.descending());
        }
        if (postAllDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postAllDocsOptions.includeDocs());
        }
        if (postAllDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postAllDocsOptions.inclusiveEnd());
        }
        if (postAllDocsOptions.limit() != null) {
            contentJson.addProperty("limit", postAllDocsOptions.limit());
        }
        if (postAllDocsOptions.skip() != null) {
            contentJson.addProperty("skip", postAllDocsOptions.skip());
        }
        if (postAllDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postAllDocsOptions.updateSeq());
        }
        if (postAllDocsOptions.endKey() != null) {
            contentJson.addProperty("end_key", postAllDocsOptions.endKey());
        }
        if (postAllDocsOptions.key() != null) {
            contentJson.addProperty("key", postAllDocsOptions.key());
        }
        if (postAllDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postAllDocsOptions.keys()));
        }
        if (postAllDocsOptions.startKey() != null) {
            contentJson.addProperty("start_key", postAllDocsOptions.startKey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsQueriesResult> postAllDocsQueries(PostAllDocsQueriesOptions postAllDocsQueriesOptions) {
        Validator.notNull(postAllDocsQueriesOptions, "postAllDocsQueriesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postAllDocsQueriesOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_all_docs/queries", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postAllDocsQueries");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postAllDocsQueriesOptions.queries()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AllDocsQueriesResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postAllDocsQueriesAsStream(PostAllDocsQueriesOptions postAllDocsQueriesOptions) {
        Validator.notNull(postAllDocsQueriesOptions, "postAllDocsQueriesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postAllDocsQueriesOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_all_docs/queries", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postAllDocsQueriesAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postAllDocsQueriesOptions.queries()));
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<DocumentResult>> postBulkDocs(PostBulkDocsOptions postBulkDocsOptions) {
        Validator.notNull(postBulkDocsOptions, "postBulkDocsOptions cannot be null");
        Validator.isTrue(postBulkDocsOptions.bulkDocs() != null || postBulkDocsOptions.body() != null, "One of [postBulkDocsOptions.bulkDocs(), postBulkDocsOptions.body()] must be specified");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postBulkDocsOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_bulk_docs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postBulkDocs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.bodyContent("application/json", (Object)postBulkDocsOptions.bulkDocs(), null, postBulkDocsOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<List<DocumentResult>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<BulkGetResult> postBulkGet(PostBulkGetOptions postBulkGetOptions) {
        Validator.notNull(postBulkGetOptions, "postBulkGetOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postBulkGetOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_bulk_get", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postBulkGet");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (postBulkGetOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(postBulkGetOptions.attachments()));
        }
        if (postBulkGetOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(postBulkGetOptions.attEncodingInfo()));
        }
        if (postBulkGetOptions.latest() != null) {
            builder.query("latest", String.valueOf(postBulkGetOptions.latest()));
        }
        if (postBulkGetOptions.revs() != null) {
            builder.query("revs", String.valueOf(postBulkGetOptions.revs()));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("docs", GsonSingleton.getGson().toJsonTree(postBulkGetOptions.docs()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<BulkGetResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postBulkGetAsMixed(PostBulkGetOptions postBulkGetOptions) {
        Validator.notNull(postBulkGetOptions, "postBulkGetOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postBulkGetOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_bulk_get", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postBulkGetAsMixed");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "multipart/mixed");
        if (postBulkGetOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(postBulkGetOptions.attachments()));
        }
        if (postBulkGetOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(postBulkGetOptions.attEncodingInfo()));
        }
        if (postBulkGetOptions.latest() != null) {
            builder.query("latest", String.valueOf(postBulkGetOptions.latest()));
        }
        if (postBulkGetOptions.revs() != null) {
            builder.query("revs", String.valueOf(postBulkGetOptions.revs()));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("docs", GsonSingleton.getGson().toJsonTree(postBulkGetOptions.docs()));
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postBulkGetAsRelated(PostBulkGetOptions postBulkGetOptions) {
        Validator.notNull(postBulkGetOptions, "postBulkGetOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postBulkGetOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_bulk_get", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postBulkGetAsRelated");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "multipart/related");
        if (postBulkGetOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(postBulkGetOptions.attachments()));
        }
        if (postBulkGetOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(postBulkGetOptions.attEncodingInfo()));
        }
        if (postBulkGetOptions.latest() != null) {
            builder.query("latest", String.valueOf(postBulkGetOptions.latest()));
        }
        if (postBulkGetOptions.revs() != null) {
            builder.query("revs", String.valueOf(postBulkGetOptions.revs()));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("docs", GsonSingleton.getGson().toJsonTree(postBulkGetOptions.docs()));
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postBulkGetAsStream(PostBulkGetOptions postBulkGetOptions) {
        Validator.notNull(postBulkGetOptions, "postBulkGetOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postBulkGetOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_bulk_get", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postBulkGetAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (postBulkGetOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(postBulkGetOptions.attachments()));
        }
        if (postBulkGetOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(postBulkGetOptions.attEncodingInfo()));
        }
        if (postBulkGetOptions.latest() != null) {
            builder.query("latest", String.valueOf(postBulkGetOptions.latest()));
        }
        if (postBulkGetOptions.revs() != null) {
            builder.query("revs", String.valueOf(postBulkGetOptions.revs()));
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("docs", GsonSingleton.getGson().toJsonTree(postBulkGetOptions.docs()));
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> deleteDocument(DeleteDocumentOptions deleteDocumentOptions) {
        Validator.notNull(deleteDocumentOptions, "deleteDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", deleteDocumentOptions.db());
        pathParamsMap.put("doc_id", deleteDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "deleteDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (deleteDocumentOptions.ifMatch() != null) {
            builder.header("If-Match", deleteDocumentOptions.ifMatch());
        }
        if (deleteDocumentOptions.batch() != null) {
            builder.query("batch", String.valueOf(deleteDocumentOptions.batch()));
        }
        if (deleteDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(deleteDocumentOptions.rev()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Document> getDocument(GetDocumentOptions getDocumentOptions) {
        Validator.notNull(getDocumentOptions, "getDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getDocumentOptions.db());
        pathParamsMap.put("doc_id", getDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (getDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", getDocumentOptions.ifNoneMatch());
        }
        if (getDocumentOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(getDocumentOptions.attachments()));
        }
        if (getDocumentOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(getDocumentOptions.attEncodingInfo()));
        }
        if (getDocumentOptions.conflicts() != null) {
            builder.query("conflicts", String.valueOf(getDocumentOptions.conflicts()));
        }
        if (getDocumentOptions.deletedConflicts() != null) {
            builder.query("deleted_conflicts", String.valueOf(getDocumentOptions.deletedConflicts()));
        }
        if (getDocumentOptions.latest() != null) {
            builder.query("latest", String.valueOf(getDocumentOptions.latest()));
        }
        if (getDocumentOptions.localSeq() != null) {
            builder.query("local_seq", String.valueOf(getDocumentOptions.localSeq()));
        }
        if (getDocumentOptions.meta() != null) {
            builder.query("meta", String.valueOf(getDocumentOptions.meta()));
        }
        if (getDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(getDocumentOptions.rev()));
        }
        if (getDocumentOptions.revs() != null) {
            builder.query("revs", String.valueOf(getDocumentOptions.revs()));
        }
        if (getDocumentOptions.revsInfo() != null) {
            builder.query("revs_info", String.valueOf(getDocumentOptions.revsInfo()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Document>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getDocumentAsMixed(GetDocumentOptions getDocumentOptions) {
        Validator.notNull(getDocumentOptions, "getDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getDocumentOptions.db());
        pathParamsMap.put("doc_id", getDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getDocumentAsMixed");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "multipart/mixed");
        if (getDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", getDocumentOptions.ifNoneMatch());
        }
        if (getDocumentOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(getDocumentOptions.attachments()));
        }
        if (getDocumentOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(getDocumentOptions.attEncodingInfo()));
        }
        if (getDocumentOptions.conflicts() != null) {
            builder.query("conflicts", String.valueOf(getDocumentOptions.conflicts()));
        }
        if (getDocumentOptions.deletedConflicts() != null) {
            builder.query("deleted_conflicts", String.valueOf(getDocumentOptions.deletedConflicts()));
        }
        if (getDocumentOptions.latest() != null) {
            builder.query("latest", String.valueOf(getDocumentOptions.latest()));
        }
        if (getDocumentOptions.localSeq() != null) {
            builder.query("local_seq", String.valueOf(getDocumentOptions.localSeq()));
        }
        if (getDocumentOptions.meta() != null) {
            builder.query("meta", String.valueOf(getDocumentOptions.meta()));
        }
        if (getDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(getDocumentOptions.rev()));
        }
        if (getDocumentOptions.revs() != null) {
            builder.query("revs", String.valueOf(getDocumentOptions.revs()));
        }
        if (getDocumentOptions.revsInfo() != null) {
            builder.query("revs_info", String.valueOf(getDocumentOptions.revsInfo()));
        }
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getDocumentAsRelated(GetDocumentOptions getDocumentOptions) {
        Validator.notNull(getDocumentOptions, "getDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getDocumentOptions.db());
        pathParamsMap.put("doc_id", getDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getDocumentAsRelated");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "multipart/related");
        if (getDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", getDocumentOptions.ifNoneMatch());
        }
        if (getDocumentOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(getDocumentOptions.attachments()));
        }
        if (getDocumentOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(getDocumentOptions.attEncodingInfo()));
        }
        if (getDocumentOptions.conflicts() != null) {
            builder.query("conflicts", String.valueOf(getDocumentOptions.conflicts()));
        }
        if (getDocumentOptions.deletedConflicts() != null) {
            builder.query("deleted_conflicts", String.valueOf(getDocumentOptions.deletedConflicts()));
        }
        if (getDocumentOptions.latest() != null) {
            builder.query("latest", String.valueOf(getDocumentOptions.latest()));
        }
        if (getDocumentOptions.localSeq() != null) {
            builder.query("local_seq", String.valueOf(getDocumentOptions.localSeq()));
        }
        if (getDocumentOptions.meta() != null) {
            builder.query("meta", String.valueOf(getDocumentOptions.meta()));
        }
        if (getDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(getDocumentOptions.rev()));
        }
        if (getDocumentOptions.revs() != null) {
            builder.query("revs", String.valueOf(getDocumentOptions.revs()));
        }
        if (getDocumentOptions.revsInfo() != null) {
            builder.query("revs_info", String.valueOf(getDocumentOptions.revsInfo()));
        }
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getDocumentAsStream(GetDocumentOptions getDocumentOptions) {
        Validator.notNull(getDocumentOptions, "getDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getDocumentOptions.db());
        pathParamsMap.put("doc_id", getDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getDocumentAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (getDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", getDocumentOptions.ifNoneMatch());
        }
        if (getDocumentOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(getDocumentOptions.attachments()));
        }
        if (getDocumentOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(getDocumentOptions.attEncodingInfo()));
        }
        if (getDocumentOptions.conflicts() != null) {
            builder.query("conflicts", String.valueOf(getDocumentOptions.conflicts()));
        }
        if (getDocumentOptions.deletedConflicts() != null) {
            builder.query("deleted_conflicts", String.valueOf(getDocumentOptions.deletedConflicts()));
        }
        if (getDocumentOptions.latest() != null) {
            builder.query("latest", String.valueOf(getDocumentOptions.latest()));
        }
        if (getDocumentOptions.localSeq() != null) {
            builder.query("local_seq", String.valueOf(getDocumentOptions.localSeq()));
        }
        if (getDocumentOptions.meta() != null) {
            builder.query("meta", String.valueOf(getDocumentOptions.meta()));
        }
        if (getDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(getDocumentOptions.rev()));
        }
        if (getDocumentOptions.revs() != null) {
            builder.query("revs", String.valueOf(getDocumentOptions.revs()));
        }
        if (getDocumentOptions.revsInfo() != null) {
            builder.query("revs_info", String.valueOf(getDocumentOptions.revsInfo()));
        }
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putDocument(PutDocumentOptions putDocumentOptions) {
        Validator.notNull(putDocumentOptions, "putDocumentOptions cannot be null");
        Validator.isTrue(putDocumentOptions.document() != null || putDocumentOptions.body() != null, "One of [putDocumentOptions.document(), putDocumentOptions.body()] must be specified");
        if (putDocumentOptions.document() != null && putDocumentOptions.contentType() == null) {
            putDocumentOptions = putDocumentOptions.newBuilder().contentType("application/json").build();
        }
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", putDocumentOptions.db());
        pathParamsMap.put("doc_id", putDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (putDocumentOptions.contentType() != null) {
            builder.header("Content-Type", putDocumentOptions.contentType());
        }
        if (putDocumentOptions.ifMatch() != null) {
            builder.header("If-Match", putDocumentOptions.ifMatch());
        }
        if (putDocumentOptions.batch() != null) {
            builder.query("batch", String.valueOf(putDocumentOptions.batch()));
        }
        if (putDocumentOptions.newEdits() != null) {
            builder.query("new_edits", String.valueOf(putDocumentOptions.newEdits()));
        }
        if (putDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(putDocumentOptions.rev()));
        }
        builder.bodyContent(putDocumentOptions.contentType(), (Object)putDocumentOptions.document(), null, putDocumentOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headDesignDocument(HeadDesignDocumentOptions headDesignDocumentOptions) {
        Validator.notNull(headDesignDocumentOptions, "headDesignDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", headDesignDocumentOptions.db());
        pathParamsMap.put("ddoc", headDesignDocumentOptions.ddoc());
        RequestBuilder builder = RequestBuilder.head(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "headDesignDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (headDesignDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", headDesignDocumentOptions.ifNoneMatch());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> deleteDesignDocument(DeleteDesignDocumentOptions deleteDesignDocumentOptions) {
        Validator.notNull(deleteDesignDocumentOptions, "deleteDesignDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", deleteDesignDocumentOptions.db());
        pathParamsMap.put("ddoc", deleteDesignDocumentOptions.ddoc());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "deleteDesignDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (deleteDesignDocumentOptions.ifMatch() != null) {
            builder.header("If-Match", deleteDesignDocumentOptions.ifMatch());
        }
        if (deleteDesignDocumentOptions.batch() != null) {
            builder.query("batch", String.valueOf(deleteDesignDocumentOptions.batch()));
        }
        if (deleteDesignDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(deleteDesignDocumentOptions.rev()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DesignDocument> getDesignDocument(GetDesignDocumentOptions getDesignDocumentOptions) {
        Validator.notNull(getDesignDocumentOptions, "getDesignDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getDesignDocumentOptions.db());
        pathParamsMap.put("ddoc", getDesignDocumentOptions.ddoc());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getDesignDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (getDesignDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", getDesignDocumentOptions.ifNoneMatch());
        }
        if (getDesignDocumentOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(getDesignDocumentOptions.attachments()));
        }
        if (getDesignDocumentOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(getDesignDocumentOptions.attEncodingInfo()));
        }
        if (getDesignDocumentOptions.conflicts() != null) {
            builder.query("conflicts", String.valueOf(getDesignDocumentOptions.conflicts()));
        }
        if (getDesignDocumentOptions.deletedConflicts() != null) {
            builder.query("deleted_conflicts", String.valueOf(getDesignDocumentOptions.deletedConflicts()));
        }
        if (getDesignDocumentOptions.latest() != null) {
            builder.query("latest", String.valueOf(getDesignDocumentOptions.latest()));
        }
        if (getDesignDocumentOptions.localSeq() != null) {
            builder.query("local_seq", String.valueOf(getDesignDocumentOptions.localSeq()));
        }
        if (getDesignDocumentOptions.meta() != null) {
            builder.query("meta", String.valueOf(getDesignDocumentOptions.meta()));
        }
        if (getDesignDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(getDesignDocumentOptions.rev()));
        }
        if (getDesignDocumentOptions.revs() != null) {
            builder.query("revs", String.valueOf(getDesignDocumentOptions.revs()));
        }
        if (getDesignDocumentOptions.revsInfo() != null) {
            builder.query("revs_info", String.valueOf(getDesignDocumentOptions.revsInfo()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DesignDocument>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putDesignDocument(PutDesignDocumentOptions putDesignDocumentOptions) {
        Validator.notNull(putDesignDocumentOptions, "putDesignDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", putDesignDocumentOptions.db());
        pathParamsMap.put("ddoc", putDesignDocumentOptions.ddoc());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putDesignDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (putDesignDocumentOptions.ifMatch() != null) {
            builder.header("If-Match", putDesignDocumentOptions.ifMatch());
        }
        if (putDesignDocumentOptions.batch() != null) {
            builder.query("batch", String.valueOf(putDesignDocumentOptions.batch()));
        }
        if (putDesignDocumentOptions.newEdits() != null) {
            builder.query("new_edits", String.valueOf(putDesignDocumentOptions.newEdits()));
        }
        if (putDesignDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(putDesignDocumentOptions.rev()));
        }
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(putDesignDocumentOptions.designDocument()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DesignDocumentInformation> getDesignDocumentInformation(GetDesignDocumentInformationOptions getDesignDocumentInformationOptions) {
        Validator.notNull(getDesignDocumentInformationOptions, "getDesignDocumentInformationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getDesignDocumentInformationOptions.db());
        pathParamsMap.put("ddoc", getDesignDocumentInformationOptions.ddoc());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}/_info", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getDesignDocumentInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DesignDocumentInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsResult> postDesignDocs(PostDesignDocsOptions postDesignDocsOptions) {
        Validator.notNull(postDesignDocsOptions, "postDesignDocsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postDesignDocsOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design_docs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postDesignDocs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (postDesignDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postDesignDocsOptions.attEncodingInfo());
        }
        if (postDesignDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postDesignDocsOptions.attachments());
        }
        if (postDesignDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postDesignDocsOptions.conflicts());
        }
        if (postDesignDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postDesignDocsOptions.descending());
        }
        if (postDesignDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postDesignDocsOptions.includeDocs());
        }
        if (postDesignDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postDesignDocsOptions.inclusiveEnd());
        }
        if (postDesignDocsOptions.limit() != null) {
            contentJson.addProperty("limit", postDesignDocsOptions.limit());
        }
        if (postDesignDocsOptions.skip() != null) {
            contentJson.addProperty("skip", postDesignDocsOptions.skip());
        }
        if (postDesignDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postDesignDocsOptions.updateSeq());
        }
        if (postDesignDocsOptions.endKey() != null) {
            contentJson.addProperty("end_key", postDesignDocsOptions.endKey());
        }
        if (postDesignDocsOptions.key() != null) {
            contentJson.addProperty("key", postDesignDocsOptions.key());
        }
        if (postDesignDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postDesignDocsOptions.keys()));
        }
        if (postDesignDocsOptions.startKey() != null) {
            contentJson.addProperty("start_key", postDesignDocsOptions.startKey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AllDocsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsQueriesResult> postDesignDocsQueries(PostDesignDocsQueriesOptions postDesignDocsQueriesOptions) {
        Validator.notNull(postDesignDocsQueriesOptions, "postDesignDocsQueriesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postDesignDocsQueriesOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design_docs/queries", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postDesignDocsQueries");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (postDesignDocsQueriesOptions.accept() != null) {
            builder.header("Accept", postDesignDocsQueriesOptions.accept());
        }
        JsonObject contentJson = new JsonObject();
        contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postDesignDocsQueriesOptions.queries()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AllDocsQueriesResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ViewResult> postView(PostViewOptions postViewOptions) {
        Validator.notNull(postViewOptions, "postViewOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postViewOptions.db());
        pathParamsMap.put("ddoc", postViewOptions.ddoc());
        pathParamsMap.put("view", postViewOptions.view());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}/_view/{view}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postView");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (postViewOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postViewOptions.attEncodingInfo());
        }
        if (postViewOptions.attachments() != null) {
            contentJson.addProperty("attachments", postViewOptions.attachments());
        }
        if (postViewOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postViewOptions.conflicts());
        }
        if (postViewOptions.descending() != null) {
            contentJson.addProperty("descending", postViewOptions.descending());
        }
        if (postViewOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postViewOptions.includeDocs());
        }
        if (postViewOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postViewOptions.inclusiveEnd());
        }
        if (postViewOptions.limit() != null) {
            contentJson.addProperty("limit", postViewOptions.limit());
        }
        if (postViewOptions.skip() != null) {
            contentJson.addProperty("skip", postViewOptions.skip());
        }
        if (postViewOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postViewOptions.updateSeq());
        }
        if (postViewOptions.endKey() != null) {
            contentJson.add("end_key", GsonSingleton.getGson().toJsonTree(postViewOptions.endKey()));
        }
        if (postViewOptions.endKeyDocId() != null) {
            contentJson.addProperty("end_key_doc_id", postViewOptions.endKeyDocId());
        }
        if (postViewOptions.group() != null) {
            contentJson.addProperty("group", postViewOptions.group());
        }
        if (postViewOptions.groupLevel() != null) {
            contentJson.addProperty("group_level", postViewOptions.groupLevel());
        }
        if (postViewOptions.key() != null) {
            contentJson.add("key", GsonSingleton.getGson().toJsonTree(postViewOptions.key()));
        }
        if (postViewOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postViewOptions.keys()));
        }
        if (postViewOptions.reduce() != null) {
            contentJson.addProperty("reduce", postViewOptions.reduce());
        }
        if (postViewOptions.stable() != null) {
            contentJson.addProperty("stable", postViewOptions.stable());
        }
        if (postViewOptions.startKey() != null) {
            contentJson.add("start_key", GsonSingleton.getGson().toJsonTree(postViewOptions.startKey()));
        }
        if (postViewOptions.startKeyDocId() != null) {
            contentJson.addProperty("start_key_doc_id", postViewOptions.startKeyDocId());
        }
        if (postViewOptions.update() != null) {
            contentJson.addProperty("update", postViewOptions.update());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ViewResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postViewAsStream(PostViewOptions postViewOptions) {
        Validator.notNull(postViewOptions, "postViewOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postViewOptions.db());
        pathParamsMap.put("ddoc", postViewOptions.ddoc());
        pathParamsMap.put("view", postViewOptions.view());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}/_view/{view}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postViewAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (postViewOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postViewOptions.attEncodingInfo());
        }
        if (postViewOptions.attachments() != null) {
            contentJson.addProperty("attachments", postViewOptions.attachments());
        }
        if (postViewOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postViewOptions.conflicts());
        }
        if (postViewOptions.descending() != null) {
            contentJson.addProperty("descending", postViewOptions.descending());
        }
        if (postViewOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postViewOptions.includeDocs());
        }
        if (postViewOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postViewOptions.inclusiveEnd());
        }
        if (postViewOptions.limit() != null) {
            contentJson.addProperty("limit", postViewOptions.limit());
        }
        if (postViewOptions.skip() != null) {
            contentJson.addProperty("skip", postViewOptions.skip());
        }
        if (postViewOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postViewOptions.updateSeq());
        }
        if (postViewOptions.endKey() != null) {
            contentJson.add("end_key", GsonSingleton.getGson().toJsonTree(postViewOptions.endKey()));
        }
        if (postViewOptions.endKeyDocId() != null) {
            contentJson.addProperty("end_key_doc_id", postViewOptions.endKeyDocId());
        }
        if (postViewOptions.group() != null) {
            contentJson.addProperty("group", postViewOptions.group());
        }
        if (postViewOptions.groupLevel() != null) {
            contentJson.addProperty("group_level", postViewOptions.groupLevel());
        }
        if (postViewOptions.key() != null) {
            contentJson.add("key", GsonSingleton.getGson().toJsonTree(postViewOptions.key()));
        }
        if (postViewOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postViewOptions.keys()));
        }
        if (postViewOptions.reduce() != null) {
            contentJson.addProperty("reduce", postViewOptions.reduce());
        }
        if (postViewOptions.stable() != null) {
            contentJson.addProperty("stable", postViewOptions.stable());
        }
        if (postViewOptions.startKey() != null) {
            contentJson.add("start_key", GsonSingleton.getGson().toJsonTree(postViewOptions.startKey()));
        }
        if (postViewOptions.startKeyDocId() != null) {
            contentJson.addProperty("start_key_doc_id", postViewOptions.startKeyDocId());
        }
        if (postViewOptions.update() != null) {
            contentJson.addProperty("update", postViewOptions.update());
        }
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ViewQueriesResult> postViewQueries(PostViewQueriesOptions postViewQueriesOptions) {
        Validator.notNull(postViewQueriesOptions, "postViewQueriesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postViewQueriesOptions.db());
        pathParamsMap.put("ddoc", postViewQueriesOptions.ddoc());
        pathParamsMap.put("view", postViewQueriesOptions.view());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}/_view/{view}/queries", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postViewQueries");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postViewQueriesOptions.queries()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ViewQueriesResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postViewQueriesAsStream(PostViewQueriesOptions postViewQueriesOptions) {
        Validator.notNull(postViewQueriesOptions, "postViewQueriesOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postViewQueriesOptions.db());
        pathParamsMap.put("ddoc", postViewQueriesOptions.ddoc());
        pathParamsMap.put("view", postViewQueriesOptions.view());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}/_view/{view}/queries", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postViewQueriesAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("queries", GsonSingleton.getGson().toJsonTree(postViewQueriesOptions.queries()));
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<PartitionInformation> getPartitionInformation(GetPartitionInformationOptions getPartitionInformationOptions) {
        Validator.notNull(getPartitionInformationOptions, "getPartitionInformationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getPartitionInformationOptions.db());
        pathParamsMap.put("partition_key", getPartitionInformationOptions.partitionKey());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getPartitionInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<PartitionInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<AllDocsResult> postPartitionAllDocs(PostPartitionAllDocsOptions postPartitionAllDocsOptions) {
        Validator.notNull(postPartitionAllDocsOptions, "postPartitionAllDocsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postPartitionAllDocsOptions.db());
        pathParamsMap.put("partition_key", postPartitionAllDocsOptions.partitionKey());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}/_all_docs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postPartitionAllDocs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (postPartitionAllDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postPartitionAllDocsOptions.attEncodingInfo());
        }
        if (postPartitionAllDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postPartitionAllDocsOptions.attachments());
        }
        if (postPartitionAllDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionAllDocsOptions.conflicts());
        }
        if (postPartitionAllDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postPartitionAllDocsOptions.descending());
        }
        if (postPartitionAllDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionAllDocsOptions.includeDocs());
        }
        if (postPartitionAllDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postPartitionAllDocsOptions.inclusiveEnd());
        }
        if (postPartitionAllDocsOptions.limit() != null) {
            contentJson.addProperty("limit", postPartitionAllDocsOptions.limit());
        }
        if (postPartitionAllDocsOptions.skip() != null) {
            contentJson.addProperty("skip", postPartitionAllDocsOptions.skip());
        }
        if (postPartitionAllDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postPartitionAllDocsOptions.updateSeq());
        }
        if (postPartitionAllDocsOptions.endKey() != null) {
            contentJson.addProperty("end_key", postPartitionAllDocsOptions.endKey());
        }
        if (postPartitionAllDocsOptions.key() != null) {
            contentJson.addProperty("key", postPartitionAllDocsOptions.key());
        }
        if (postPartitionAllDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postPartitionAllDocsOptions.keys()));
        }
        if (postPartitionAllDocsOptions.startKey() != null) {
            contentJson.addProperty("start_key", postPartitionAllDocsOptions.startKey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<AllDocsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postPartitionAllDocsAsStream(PostPartitionAllDocsOptions postPartitionAllDocsOptions) {
        Validator.notNull(postPartitionAllDocsOptions, "postPartitionAllDocsOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postPartitionAllDocsOptions.db());
        pathParamsMap.put("partition_key", postPartitionAllDocsOptions.partitionKey());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}/_all_docs", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postPartitionAllDocsAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (postPartitionAllDocsOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postPartitionAllDocsOptions.attEncodingInfo());
        }
        if (postPartitionAllDocsOptions.attachments() != null) {
            contentJson.addProperty("attachments", postPartitionAllDocsOptions.attachments());
        }
        if (postPartitionAllDocsOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionAllDocsOptions.conflicts());
        }
        if (postPartitionAllDocsOptions.descending() != null) {
            contentJson.addProperty("descending", postPartitionAllDocsOptions.descending());
        }
        if (postPartitionAllDocsOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionAllDocsOptions.includeDocs());
        }
        if (postPartitionAllDocsOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postPartitionAllDocsOptions.inclusiveEnd());
        }
        if (postPartitionAllDocsOptions.limit() != null) {
            contentJson.addProperty("limit", postPartitionAllDocsOptions.limit());
        }
        if (postPartitionAllDocsOptions.skip() != null) {
            contentJson.addProperty("skip", postPartitionAllDocsOptions.skip());
        }
        if (postPartitionAllDocsOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postPartitionAllDocsOptions.updateSeq());
        }
        if (postPartitionAllDocsOptions.endKey() != null) {
            contentJson.addProperty("end_key", postPartitionAllDocsOptions.endKey());
        }
        if (postPartitionAllDocsOptions.key() != null) {
            contentJson.addProperty("key", postPartitionAllDocsOptions.key());
        }
        if (postPartitionAllDocsOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postPartitionAllDocsOptions.keys()));
        }
        if (postPartitionAllDocsOptions.startKey() != null) {
            contentJson.addProperty("start_key", postPartitionAllDocsOptions.startKey());
        }
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SearchResult> postPartitionSearch(PostPartitionSearchOptions postPartitionSearchOptions) {
        Validator.notNull(postPartitionSearchOptions, "postPartitionSearchOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postPartitionSearchOptions.db());
        pathParamsMap.put("partition_key", postPartitionSearchOptions.partitionKey());
        pathParamsMap.put("ddoc", postPartitionSearchOptions.ddoc());
        pathParamsMap.put("index", postPartitionSearchOptions.index());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}/_design/{ddoc}/_search/{index}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postPartitionSearch");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("query", postPartitionSearchOptions.query());
        if (postPartitionSearchOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postPartitionSearchOptions.bookmark());
        }
        if (postPartitionSearchOptions.highlightFields() != null) {
            contentJson.add("highlight_fields", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.highlightFields()));
        }
        if (postPartitionSearchOptions.highlightNumber() != null) {
            contentJson.addProperty("highlight_number", postPartitionSearchOptions.highlightNumber());
        }
        if (postPartitionSearchOptions.highlightPostTag() != null) {
            contentJson.addProperty("highlight_post_tag", postPartitionSearchOptions.highlightPostTag());
        }
        if (postPartitionSearchOptions.highlightPreTag() != null) {
            contentJson.addProperty("highlight_pre_tag", postPartitionSearchOptions.highlightPreTag());
        }
        if (postPartitionSearchOptions.highlightSize() != null) {
            contentJson.addProperty("highlight_size", postPartitionSearchOptions.highlightSize());
        }
        if (postPartitionSearchOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionSearchOptions.includeDocs());
        }
        if (postPartitionSearchOptions.includeFields() != null) {
            contentJson.add("include_fields", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.includeFields()));
        }
        if (postPartitionSearchOptions.limit() != null) {
            contentJson.addProperty("limit", postPartitionSearchOptions.limit());
        }
        if (postPartitionSearchOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.sort()));
        }
        if (postPartitionSearchOptions.stale() != null) {
            contentJson.addProperty("stale", postPartitionSearchOptions.stale());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SearchResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postPartitionSearchAsStream(PostPartitionSearchOptions postPartitionSearchOptions) {
        Validator.notNull(postPartitionSearchOptions, "postPartitionSearchOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postPartitionSearchOptions.db());
        pathParamsMap.put("partition_key", postPartitionSearchOptions.partitionKey());
        pathParamsMap.put("ddoc", postPartitionSearchOptions.ddoc());
        pathParamsMap.put("index", postPartitionSearchOptions.index());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}/_design/{ddoc}/_search/{index}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postPartitionSearchAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("query", postPartitionSearchOptions.query());
        if (postPartitionSearchOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postPartitionSearchOptions.bookmark());
        }
        if (postPartitionSearchOptions.highlightFields() != null) {
            contentJson.add("highlight_fields", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.highlightFields()));
        }
        if (postPartitionSearchOptions.highlightNumber() != null) {
            contentJson.addProperty("highlight_number", postPartitionSearchOptions.highlightNumber());
        }
        if (postPartitionSearchOptions.highlightPostTag() != null) {
            contentJson.addProperty("highlight_post_tag", postPartitionSearchOptions.highlightPostTag());
        }
        if (postPartitionSearchOptions.highlightPreTag() != null) {
            contentJson.addProperty("highlight_pre_tag", postPartitionSearchOptions.highlightPreTag());
        }
        if (postPartitionSearchOptions.highlightSize() != null) {
            contentJson.addProperty("highlight_size", postPartitionSearchOptions.highlightSize());
        }
        if (postPartitionSearchOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionSearchOptions.includeDocs());
        }
        if (postPartitionSearchOptions.includeFields() != null) {
            contentJson.add("include_fields", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.includeFields()));
        }
        if (postPartitionSearchOptions.limit() != null) {
            contentJson.addProperty("limit", postPartitionSearchOptions.limit());
        }
        if (postPartitionSearchOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postPartitionSearchOptions.sort()));
        }
        if (postPartitionSearchOptions.stale() != null) {
            contentJson.addProperty("stale", postPartitionSearchOptions.stale());
        }
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ViewResult> postPartitionView(PostPartitionViewOptions postPartitionViewOptions) {
        Validator.notNull(postPartitionViewOptions, "postPartitionViewOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postPartitionViewOptions.db());
        pathParamsMap.put("partition_key", postPartitionViewOptions.partitionKey());
        pathParamsMap.put("ddoc", postPartitionViewOptions.ddoc());
        pathParamsMap.put("view", postPartitionViewOptions.view());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}/_design/{ddoc}/_view/{view}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postPartitionView");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (postPartitionViewOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postPartitionViewOptions.attEncodingInfo());
        }
        if (postPartitionViewOptions.attachments() != null) {
            contentJson.addProperty("attachments", postPartitionViewOptions.attachments());
        }
        if (postPartitionViewOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionViewOptions.conflicts());
        }
        if (postPartitionViewOptions.descending() != null) {
            contentJson.addProperty("descending", postPartitionViewOptions.descending());
        }
        if (postPartitionViewOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionViewOptions.includeDocs());
        }
        if (postPartitionViewOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postPartitionViewOptions.inclusiveEnd());
        }
        if (postPartitionViewOptions.limit() != null) {
            contentJson.addProperty("limit", postPartitionViewOptions.limit());
        }
        if (postPartitionViewOptions.skip() != null) {
            contentJson.addProperty("skip", postPartitionViewOptions.skip());
        }
        if (postPartitionViewOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postPartitionViewOptions.updateSeq());
        }
        if (postPartitionViewOptions.endKey() != null) {
            contentJson.add("end_key", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.endKey()));
        }
        if (postPartitionViewOptions.endKeyDocId() != null) {
            contentJson.addProperty("end_key_doc_id", postPartitionViewOptions.endKeyDocId());
        }
        if (postPartitionViewOptions.group() != null) {
            contentJson.addProperty("group", postPartitionViewOptions.group());
        }
        if (postPartitionViewOptions.groupLevel() != null) {
            contentJson.addProperty("group_level", postPartitionViewOptions.groupLevel());
        }
        if (postPartitionViewOptions.key() != null) {
            contentJson.add("key", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.key()));
        }
        if (postPartitionViewOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.keys()));
        }
        if (postPartitionViewOptions.reduce() != null) {
            contentJson.addProperty("reduce", postPartitionViewOptions.reduce());
        }
        if (postPartitionViewOptions.startKey() != null) {
            contentJson.add("start_key", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.startKey()));
        }
        if (postPartitionViewOptions.startKeyDocId() != null) {
            contentJson.addProperty("start_key_doc_id", postPartitionViewOptions.startKeyDocId());
        }
        if (postPartitionViewOptions.update() != null) {
            contentJson.addProperty("update", postPartitionViewOptions.update());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ViewResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postPartitionViewAsStream(PostPartitionViewOptions postPartitionViewOptions) {
        Validator.notNull(postPartitionViewOptions, "postPartitionViewOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postPartitionViewOptions.db());
        pathParamsMap.put("partition_key", postPartitionViewOptions.partitionKey());
        pathParamsMap.put("ddoc", postPartitionViewOptions.ddoc());
        pathParamsMap.put("view", postPartitionViewOptions.view());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}/_design/{ddoc}/_view/{view}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postPartitionViewAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (postPartitionViewOptions.attEncodingInfo() != null) {
            contentJson.addProperty("att_encoding_info", postPartitionViewOptions.attEncodingInfo());
        }
        if (postPartitionViewOptions.attachments() != null) {
            contentJson.addProperty("attachments", postPartitionViewOptions.attachments());
        }
        if (postPartitionViewOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionViewOptions.conflicts());
        }
        if (postPartitionViewOptions.descending() != null) {
            contentJson.addProperty("descending", postPartitionViewOptions.descending());
        }
        if (postPartitionViewOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postPartitionViewOptions.includeDocs());
        }
        if (postPartitionViewOptions.inclusiveEnd() != null) {
            contentJson.addProperty("inclusive_end", postPartitionViewOptions.inclusiveEnd());
        }
        if (postPartitionViewOptions.limit() != null) {
            contentJson.addProperty("limit", postPartitionViewOptions.limit());
        }
        if (postPartitionViewOptions.skip() != null) {
            contentJson.addProperty("skip", postPartitionViewOptions.skip());
        }
        if (postPartitionViewOptions.updateSeq() != null) {
            contentJson.addProperty("update_seq", postPartitionViewOptions.updateSeq());
        }
        if (postPartitionViewOptions.endKey() != null) {
            contentJson.add("end_key", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.endKey()));
        }
        if (postPartitionViewOptions.endKeyDocId() != null) {
            contentJson.addProperty("end_key_doc_id", postPartitionViewOptions.endKeyDocId());
        }
        if (postPartitionViewOptions.group() != null) {
            contentJson.addProperty("group", postPartitionViewOptions.group());
        }
        if (postPartitionViewOptions.groupLevel() != null) {
            contentJson.addProperty("group_level", postPartitionViewOptions.groupLevel());
        }
        if (postPartitionViewOptions.key() != null) {
            contentJson.add("key", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.key()));
        }
        if (postPartitionViewOptions.keys() != null) {
            contentJson.add("keys", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.keys()));
        }
        if (postPartitionViewOptions.reduce() != null) {
            contentJson.addProperty("reduce", postPartitionViewOptions.reduce());
        }
        if (postPartitionViewOptions.startKey() != null) {
            contentJson.add("start_key", GsonSingleton.getGson().toJsonTree(postPartitionViewOptions.startKey()));
        }
        if (postPartitionViewOptions.startKeyDocId() != null) {
            contentJson.addProperty("start_key_doc_id", postPartitionViewOptions.startKeyDocId());
        }
        if (postPartitionViewOptions.update() != null) {
            contentJson.addProperty("update", postPartitionViewOptions.update());
        }
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ExplainResult> postPartitionExplain(PostPartitionExplainOptions postPartitionExplainOptions) {
        Validator.notNull(postPartitionExplainOptions, "postPartitionExplainOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postPartitionExplainOptions.db());
        pathParamsMap.put("partition_key", postPartitionExplainOptions.partitionKey());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}/_explain", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postPartitionExplain");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postPartitionExplainOptions.selector()));
        if (postPartitionExplainOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postPartitionExplainOptions.bookmark());
        }
        if (postPartitionExplainOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionExplainOptions.conflicts());
        }
        if (postPartitionExplainOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postPartitionExplainOptions.executionStats());
        }
        if (postPartitionExplainOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postPartitionExplainOptions.fields()));
        }
        if (postPartitionExplainOptions.limit() != null) {
            contentJson.addProperty("limit", postPartitionExplainOptions.limit());
        }
        if (postPartitionExplainOptions.skip() != null) {
            contentJson.addProperty("skip", postPartitionExplainOptions.skip());
        }
        if (postPartitionExplainOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postPartitionExplainOptions.sort()));
        }
        if (postPartitionExplainOptions.stable() != null) {
            contentJson.addProperty("stable", postPartitionExplainOptions.stable());
        }
        if (postPartitionExplainOptions.update() != null) {
            contentJson.addProperty("update", postPartitionExplainOptions.update());
        }
        if (postPartitionExplainOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postPartitionExplainOptions.useIndex()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ExplainResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FindResult> postPartitionFind(PostPartitionFindOptions postPartitionFindOptions) {
        Validator.notNull(postPartitionFindOptions, "postPartitionFindOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postPartitionFindOptions.db());
        pathParamsMap.put("partition_key", postPartitionFindOptions.partitionKey());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}/_find", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postPartitionFind");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.selector()));
        if (postPartitionFindOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postPartitionFindOptions.bookmark());
        }
        if (postPartitionFindOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionFindOptions.conflicts());
        }
        if (postPartitionFindOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postPartitionFindOptions.executionStats());
        }
        if (postPartitionFindOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.fields()));
        }
        if (postPartitionFindOptions.limit() != null) {
            contentJson.addProperty("limit", postPartitionFindOptions.limit());
        }
        if (postPartitionFindOptions.skip() != null) {
            contentJson.addProperty("skip", postPartitionFindOptions.skip());
        }
        if (postPartitionFindOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.sort()));
        }
        if (postPartitionFindOptions.stable() != null) {
            contentJson.addProperty("stable", postPartitionFindOptions.stable());
        }
        if (postPartitionFindOptions.update() != null) {
            contentJson.addProperty("update", postPartitionFindOptions.update());
        }
        if (postPartitionFindOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.useIndex()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<FindResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postPartitionFindAsStream(PostPartitionFindOptions postPartitionFindOptions) {
        Validator.notNull(postPartitionFindOptions, "postPartitionFindOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postPartitionFindOptions.db());
        pathParamsMap.put("partition_key", postPartitionFindOptions.partitionKey());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_partition/{partition_key}/_find", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postPartitionFindAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.selector()));
        if (postPartitionFindOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postPartitionFindOptions.bookmark());
        }
        if (postPartitionFindOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postPartitionFindOptions.conflicts());
        }
        if (postPartitionFindOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postPartitionFindOptions.executionStats());
        }
        if (postPartitionFindOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.fields()));
        }
        if (postPartitionFindOptions.limit() != null) {
            contentJson.addProperty("limit", postPartitionFindOptions.limit());
        }
        if (postPartitionFindOptions.skip() != null) {
            contentJson.addProperty("skip", postPartitionFindOptions.skip());
        }
        if (postPartitionFindOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.sort()));
        }
        if (postPartitionFindOptions.stable() != null) {
            contentJson.addProperty("stable", postPartitionFindOptions.stable());
        }
        if (postPartitionFindOptions.update() != null) {
            contentJson.addProperty("update", postPartitionFindOptions.update());
        }
        if (postPartitionFindOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postPartitionFindOptions.useIndex()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ExplainResult> postExplain(PostExplainOptions postExplainOptions) {
        Validator.notNull(postExplainOptions, "postExplainOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postExplainOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_explain", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postExplain");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postExplainOptions.selector()));
        if (postExplainOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postExplainOptions.bookmark());
        }
        if (postExplainOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postExplainOptions.conflicts());
        }
        if (postExplainOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postExplainOptions.executionStats());
        }
        if (postExplainOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postExplainOptions.fields()));
        }
        if (postExplainOptions.limit() != null) {
            contentJson.addProperty("limit", postExplainOptions.limit());
        }
        if (postExplainOptions.skip() != null) {
            contentJson.addProperty("skip", postExplainOptions.skip());
        }
        if (postExplainOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postExplainOptions.sort()));
        }
        if (postExplainOptions.stable() != null) {
            contentJson.addProperty("stable", postExplainOptions.stable());
        }
        if (postExplainOptions.update() != null) {
            contentJson.addProperty("update", postExplainOptions.update());
        }
        if (postExplainOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postExplainOptions.useIndex()));
        }
        if (postExplainOptions.r() != null) {
            contentJson.addProperty("r", postExplainOptions.r());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ExplainResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<FindResult> postFind(PostFindOptions postFindOptions) {
        Validator.notNull(postFindOptions, "postFindOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postFindOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_find", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postFind");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postFindOptions.selector()));
        if (postFindOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postFindOptions.bookmark());
        }
        if (postFindOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postFindOptions.conflicts());
        }
        if (postFindOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postFindOptions.executionStats());
        }
        if (postFindOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postFindOptions.fields()));
        }
        if (postFindOptions.limit() != null) {
            contentJson.addProperty("limit", postFindOptions.limit());
        }
        if (postFindOptions.skip() != null) {
            contentJson.addProperty("skip", postFindOptions.skip());
        }
        if (postFindOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postFindOptions.sort()));
        }
        if (postFindOptions.stable() != null) {
            contentJson.addProperty("stable", postFindOptions.stable());
        }
        if (postFindOptions.update() != null) {
            contentJson.addProperty("update", postFindOptions.update());
        }
        if (postFindOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postFindOptions.useIndex()));
        }
        if (postFindOptions.r() != null) {
            contentJson.addProperty("r", postFindOptions.r());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<FindResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postFindAsStream(PostFindOptions postFindOptions) {
        Validator.notNull(postFindOptions, "postFindOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postFindOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_find", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postFindAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("selector", GsonSingleton.getGson().toJsonTree(postFindOptions.selector()));
        if (postFindOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postFindOptions.bookmark());
        }
        if (postFindOptions.conflicts() != null) {
            contentJson.addProperty("conflicts", postFindOptions.conflicts());
        }
        if (postFindOptions.executionStats() != null) {
            contentJson.addProperty("execution_stats", postFindOptions.executionStats());
        }
        if (postFindOptions.fields() != null) {
            contentJson.add("fields", GsonSingleton.getGson().toJsonTree(postFindOptions.fields()));
        }
        if (postFindOptions.limit() != null) {
            contentJson.addProperty("limit", postFindOptions.limit());
        }
        if (postFindOptions.skip() != null) {
            contentJson.addProperty("skip", postFindOptions.skip());
        }
        if (postFindOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postFindOptions.sort()));
        }
        if (postFindOptions.stable() != null) {
            contentJson.addProperty("stable", postFindOptions.stable());
        }
        if (postFindOptions.update() != null) {
            contentJson.addProperty("update", postFindOptions.update());
        }
        if (postFindOptions.useIndex() != null) {
            contentJson.add("use_index", GsonSingleton.getGson().toJsonTree(postFindOptions.useIndex()));
        }
        if (postFindOptions.r() != null) {
            contentJson.addProperty("r", postFindOptions.r());
        }
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<IndexesInformation> getIndexesInformation(GetIndexesInformationOptions getIndexesInformationOptions) {
        Validator.notNull(getIndexesInformationOptions, "getIndexesInformationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getIndexesInformationOptions.db());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_index", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getIndexesInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<IndexesInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<IndexResult> postIndex(PostIndexOptions postIndexOptions) {
        Validator.notNull(postIndexOptions, "postIndexOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postIndexOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_index", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postIndex");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("index", GsonSingleton.getGson().toJsonTree(postIndexOptions.index()));
        if (postIndexOptions.ddoc() != null) {
            contentJson.addProperty("ddoc", postIndexOptions.ddoc());
        }
        if (postIndexOptions.name() != null) {
            contentJson.addProperty("name", postIndexOptions.name());
        }
        if (postIndexOptions.partitioned() != null) {
            contentJson.addProperty("partitioned", postIndexOptions.partitioned());
        }
        if (postIndexOptions.type() != null) {
            contentJson.addProperty("type", postIndexOptions.type());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<IndexResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> deleteIndex(DeleteIndexOptions deleteIndexOptions) {
        Validator.notNull(deleteIndexOptions, "deleteIndexOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", deleteIndexOptions.db());
        pathParamsMap.put("ddoc", deleteIndexOptions.ddoc());
        pathParamsMap.put("type", deleteIndexOptions.type());
        pathParamsMap.put("index", deleteIndexOptions.index());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_index/_design/{ddoc}/{type}/{index}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "deleteIndex");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SearchAnalyzeResult> postSearchAnalyze(PostSearchAnalyzeOptions postSearchAnalyzeOptions) {
        Validator.notNull(postSearchAnalyzeOptions, "postSearchAnalyzeOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_search_analyze"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postSearchAnalyze");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("analyzer", postSearchAnalyzeOptions.analyzer());
        contentJson.addProperty("text", postSearchAnalyzeOptions.text());
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SearchAnalyzeResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SearchResult> postSearch(PostSearchOptions postSearchOptions) {
        Validator.notNull(postSearchOptions, "postSearchOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postSearchOptions.db());
        pathParamsMap.put("ddoc", postSearchOptions.ddoc());
        pathParamsMap.put("index", postSearchOptions.index());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}/_search/{index}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postSearch");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("query", postSearchOptions.query());
        if (postSearchOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postSearchOptions.bookmark());
        }
        if (postSearchOptions.highlightFields() != null) {
            contentJson.add("highlight_fields", GsonSingleton.getGson().toJsonTree(postSearchOptions.highlightFields()));
        }
        if (postSearchOptions.highlightNumber() != null) {
            contentJson.addProperty("highlight_number", postSearchOptions.highlightNumber());
        }
        if (postSearchOptions.highlightPostTag() != null) {
            contentJson.addProperty("highlight_post_tag", postSearchOptions.highlightPostTag());
        }
        if (postSearchOptions.highlightPreTag() != null) {
            contentJson.addProperty("highlight_pre_tag", postSearchOptions.highlightPreTag());
        }
        if (postSearchOptions.highlightSize() != null) {
            contentJson.addProperty("highlight_size", postSearchOptions.highlightSize());
        }
        if (postSearchOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postSearchOptions.includeDocs());
        }
        if (postSearchOptions.includeFields() != null) {
            contentJson.add("include_fields", GsonSingleton.getGson().toJsonTree(postSearchOptions.includeFields()));
        }
        if (postSearchOptions.limit() != null) {
            contentJson.addProperty("limit", postSearchOptions.limit());
        }
        if (postSearchOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postSearchOptions.sort()));
        }
        if (postSearchOptions.stale() != null) {
            contentJson.addProperty("stale", postSearchOptions.stale());
        }
        if (postSearchOptions.counts() != null) {
            contentJson.add("counts", GsonSingleton.getGson().toJsonTree(postSearchOptions.counts()));
        }
        if (postSearchOptions.drilldown() != null) {
            contentJson.add("drilldown", GsonSingleton.getGson().toJsonTree(postSearchOptions.drilldown()));
        }
        if (postSearchOptions.groupField() != null) {
            contentJson.addProperty("group_field", postSearchOptions.groupField());
        }
        if (postSearchOptions.groupLimit() != null) {
            contentJson.addProperty("group_limit", postSearchOptions.groupLimit());
        }
        if (postSearchOptions.groupSort() != null) {
            contentJson.add("group_sort", GsonSingleton.getGson().toJsonTree(postSearchOptions.groupSort()));
        }
        if (postSearchOptions.ranges() != null) {
            contentJson.add("ranges", GsonSingleton.getGson().toJsonTree(postSearchOptions.ranges()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SearchResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> postSearchAsStream(PostSearchOptions postSearchOptions) {
        Validator.notNull(postSearchOptions, "postSearchOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postSearchOptions.db());
        pathParamsMap.put("ddoc", postSearchOptions.ddoc());
        pathParamsMap.put("index", postSearchOptions.index());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}/_search/{index}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postSearchAsStream");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.addProperty("query", postSearchOptions.query());
        if (postSearchOptions.bookmark() != null) {
            contentJson.addProperty("bookmark", postSearchOptions.bookmark());
        }
        if (postSearchOptions.highlightFields() != null) {
            contentJson.add("highlight_fields", GsonSingleton.getGson().toJsonTree(postSearchOptions.highlightFields()));
        }
        if (postSearchOptions.highlightNumber() != null) {
            contentJson.addProperty("highlight_number", postSearchOptions.highlightNumber());
        }
        if (postSearchOptions.highlightPostTag() != null) {
            contentJson.addProperty("highlight_post_tag", postSearchOptions.highlightPostTag());
        }
        if (postSearchOptions.highlightPreTag() != null) {
            contentJson.addProperty("highlight_pre_tag", postSearchOptions.highlightPreTag());
        }
        if (postSearchOptions.highlightSize() != null) {
            contentJson.addProperty("highlight_size", postSearchOptions.highlightSize());
        }
        if (postSearchOptions.includeDocs() != null) {
            contentJson.addProperty("include_docs", postSearchOptions.includeDocs());
        }
        if (postSearchOptions.includeFields() != null) {
            contentJson.add("include_fields", GsonSingleton.getGson().toJsonTree(postSearchOptions.includeFields()));
        }
        if (postSearchOptions.limit() != null) {
            contentJson.addProperty("limit", postSearchOptions.limit());
        }
        if (postSearchOptions.sort() != null) {
            contentJson.add("sort", GsonSingleton.getGson().toJsonTree(postSearchOptions.sort()));
        }
        if (postSearchOptions.stale() != null) {
            contentJson.addProperty("stale", postSearchOptions.stale());
        }
        if (postSearchOptions.counts() != null) {
            contentJson.add("counts", GsonSingleton.getGson().toJsonTree(postSearchOptions.counts()));
        }
        if (postSearchOptions.drilldown() != null) {
            contentJson.add("drilldown", GsonSingleton.getGson().toJsonTree(postSearchOptions.drilldown()));
        }
        if (postSearchOptions.groupField() != null) {
            contentJson.addProperty("group_field", postSearchOptions.groupField());
        }
        if (postSearchOptions.groupLimit() != null) {
            contentJson.addProperty("group_limit", postSearchOptions.groupLimit());
        }
        if (postSearchOptions.groupSort() != null) {
            contentJson.add("group_sort", GsonSingleton.getGson().toJsonTree(postSearchOptions.groupSort()));
        }
        if (postSearchOptions.ranges() != null) {
            contentJson.add("ranges", GsonSingleton.getGson().toJsonTree(postSearchOptions.ranges()));
        }
        builder.bodyJson(contentJson);
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SearchInfoResult> getSearchInfo(GetSearchInfoOptions getSearchInfoOptions) {
        Validator.notNull(getSearchInfoOptions, "getSearchInfoOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getSearchInfoOptions.db());
        pathParamsMap.put("ddoc", getSearchInfoOptions.ddoc());
        pathParamsMap.put("index", getSearchInfoOptions.index());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_design/{ddoc}/_search_info/{index}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getSearchInfo");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SearchInfoResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headReplicationDocument(HeadReplicationDocumentOptions headReplicationDocumentOptions) {
        Validator.notNull(headReplicationDocumentOptions, "headReplicationDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("doc_id", headReplicationDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.head(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_replicator/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "headReplicationDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (headReplicationDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", headReplicationDocumentOptions.ifNoneMatch());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headSchedulerDocument(HeadSchedulerDocumentOptions headSchedulerDocumentOptions) {
        Validator.notNull(headSchedulerDocumentOptions, "headSchedulerDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("doc_id", headSchedulerDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.head(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_scheduler/docs/_replicator/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "headSchedulerDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headSchedulerJob(HeadSchedulerJobOptions headSchedulerJobOptions) {
        Validator.notNull(headSchedulerJobOptions, "headSchedulerJobOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("job_id", headSchedulerJobOptions.jobId());
        RequestBuilder builder = RequestBuilder.head(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_scheduler/jobs/{job_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "headSchedulerJob");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> deleteReplicationDocument(DeleteReplicationDocumentOptions deleteReplicationDocumentOptions) {
        Validator.notNull(deleteReplicationDocumentOptions, "deleteReplicationDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("doc_id", deleteReplicationDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_replicator/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "deleteReplicationDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (deleteReplicationDocumentOptions.ifMatch() != null) {
            builder.header("If-Match", deleteReplicationDocumentOptions.ifMatch());
        }
        if (deleteReplicationDocumentOptions.batch() != null) {
            builder.query("batch", String.valueOf(deleteReplicationDocumentOptions.batch()));
        }
        if (deleteReplicationDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(deleteReplicationDocumentOptions.rev()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ReplicationDocument> getReplicationDocument(GetReplicationDocumentOptions getReplicationDocumentOptions) {
        Validator.notNull(getReplicationDocumentOptions, "getReplicationDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("doc_id", getReplicationDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_replicator/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getReplicationDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (getReplicationDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", getReplicationDocumentOptions.ifNoneMatch());
        }
        if (getReplicationDocumentOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(getReplicationDocumentOptions.attachments()));
        }
        if (getReplicationDocumentOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(getReplicationDocumentOptions.attEncodingInfo()));
        }
        if (getReplicationDocumentOptions.conflicts() != null) {
            builder.query("conflicts", String.valueOf(getReplicationDocumentOptions.conflicts()));
        }
        if (getReplicationDocumentOptions.deletedConflicts() != null) {
            builder.query("deleted_conflicts", String.valueOf(getReplicationDocumentOptions.deletedConflicts()));
        }
        if (getReplicationDocumentOptions.latest() != null) {
            builder.query("latest", String.valueOf(getReplicationDocumentOptions.latest()));
        }
        if (getReplicationDocumentOptions.localSeq() != null) {
            builder.query("local_seq", String.valueOf(getReplicationDocumentOptions.localSeq()));
        }
        if (getReplicationDocumentOptions.meta() != null) {
            builder.query("meta", String.valueOf(getReplicationDocumentOptions.meta()));
        }
        if (getReplicationDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(getReplicationDocumentOptions.rev()));
        }
        if (getReplicationDocumentOptions.revs() != null) {
            builder.query("revs", String.valueOf(getReplicationDocumentOptions.revs()));
        }
        if (getReplicationDocumentOptions.revsInfo() != null) {
            builder.query("revs_info", String.valueOf(getReplicationDocumentOptions.revsInfo()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ReplicationDocument>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putReplicationDocument(PutReplicationDocumentOptions putReplicationDocumentOptions) {
        Validator.notNull(putReplicationDocumentOptions, "putReplicationDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("doc_id", putReplicationDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_replicator/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putReplicationDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (putReplicationDocumentOptions.ifMatch() != null) {
            builder.header("If-Match", putReplicationDocumentOptions.ifMatch());
        }
        if (putReplicationDocumentOptions.batch() != null) {
            builder.query("batch", String.valueOf(putReplicationDocumentOptions.batch()));
        }
        if (putReplicationDocumentOptions.newEdits() != null) {
            builder.query("new_edits", String.valueOf(putReplicationDocumentOptions.newEdits()));
        }
        if (putReplicationDocumentOptions.rev() != null) {
            builder.query("rev", String.valueOf(putReplicationDocumentOptions.rev()));
        }
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(putReplicationDocumentOptions.replicationDocument()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SchedulerDocsResult> getSchedulerDocs(GetSchedulerDocsOptions getSchedulerDocsOptions) {
        if (getSchedulerDocsOptions == null) {
            getSchedulerDocsOptions = new GetSchedulerDocsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_scheduler/docs"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getSchedulerDocs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (getSchedulerDocsOptions.limit() != null) {
            builder.query("limit", String.valueOf(getSchedulerDocsOptions.limit()));
        }
        if (getSchedulerDocsOptions.skip() != null) {
            builder.query("skip", String.valueOf(getSchedulerDocsOptions.skip()));
        }
        if (getSchedulerDocsOptions.states() != null) {
            builder.query("states", RequestUtils.join(getSchedulerDocsOptions.states(), ","));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SchedulerDocsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SchedulerDocsResult> getSchedulerDocs() {
        return this.getSchedulerDocs(null);
    }

    public ServiceCall<SchedulerDocument> getSchedulerDocument(GetSchedulerDocumentOptions getSchedulerDocumentOptions) {
        Validator.notNull(getSchedulerDocumentOptions, "getSchedulerDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("doc_id", getSchedulerDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_scheduler/docs/_replicator/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getSchedulerDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SchedulerDocument>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SchedulerJobsResult> getSchedulerJobs(GetSchedulerJobsOptions getSchedulerJobsOptions) {
        if (getSchedulerJobsOptions == null) {
            getSchedulerJobsOptions = new GetSchedulerJobsOptions.Builder().build();
        }
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_scheduler/jobs"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getSchedulerJobs");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (getSchedulerJobsOptions.limit() != null) {
            builder.query("limit", String.valueOf(getSchedulerJobsOptions.limit()));
        }
        if (getSchedulerJobsOptions.skip() != null) {
            builder.query("skip", String.valueOf(getSchedulerJobsOptions.skip()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SchedulerJobsResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SchedulerJobsResult> getSchedulerJobs() {
        return this.getSchedulerJobs(null);
    }

    public ServiceCall<SchedulerJob> getSchedulerJob(GetSchedulerJobOptions getSchedulerJobOptions) {
        Validator.notNull(getSchedulerJobOptions, "getSchedulerJobOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("job_id", getSchedulerJobOptions.jobId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_scheduler/jobs/{job_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getSchedulerJob");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SchedulerJob>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SessionInformation> getSessionInformation(GetSessionInformationOptions getSessionInformationOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_session"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getSessionInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<SessionInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<SessionInformation> getSessionInformation() {
        return this.getSessionInformation(null);
    }

    public ServiceCall<Security> getSecurity(GetSecurityOptions getSecurityOptions) {
        Validator.notNull(getSecurityOptions, "getSecurityOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getSecurityOptions.db());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_security", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getSecurity");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Security>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Ok> putSecurity(PutSecurityOptions putSecurityOptions) {
        Validator.notNull(putSecurityOptions, "putSecurityOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", putSecurityOptions.db());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_security", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putSecurity");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        if (putSecurityOptions.admins() != null) {
            contentJson.add("admins", GsonSingleton.getGson().toJsonTree(putSecurityOptions.admins()));
        }
        if (putSecurityOptions.members() != null) {
            contentJson.add("members", GsonSingleton.getGson().toJsonTree(putSecurityOptions.members()));
        }
        if (putSecurityOptions.cloudant() != null) {
            contentJson.add(DEFAULT_SERVICE_NAME, GsonSingleton.getGson().toJsonTree(putSecurityOptions.cloudant()));
        }
        if (putSecurityOptions.couchdbAuthOnly() != null) {
            contentJson.addProperty("couchdb_auth_only", putSecurityOptions.couchdbAuthOnly());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ApiKeysResult> postApiKeys(PostApiKeysOptions postApiKeysOptions) {
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_api/v2/api_keys"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postApiKeys");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ApiKeysResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ApiKeysResult> postApiKeys() {
        return this.postApiKeys(null);
    }

    public ServiceCall<Ok> putCloudantSecurityConfiguration(PutCloudantSecurityConfigurationOptions putCloudantSecurityConfigurationOptions) {
        Validator.notNull(putCloudantSecurityConfigurationOptions, "putCloudantSecurityConfigurationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", putCloudantSecurityConfigurationOptions.db());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_api/v2/db/{db}/_security", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putCloudantSecurityConfiguration");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add(DEFAULT_SERVICE_NAME, GsonSingleton.getGson().toJsonTree(putCloudantSecurityConfigurationOptions.cloudant()));
        if (putCloudantSecurityConfigurationOptions.admins() != null) {
            contentJson.add("admins", GsonSingleton.getGson().toJsonTree(putCloudantSecurityConfigurationOptions.admins()));
        }
        if (putCloudantSecurityConfigurationOptions.members() != null) {
            contentJson.add("members", GsonSingleton.getGson().toJsonTree(putCloudantSecurityConfigurationOptions.members()));
        }
        if (putCloudantSecurityConfigurationOptions.couchdbAuthOnly() != null) {
            contentJson.addProperty("couchdb_auth_only", putCloudantSecurityConfigurationOptions.couchdbAuthOnly());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CorsInformation> getCorsInformation(GetCorsInformationOptions getCorsInformationOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_api/v2/user/config/cors"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getCorsInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<CorsInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CorsInformation> getCorsInformation() {
        return this.getCorsInformation(null);
    }

    public ServiceCall<Ok> putCorsConfiguration(PutCorsConfigurationOptions putCorsConfigurationOptions) {
        Validator.notNull(putCorsConfigurationOptions, "putCorsConfigurationOptions cannot be null");
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_api/v2/user/config/cors"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putCorsConfiguration");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("origins", GsonSingleton.getGson().toJsonTree(putCorsConfigurationOptions.origins()));
        if (putCorsConfigurationOptions.allowCredentials() != null) {
            contentJson.addProperty("allow_credentials", putCorsConfigurationOptions.allowCredentials());
        }
        if (putCorsConfigurationOptions.enableCors() != null) {
            contentJson.addProperty("enable_cors", putCorsConfigurationOptions.enableCors());
        }
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headAttachment(HeadAttachmentOptions headAttachmentOptions) {
        Validator.notNull(headAttachmentOptions, "headAttachmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", headAttachmentOptions.db());
        pathParamsMap.put("doc_id", headAttachmentOptions.docId());
        pathParamsMap.put("attachment_name", headAttachmentOptions.attachmentName());
        RequestBuilder builder = RequestBuilder.head(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}/{attachment_name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "headAttachment");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (headAttachmentOptions.ifMatch() != null) {
            builder.header("If-Match", headAttachmentOptions.ifMatch());
        }
        if (headAttachmentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", headAttachmentOptions.ifNoneMatch());
        }
        if (headAttachmentOptions.rev() != null) {
            builder.query("rev", String.valueOf(headAttachmentOptions.rev()));
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> deleteAttachment(DeleteAttachmentOptions deleteAttachmentOptions) {
        Validator.notNull(deleteAttachmentOptions, "deleteAttachmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", deleteAttachmentOptions.db());
        pathParamsMap.put("doc_id", deleteAttachmentOptions.docId());
        pathParamsMap.put("attachment_name", deleteAttachmentOptions.attachmentName());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}/{attachment_name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "deleteAttachment");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (deleteAttachmentOptions.ifMatch() != null) {
            builder.header("If-Match", deleteAttachmentOptions.ifMatch());
        }
        if (deleteAttachmentOptions.rev() != null) {
            builder.query("rev", String.valueOf(deleteAttachmentOptions.rev()));
        }
        if (deleteAttachmentOptions.batch() != null) {
            builder.query("batch", String.valueOf(deleteAttachmentOptions.batch()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<InputStream> getAttachment(GetAttachmentOptions getAttachmentOptions) {
        Validator.notNull(getAttachmentOptions, "getAttachmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getAttachmentOptions.db());
        pathParamsMap.put("doc_id", getAttachmentOptions.docId());
        pathParamsMap.put("attachment_name", getAttachmentOptions.attachmentName());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}/{attachment_name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getAttachment");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (getAttachmentOptions.accept() != null) {
            builder.header("Accept", getAttachmentOptions.accept());
        }
        if (getAttachmentOptions.ifMatch() != null) {
            builder.header("If-Match", getAttachmentOptions.ifMatch());
        }
        if (getAttachmentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", getAttachmentOptions.ifNoneMatch());
        }
        if (getAttachmentOptions.range() != null) {
            builder.header("Range", getAttachmentOptions.range());
        }
        if (getAttachmentOptions.rev() != null) {
            builder.query("rev", String.valueOf(getAttachmentOptions.rev()));
        }
        ResponseConverter<InputStream> responseConverter = ResponseConverterUtils.getInputStream();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putAttachment(PutAttachmentOptions putAttachmentOptions) {
        Validator.notNull(putAttachmentOptions, "putAttachmentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", putAttachmentOptions.db());
        pathParamsMap.put("doc_id", putAttachmentOptions.docId());
        pathParamsMap.put("attachment_name", putAttachmentOptions.attachmentName());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/{doc_id}/{attachment_name}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putAttachment");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.header("Content-Type", putAttachmentOptions.contentType());
        if (putAttachmentOptions.ifMatch() != null) {
            builder.header("If-Match", putAttachmentOptions.ifMatch());
        }
        if (putAttachmentOptions.rev() != null) {
            builder.query("rev", String.valueOf(putAttachmentOptions.rev()));
        }
        builder.bodyContent(putAttachmentOptions.contentType(), null, null, putAttachmentOptions.attachment());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headLocalDocument(HeadLocalDocumentOptions headLocalDocumentOptions) {
        Validator.notNull(headLocalDocumentOptions, "headLocalDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", headLocalDocumentOptions.db());
        pathParamsMap.put("doc_id", headLocalDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.head(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_local/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "headLocalDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (headLocalDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", headLocalDocumentOptions.ifNoneMatch());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> deleteLocalDocument(DeleteLocalDocumentOptions deleteLocalDocumentOptions) {
        Validator.notNull(deleteLocalDocumentOptions, "deleteLocalDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", deleteLocalDocumentOptions.db());
        pathParamsMap.put("doc_id", deleteLocalDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.delete(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_local/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "deleteLocalDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (deleteLocalDocumentOptions.batch() != null) {
            builder.query("batch", String.valueOf(deleteLocalDocumentOptions.batch()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Document> getLocalDocument(GetLocalDocumentOptions getLocalDocumentOptions) {
        Validator.notNull(getLocalDocumentOptions, "getLocalDocumentOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getLocalDocumentOptions.db());
        pathParamsMap.put("doc_id", getLocalDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_local/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getLocalDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        if (getLocalDocumentOptions.accept() != null) {
            builder.header("Accept", getLocalDocumentOptions.accept());
        }
        if (getLocalDocumentOptions.ifNoneMatch() != null) {
            builder.header("If-None-Match", getLocalDocumentOptions.ifNoneMatch());
        }
        if (getLocalDocumentOptions.attachments() != null) {
            builder.query("attachments", String.valueOf(getLocalDocumentOptions.attachments()));
        }
        if (getLocalDocumentOptions.attEncodingInfo() != null) {
            builder.query("att_encoding_info", String.valueOf(getLocalDocumentOptions.attEncodingInfo()));
        }
        if (getLocalDocumentOptions.localSeq() != null) {
            builder.query("local_seq", String.valueOf(getLocalDocumentOptions.localSeq()));
        }
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Document>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentResult> putLocalDocument(PutLocalDocumentOptions putLocalDocumentOptions) {
        Validator.notNull(putLocalDocumentOptions, "putLocalDocumentOptions cannot be null");
        Validator.isTrue(putLocalDocumentOptions.document() != null || putLocalDocumentOptions.body() != null, "One of [putLocalDocumentOptions.document(), putLocalDocumentOptions.body()] must be specified");
        if (putLocalDocumentOptions.document() != null && putLocalDocumentOptions.contentType() == null) {
            putLocalDocumentOptions = putLocalDocumentOptions.newBuilder().contentType("application/json").build();
        }
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", putLocalDocumentOptions.db());
        pathParamsMap.put("doc_id", putLocalDocumentOptions.docId());
        RequestBuilder builder = RequestBuilder.put(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_local/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "putLocalDocument");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        if (putLocalDocumentOptions.contentType() != null) {
            builder.header("Content-Type", putLocalDocumentOptions.contentType());
        }
        if (putLocalDocumentOptions.batch() != null) {
            builder.query("batch", String.valueOf(putLocalDocumentOptions.batch()));
        }
        builder.bodyContent(putLocalDocumentOptions.contentType(), (Object)putLocalDocumentOptions.document(), null, putLocalDocumentOptions.body());
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentResult>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Map<String, RevsDiff>> postRevsDiff(PostRevsDiffOptions postRevsDiffOptions) {
        Validator.notNull(postRevsDiffOptions, "postRevsDiffOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", postRevsDiffOptions.db());
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_revs_diff", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postRevsDiff");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        builder.bodyContent(GsonSingleton.getGsonWithoutPrettyPrinting().toJson(postRevsDiffOptions.documentRevisions()), "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Map<String, RevsDiff>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ShardsInformation> getShardsInformation(GetShardsInformationOptions getShardsInformationOptions) {
        Validator.notNull(getShardsInformationOptions, "getShardsInformationOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getShardsInformationOptions.db());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_shards", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getShardsInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ShardsInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<DocumentShardInfo> getDocumentShardsInfo(GetDocumentShardsInfoOptions getDocumentShardsInfoOptions) {
        Validator.notNull(getDocumentShardsInfoOptions, "getDocumentShardsInfoOptions cannot be null");
        HashMap<String, String> pathParamsMap = new HashMap<String, String>();
        pathParamsMap.put("db", getDocumentShardsInfoOptions.db());
        pathParamsMap.put("doc_id", getDocumentShardsInfoOptions.docId());
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/{db}/_shards/{doc_id}", pathParamsMap));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getDocumentShardsInfo");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<DocumentShardInfo>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headUpInformation(HeadUpInformationOptions headUpInformationOptions) {
        RequestBuilder builder = RequestBuilder.head(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_up"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "headUpInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        ResponseConverter<Void> responseConverter = ResponseConverterUtils.getVoid();
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<Void> headUpInformation() {
        return this.headUpInformation(null);
    }

    public ServiceCall<List<ActiveTask>> getActiveTasks(GetActiveTasksOptions getActiveTasksOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_active_tasks"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getActiveTasks");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<List<ActiveTask>>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<List<ActiveTask>> getActiveTasks() {
        return this.getActiveTasks(null);
    }

    public ServiceCall<UpInformation> getUpInformation(GetUpInformationOptions getUpInformationOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_up"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getUpInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<UpInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<UpInformation> getUpInformation() {
        return this.getUpInformation(null);
    }

    public ServiceCall<ActivityTrackerEvents> getActivityTrackerEvents(GetActivityTrackerEventsOptions getActivityTrackerEventsOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_api/v2/user/activity_tracker/events"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getActivityTrackerEvents");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<ActivityTrackerEvents>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<ActivityTrackerEvents> getActivityTrackerEvents() {
        return this.getActivityTrackerEvents(null);
    }

    public ServiceCall<Ok> postActivityTrackerEvents(PostActivityTrackerEventsOptions postActivityTrackerEventsOptions) {
        Validator.notNull(postActivityTrackerEventsOptions, "postActivityTrackerEventsOptions cannot be null");
        RequestBuilder builder = RequestBuilder.post(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_api/v2/user/activity_tracker/events"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "postActivityTrackerEvents");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        JsonObject contentJson = new JsonObject();
        contentJson.add("types", GsonSingleton.getGson().toJsonTree(postActivityTrackerEventsOptions.types()));
        builder.bodyJson(contentJson);
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<Ok>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CurrentThroughputInformation> getCurrentThroughputInformation(GetCurrentThroughputInformationOptions getCurrentThroughputInformationOptions) {
        RequestBuilder builder = RequestBuilder.get(RequestBuilder.resolveRequestUrl(this.getServiceUrl(), "/_api/v2/user/current/throughput"));
        Map<String, String> sdkHeaders = SdkCommon.getSdkHeaders(DEFAULT_SERVICE_NAME, "v1", "getCurrentThroughputInformation");
        for (Map.Entry<String, String> header : sdkHeaders.entrySet()) {
            builder.header(header.getKey(), header.getValue());
        }
        builder.header("Accept", "application/json");
        ResponseConverter responseConverter = ResponseConverterUtils.getValue(new TypeToken<CurrentThroughputInformation>(){}.getType());
        return this.createServiceCall(builder.build(), responseConverter);
    }

    public ServiceCall<CurrentThroughputInformation> getCurrentThroughputInformation() {
        return this.getCurrentThroughputInformation(null);
    }
}

