/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;

public class HeadAttachmentOptions
extends GenericModel {
    protected String db;
    protected String docId;
    protected String attachmentName;
    protected String ifMatch;
    protected String ifNoneMatch;
    protected String rev;

    protected HeadAttachmentOptions() {
    }

    protected HeadAttachmentOptions(Builder builder) {
        Validator.notEmpty(builder.db, "db cannot be empty");
        Validator.notEmpty(builder.docId, "docId cannot be empty");
        Validator.notEmpty(builder.attachmentName, "attachmentName cannot be empty");
        this.db = builder.db;
        this.docId = builder.docId;
        this.attachmentName = builder.attachmentName;
        this.ifMatch = builder.ifMatch;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.rev = builder.rev;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String docId() {
        return this.docId;
    }

    public String attachmentName() {
        return this.attachmentName;
    }

    public String ifMatch() {
        return this.ifMatch;
    }

    public String ifNoneMatch() {
        return this.ifNoneMatch;
    }

    public String rev() {
        return this.rev;
    }

    public static class Builder {
        private String db;
        private String docId;
        private String attachmentName;
        private String ifMatch;
        private String ifNoneMatch;
        private String rev;

        private Builder(HeadAttachmentOptions headAttachmentOptions) {
            this.db = headAttachmentOptions.db;
            this.docId = headAttachmentOptions.docId;
            this.attachmentName = headAttachmentOptions.attachmentName;
            this.ifMatch = headAttachmentOptions.ifMatch;
            this.ifNoneMatch = headAttachmentOptions.ifNoneMatch;
            this.rev = headAttachmentOptions.rev;
        }

        public Builder() {
        }

        public Builder(String db, String docId, String attachmentName) {
            this.db = db;
            this.docId = docId;
            this.attachmentName = attachmentName;
        }

        public HeadAttachmentOptions build() {
            return new HeadAttachmentOptions(this);
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder docId(String docId) {
            this.docId = docId;
            return this;
        }

        public Builder attachmentName(String attachmentName) {
            this.attachmentName = attachmentName;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public Builder rev(String rev) {
            this.rev = rev;
            return this;
        }
    }
}

