/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PostPartitionFindOptions
extends GenericModel {
    protected String db;
    protected String partitionKey;
    protected Map<String, Object> selector;
    protected String bookmark;
    protected Boolean conflicts;
    protected Boolean executionStats;
    protected List<String> fields;
    protected Long limit;
    protected Long skip;
    protected List<Map<String, String>> sort;
    protected Boolean stable;
    protected String update;
    protected List<String> useIndex;

    protected PostPartitionFindOptions() {
    }

    protected PostPartitionFindOptions(Builder builder) {
        Validator.notEmpty(builder.db, "db cannot be empty");
        Validator.notEmpty(builder.partitionKey, "partitionKey cannot be empty");
        Validator.notNull(builder.selector, "selector cannot be null");
        this.db = builder.db;
        this.partitionKey = builder.partitionKey;
        this.selector = builder.selector;
        this.bookmark = builder.bookmark;
        this.conflicts = builder.conflicts;
        this.executionStats = builder.executionStats;
        this.fields = builder.fields;
        this.limit = builder.limit;
        this.skip = builder.skip;
        this.sort = builder.sort;
        this.stable = builder.stable;
        this.update = builder.update;
        this.useIndex = builder.useIndex;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public Map<String, Object> selector() {
        return this.selector;
    }

    public String bookmark() {
        return this.bookmark;
    }

    public Boolean conflicts() {
        return this.conflicts;
    }

    public Boolean executionStats() {
        return this.executionStats;
    }

    public List<String> fields() {
        return this.fields;
    }

    public Long limit() {
        return this.limit;
    }

    public Long skip() {
        return this.skip;
    }

    public List<Map<String, String>> sort() {
        return this.sort;
    }

    public Boolean stable() {
        return this.stable;
    }

    public String update() {
        return this.update;
    }

    public List<String> useIndex() {
        return this.useIndex;
    }

    public static class Builder {
        private String db;
        private String partitionKey;
        private Map<String, Object> selector;
        private String bookmark;
        private Boolean conflicts;
        private Boolean executionStats;
        private List<String> fields;
        private Long limit;
        private Long skip;
        private List<Map<String, String>> sort;
        private Boolean stable;
        private String update;
        private List<String> useIndex;

        private Builder(PostPartitionFindOptions postPartitionFindOptions) {
            this.db = postPartitionFindOptions.db;
            this.partitionKey = postPartitionFindOptions.partitionKey;
            this.selector = postPartitionFindOptions.selector;
            this.bookmark = postPartitionFindOptions.bookmark;
            this.conflicts = postPartitionFindOptions.conflicts;
            this.executionStats = postPartitionFindOptions.executionStats;
            this.fields = postPartitionFindOptions.fields;
            this.limit = postPartitionFindOptions.limit;
            this.skip = postPartitionFindOptions.skip;
            this.sort = postPartitionFindOptions.sort;
            this.stable = postPartitionFindOptions.stable;
            this.update = postPartitionFindOptions.update;
            this.useIndex = postPartitionFindOptions.useIndex;
        }

        public Builder() {
        }

        public Builder(String db, String partitionKey, Map<String, Object> selector) {
            this.db = db;
            this.partitionKey = partitionKey;
            this.selector = selector;
        }

        public PostPartitionFindOptions build() {
            return new PostPartitionFindOptions(this);
        }

        public Builder addFields(String fields) {
            Validator.notNull(fields, "fields cannot be null");
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(fields);
            return this;
        }

        public Builder addSort(Map<String, String> sort) {
            Validator.notNull(sort, "sort cannot be null");
            if (this.sort == null) {
                this.sort = new ArrayList<Map<String, String>>();
            }
            this.sort.add(sort);
            return this;
        }

        public Builder addUseIndex(String useIndex) {
            Validator.notNull(useIndex, "useIndex cannot be null");
            if (this.useIndex == null) {
                this.useIndex = new ArrayList<String>();
            }
            this.useIndex.add(useIndex);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder selector(Map<String, Object> selector) {
            this.selector = selector;
            return this;
        }

        public Builder bookmark(String bookmark) {
            this.bookmark = bookmark;
            return this;
        }

        public Builder conflicts(Boolean conflicts) {
            this.conflicts = conflicts;
            return this;
        }

        public Builder executionStats(Boolean executionStats) {
            this.executionStats = executionStats;
            return this;
        }

        public Builder fields(List<String> fields) {
            this.fields = fields;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder skip(long skip) {
            this.skip = skip;
            return this;
        }

        public Builder sort(List<Map<String, String>> sort) {
            this.sort = sort;
            return this;
        }

        public Builder stable(Boolean stable) {
            this.stable = stable;
            return this;
        }

        public Builder update(String update) {
            this.update = update;
            return this;
        }

        public Builder useIndex(List<String> useIndex) {
            this.useIndex = useIndex;
            return this;
        }
    }

    public static interface Update {
        public static final String X_FALSE = "false";
        public static final String X_TRUE = "true";
        public static final String LAZY = "lazy";
    }
}

