/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.parallel;

import io.reactivex.exceptions.Exceptions;
import io.reactivex.functions.BiFunction;
import io.reactivex.internal.functions.ObjectHelper;
import io.reactivex.internal.subscribers.DeferredScalarSubscriber;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.Callable;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ParallelReduce<T, R>
extends ParallelFlowable<R> {
    final ParallelFlowable<? extends T> source;
    final Callable<R> initialSupplier;
    final BiFunction<R, ? super T, R> reducer;

    public ParallelReduce(ParallelFlowable<? extends T> source2, Callable<R> initialSupplier, BiFunction<R, ? super T, R> reducer) {
        this.source = source2;
        this.initialSupplier = initialSupplier;
        this.reducer = reducer;
    }

    @Override
    public void subscribe(Subscriber<? super R>[] subscribers) {
        if (!this.validate(subscribers)) {
            return;
        }
        int n = subscribers.length;
        Subscriber[] parents = new Subscriber[n];
        for (int i = 0; i < n; ++i) {
            R initialValue;
            try {
                initialValue = ObjectHelper.requireNonNull(this.initialSupplier.call(), "The initialSupplier returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.reportError(subscribers, ex);
                return;
            }
            parents[i] = new ParallelReduceSubscriber<T, R>(subscribers[i], initialValue, this.reducer);
        }
        this.source.subscribe(parents);
    }

    void reportError(Subscriber<?>[] subscribers, Throwable ex) {
        for (Subscriber<?> s : subscribers) {
            EmptySubscription.error(ex, s);
        }
    }

    @Override
    public int parallelism() {
        return this.source.parallelism();
    }

    static final class ParallelReduceSubscriber<T, R>
    extends DeferredScalarSubscriber<T, R> {
        private static final long serialVersionUID = 8200530050639449080L;
        final BiFunction<R, ? super T, R> reducer;
        R accumulator;
        boolean done;

        ParallelReduceSubscriber(Subscriber<? super R> subscriber, R initialValue, BiFunction<R, ? super T, R> reducer) {
            super(subscriber);
            this.accumulator = initialValue;
            this.reducer = reducer;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
                s.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T t) {
            if (!this.done) {
                R v;
                try {
                    v = ObjectHelper.requireNonNull(this.reducer.apply(this.accumulator, t), "The reducer returned a null value");
                }
                catch (Throwable ex) {
                    Exceptions.throwIfFatal(ex);
                    this.cancel();
                    this.onError(ex);
                    return;
                }
                this.accumulator = v;
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.accumulator = null;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (!this.done) {
                this.done = true;
                R a = this.accumulator;
                this.accumulator = null;
                this.complete(a);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

