/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.security;

import com.google.gson.JsonObject;
import com.ibm.cloud.cloudant.common.SdkCommon;
import com.ibm.cloud.sdk.core.http.HttpClientSingleton;
import com.ibm.cloud.sdk.core.http.HttpConfigOptions;
import com.ibm.cloud.sdk.core.http.RequestBuilder;
import com.ibm.cloud.sdk.core.http.ServiceCookieJar;
import com.ibm.cloud.sdk.core.security.AbstractToken;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.TokenRequestBasedAuthenticator;
import com.ibm.cloud.sdk.core.security.TokenServerResponse;
import com.ibm.cloud.sdk.core.service.exception.ServiceResponseException;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import okhttp3.Cookie;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class CouchDbSessionAuthenticator
extends TokenRequestBasedAuthenticator<CouchDbSessionToken, CouchDbSessionToken>
implements Authenticator {
    public static final String AUTH_TYPE = "COUCHDB_SESSION";
    private final String user;
    private final String pass;
    private final ServiceCookieJar cookieJar;
    private HttpUrl sessionUrl = null;
    private HttpConfigOptions options = null;
    private Headers headers = null;
    private OkHttpClient sessionAuthClient = null;

    public static Authenticator newAuthenticator(String username, String password) {
        return new CouchDbSessionAuthenticator(username, password);
    }

    private CouchDbSessionAuthenticator(String username, String password) {
        this.user = username;
        this.pass = password;
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
        this.cookieJar = new ServiceCookieJar(cookieManager);
    }

    public ServiceCookieJar getCookieJar() {
        return this.cookieJar;
    }

    public void setHttpConfigOptions(HttpConfigOptions options) {
        this.options = options;
    }

    public void setSessionUrl(String serviceUrl) {
        this.sessionUrl = RequestBuilder.constructHttpUrl(serviceUrl, new String[]{"_session"});
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        HashMap<String, String> mergedHeaders = new HashMap<String, String>();
        mergedHeaders.putAll(SdkCommon.getSdkHeaders("authenticatorPostSession"));
        mergedHeaders.putAll(headers);
        super.setHeaders(mergedHeaders);
        this.headers = Headers.of(mergedHeaders);
    }

    @Override
    public void validate() {
        if (this.user == null || this.user.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "username"));
        }
        if (this.pass == null || this.pass.isEmpty()) {
            throw new IllegalArgumentException(String.format("The %s property is required but was not specified.", "password"));
        }
    }

    @Override
    public String authenticationType() {
        return AUTH_TYPE;
    }

    @Override
    public void authenticate(Request.Builder requestBuilder) {
        super.getToken();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CouchDbSessionToken requestToken() {
        JsonObject creds = new JsonObject();
        creds.addProperty("username", this.user);
        creds.addProperty("password", this.pass);
        RequestBuilder postSessionbuilder = RequestBuilder.post(this.sessionUrl).bodyJson(creds);
        if (this.headers != null) {
            for (String key : this.headers.names()) {
                postSessionbuilder.header(key, this.headers.get(key));
            }
        }
        try {
            if (this.sessionAuthClient == null) {
                this.sessionAuthClient = HttpClientSingleton.getInstance().configureClient(this.options).newBuilder().cookieJar(this.cookieJar).build();
            }
            try (Response response = this.sessionAuthClient.newCall(postSessionbuilder.build()).execute();){
                Cookie cookie;
                if (!response.isSuccessful()) throw new ServiceResponseException(response.code(), response);
                List<Cookie> cookies = Cookie.parseAll(this.sessionUrl, response.headers());
                Iterator<Cookie> iterator2 = cookies.iterator();
                do {
                    if (!iterator2.hasNext()) throw new ServiceResponseException(response.code(), response);
                } while (!"AuthSession".equals((cookie = iterator2.next()).name()));
                CouchDbSessionToken couchDbSessionToken = new CouchDbSessionToken(cookie.expiresAt());
                return couchDbSessionToken;
            }
        }
        catch (IOException | RuntimeException t) {
            return new CouchDbSessionToken(t);
        }
    }

    public void invalidateToken() {
        this.tokenData = null;
    }

    public static class CouchDbSessionToken
    extends AbstractToken
    implements TokenServerResponse {
        public final long expiryTime;
        public final long refreshTime;

        public CouchDbSessionToken(long expiryTime) {
            this.expiryTime = expiryTime;
            this.refreshTime = expiryTime - (expiryTime - System.currentTimeMillis()) / 5L;
        }

        CouchDbSessionToken(Throwable throwable) {
            super(throwable);
            this.expiryTime = Long.MIN_VALUE;
            this.refreshTime = Long.MIN_VALUE;
        }

        @Override
        public boolean isTokenValid() {
            return System.currentTimeMillis() < this.expiryTime;
        }

        @Override
        public boolean needsRefresh() {
            return System.currentTimeMillis() > this.refreshTime;
        }

        @Override
        public String getAccessToken() {
            return null;
        }
    }
}

