/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PostPartitionSearchOptions
extends GenericModel {
    protected String db;
    protected String partitionKey;
    protected String ddoc;
    protected String index;
    protected String query;
    protected String bookmark;
    protected List<String> highlightFields;
    protected Long highlightNumber;
    protected String highlightPostTag;
    protected String highlightPreTag;
    protected Long highlightSize;
    protected Boolean includeDocs;
    protected List<String> includeFields;
    protected Long limit;
    protected List<String> sort;
    protected String stale;

    protected PostPartitionSearchOptions() {
    }

    protected PostPartitionSearchOptions(Builder builder) {
        Validator.notEmpty(builder.db, "db cannot be empty");
        Validator.notEmpty(builder.partitionKey, "partitionKey cannot be empty");
        Validator.notEmpty(builder.ddoc, "ddoc cannot be empty");
        Validator.notEmpty(builder.index, "index cannot be empty");
        Validator.notNull(builder.query, "query cannot be null");
        this.db = builder.db;
        this.partitionKey = builder.partitionKey;
        this.ddoc = builder.ddoc;
        this.index = builder.index;
        this.query = builder.query;
        this.bookmark = builder.bookmark;
        this.highlightFields = builder.highlightFields;
        this.highlightNumber = builder.highlightNumber;
        this.highlightPostTag = builder.highlightPostTag;
        this.highlightPreTag = builder.highlightPreTag;
        this.highlightSize = builder.highlightSize;
        this.includeDocs = builder.includeDocs;
        this.includeFields = builder.includeFields;
        this.limit = builder.limit;
        this.sort = builder.sort;
        this.stale = builder.stale;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public String ddoc() {
        return this.ddoc;
    }

    public String index() {
        return this.index;
    }

    public String query() {
        return this.query;
    }

    public String bookmark() {
        return this.bookmark;
    }

    public List<String> highlightFields() {
        return this.highlightFields;
    }

    public Long highlightNumber() {
        return this.highlightNumber;
    }

    public String highlightPostTag() {
        return this.highlightPostTag;
    }

    public String highlightPreTag() {
        return this.highlightPreTag;
    }

    public Long highlightSize() {
        return this.highlightSize;
    }

    public Boolean includeDocs() {
        return this.includeDocs;
    }

    public List<String> includeFields() {
        return this.includeFields;
    }

    public Long limit() {
        return this.limit;
    }

    public List<String> sort() {
        return this.sort;
    }

    public String stale() {
        return this.stale;
    }

    public static class Builder {
        private String db;
        private String partitionKey;
        private String ddoc;
        private String index;
        private String query;
        private String bookmark;
        private List<String> highlightFields;
        private Long highlightNumber;
        private String highlightPostTag;
        private String highlightPreTag;
        private Long highlightSize;
        private Boolean includeDocs;
        private List<String> includeFields;
        private Long limit;
        private List<String> sort;
        private String stale;

        private Builder(PostPartitionSearchOptions postPartitionSearchOptions) {
            this.db = postPartitionSearchOptions.db;
            this.partitionKey = postPartitionSearchOptions.partitionKey;
            this.ddoc = postPartitionSearchOptions.ddoc;
            this.index = postPartitionSearchOptions.index;
            this.query = postPartitionSearchOptions.query;
            this.bookmark = postPartitionSearchOptions.bookmark;
            this.highlightFields = postPartitionSearchOptions.highlightFields;
            this.highlightNumber = postPartitionSearchOptions.highlightNumber;
            this.highlightPostTag = postPartitionSearchOptions.highlightPostTag;
            this.highlightPreTag = postPartitionSearchOptions.highlightPreTag;
            this.highlightSize = postPartitionSearchOptions.highlightSize;
            this.includeDocs = postPartitionSearchOptions.includeDocs;
            this.includeFields = postPartitionSearchOptions.includeFields;
            this.limit = postPartitionSearchOptions.limit;
            this.sort = postPartitionSearchOptions.sort;
            this.stale = postPartitionSearchOptions.stale;
        }

        public Builder() {
        }

        public Builder(String db, String partitionKey, String ddoc, String index, String query) {
            this.db = db;
            this.partitionKey = partitionKey;
            this.ddoc = ddoc;
            this.index = index;
            this.query = query;
        }

        public PostPartitionSearchOptions build() {
            return new PostPartitionSearchOptions(this);
        }

        public Builder addHighlightFields(String highlightFields) {
            Validator.notNull(highlightFields, "highlightFields cannot be null");
            if (this.highlightFields == null) {
                this.highlightFields = new ArrayList<String>();
            }
            this.highlightFields.add(highlightFields);
            return this;
        }

        public Builder addIncludeFields(String includeFields) {
            Validator.notNull(includeFields, "includeFields cannot be null");
            if (this.includeFields == null) {
                this.includeFields = new ArrayList<String>();
            }
            this.includeFields.add(includeFields);
            return this;
        }

        public Builder addSort(String sort) {
            Validator.notNull(sort, "sort cannot be null");
            if (this.sort == null) {
                this.sort = new ArrayList<String>();
            }
            this.sort.add(sort);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public Builder ddoc(String ddoc) {
            this.ddoc = ddoc;
            return this;
        }

        public Builder index(String index) {
            this.index = index;
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder bookmark(String bookmark) {
            this.bookmark = bookmark;
            return this;
        }

        public Builder highlightFields(List<String> highlightFields) {
            this.highlightFields = highlightFields;
            return this;
        }

        public Builder highlightNumber(long highlightNumber) {
            this.highlightNumber = highlightNumber;
            return this;
        }

        public Builder highlightPostTag(String highlightPostTag) {
            this.highlightPostTag = highlightPostTag;
            return this;
        }

        public Builder highlightPreTag(String highlightPreTag) {
            this.highlightPreTag = highlightPreTag;
            return this;
        }

        public Builder highlightSize(long highlightSize) {
            this.highlightSize = highlightSize;
            return this;
        }

        public Builder includeDocs(Boolean includeDocs) {
            this.includeDocs = includeDocs;
            return this;
        }

        public Builder includeFields(List<String> includeFields) {
            this.includeFields = includeFields;
            return this;
        }

        public Builder limit(long limit) {
            this.limit = limit;
            return this;
        }

        public Builder sort(List<String> sort) {
            this.sort = sort;
            return this;
        }

        public Builder stale(String stale) {
            this.stale = stale;
            return this;
        }
    }

    public static interface Stale {
        public static final String OK = "ok";
    }
}

