/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.cloudant.v1.model;

import com.ibm.cloud.cloudant.v1.model.ViewQuery;
import com.ibm.cloud.sdk.core.service.model.GenericModel;
import com.ibm.cloud.sdk.core.util.Validator;
import java.util.ArrayList;
import java.util.List;

public class PostViewQueriesOptions
extends GenericModel {
    protected String db;
    protected String ddoc;
    protected String view;
    protected List<ViewQuery> queries;

    protected PostViewQueriesOptions() {
    }

    protected PostViewQueriesOptions(Builder builder) {
        Validator.notEmpty(builder.db, "db cannot be empty");
        Validator.notEmpty(builder.ddoc, "ddoc cannot be empty");
        Validator.notEmpty(builder.view, "view cannot be empty");
        Validator.notNull(builder.queries, "queries cannot be null");
        this.db = builder.db;
        this.ddoc = builder.ddoc;
        this.view = builder.view;
        this.queries = builder.queries;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String db() {
        return this.db;
    }

    public String ddoc() {
        return this.ddoc;
    }

    public String view() {
        return this.view;
    }

    public List<ViewQuery> queries() {
        return this.queries;
    }

    public static class Builder {
        private String db;
        private String ddoc;
        private String view;
        private List<ViewQuery> queries;

        private Builder(PostViewQueriesOptions postViewQueriesOptions) {
            this.db = postViewQueriesOptions.db;
            this.ddoc = postViewQueriesOptions.ddoc;
            this.view = postViewQueriesOptions.view;
            this.queries = postViewQueriesOptions.queries;
        }

        public Builder() {
        }

        public Builder(String db, String ddoc, String view, List<ViewQuery> queries) {
            this.db = db;
            this.ddoc = ddoc;
            this.view = view;
            this.queries = queries;
        }

        public PostViewQueriesOptions build() {
            return new PostViewQueriesOptions(this);
        }

        public Builder addQueries(ViewQuery queries) {
            Validator.notNull(queries, "queries cannot be null");
            if (this.queries == null) {
                this.queries = new ArrayList<ViewQuery>();
            }
            this.queries.add(queries);
            return this;
        }

        public Builder db(String db) {
            this.db = db;
            return this;
        }

        public Builder ddoc(String ddoc) {
            this.ddoc = ddoc;
            return this;
        }

        public Builder view(String view) {
            this.view = view;
            return this;
        }

        public Builder queries(List<ViewQuery> queries) {
            this.queries = queries;
            return this;
        }
    }
}

