/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.sdk.core.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.apache.commons.io.IOUtils;

public class InputStreamRequestBody
extends RequestBody {
    private static final Logger LOGGER = Logger.getLogger(InputStreamRequestBody.class.getName());
    private InputStream inputStream;
    private MediaType mediaType;
    private byte[] bytes;

    public static RequestBody create(MediaType mediaType, InputStream inputStream2) {
        return new InputStreamRequestBody(inputStream2, mediaType);
    }

    private InputStreamRequestBody(InputStream inputStream2, MediaType mediaType) {
        this.inputStream = inputStream2;
        this.mediaType = mediaType;
        ByteArrayOutputStream outputStream2 = new ByteArrayOutputStream();
        try {
            IOUtils.copy(inputStream2, (OutputStream)outputStream2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.bytes = outputStream2.toByteArray();
        try {
            outputStream2.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Could not close inputStream byte array.", e);
            e.printStackTrace();
        }
    }

    @Override
    public MediaType contentType() {
        return this.mediaType;
    }

    @Override
    public void writeTo(BufferedSink sink2) throws IOException {
        Source source2 = null;
        try {
            source2 = this.bytes != null ? Okio.source(new ByteArrayInputStream(this.bytes)) : Okio.source(this.inputStream);
            sink2.writeAll(source2);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(source2);
            throw throwable;
        }
        Util.closeQuietly(source2);
    }
}

