/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.google.gson.JsonParser;
import com.ibm.cloud.cloudant.v1.model.ChangesResult;
import com.ibm.cloud.cloudant.v1.model.ChangesResultItem;
import com.ibm.cloud.sdk.core.http.Response;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.couchdb.CouchDbClientWrapper;
import org.apache.camel.component.couchdb.CouchDbEndpoint;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.support.ScheduledBatchPollingConsumer;
import org.apache.camel.support.resume.ResumeStrategyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchDbConsumer
extends ScheduledBatchPollingConsumer
implements ResumeAware<ResumeStrategy> {
    private static final Logger LOG = LoggerFactory.getLogger(CouchDbConsumer.class);
    private final CouchDbClientWrapper couchClient;
    private final CouchDbEndpoint endpoint;
    private ExecutorService executor;
    private ResumeStrategy resumeStrategy;
    private String since;
    private String lastSequence = null;

    public CouchDbConsumer(CouchDbEndpoint endpoint, CouchDbClientWrapper couchClient, Processor processor) {
        super(endpoint, processor);
        this.couchClient = couchClient;
        this.endpoint = endpoint;
        this.since = couchClient.getLatestUpdateSequence();
    }

    @Override
    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }

    @Override
    public ResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    public Exchange createExchange(String seq, String id, ChangesResultItem changesResultItem, boolean deleted) {
        Exchange exchange = this.createExchange(false);
        exchange.getIn().setHeader("CouchDbDatabase", this.endpoint.getDatabase());
        exchange.getIn().setHeader("CouchDbSeq", seq);
        exchange.getIn().setHeader("CouchDbId", id);
        exchange.getIn().setHeader("CouchDbMethod", deleted ? "DELETE" : "UPDATE");
        new JsonParser();
        exchange.getIn().setBody(JsonParser.parseString(changesResultItem.toString()));
        return exchange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int poll() throws Exception {
        Response<ChangesResult> changesResultResponse = this.couchClient.pollChanges(this.endpoint.getStyle(), this.since, this.endpoint.getHeartbeat(), this.getMaxMessagesPerPoll());
        for (ChangesResultItem changesResultItem : changesResultResponse.getResult().getResults()) {
            if (changesResultItem.isDeleted() != null && (changesResultItem.isDeleted().booleanValue() && !this.endpoint.isDeletes() || !changesResultItem.isDeleted().booleanValue() && !this.endpoint.isUpdates())) continue;
            this.lastSequence = changesResultItem.getSeq();
            Exchange exchange = this.createExchange(this.lastSequence, changesResultItem.getId(), changesResultItem, changesResultItem.isDeleted() == null ? false : changesResultItem.isDeleted());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Created exchange [exchange={}, _id={}, seq={}", new Object[]{exchange, changesResultItem.getId(), this.lastSequence});
            }
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException("Error processing exchange.", exchange, e);
            }
            finally {
                this.since = changesResultItem.getSeq();
                this.releaseExchange(exchange, false);
            }
        }
        return changesResultResponse.getResult().getResults().size();
    }

    @Override
    protected void doStart() throws Exception {
        ResumeStrategyHelper.resume(this.getEndpoint().getCamelContext(), this, this.resumeStrategy, "CamelCouchDbResumeAction");
        super.doStart();
    }

    @Override
    public int processBatch(Queue<Object> exchanges) throws Exception {
        return 0;
    }
}

