/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchdb;

import com.ibm.cloud.cloudant.v1.Cloudant;
import com.ibm.cloud.sdk.core.security.Authenticator;
import com.ibm.cloud.sdk.core.security.BasicAuthenticator;
import com.ibm.cloud.sdk.core.security.NoAuthAuthenticator;
import java.net.URI;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.couchdb.CouchDbClientWrapper;
import org.apache.camel.component.couchdb.CouchDbComponent;
import org.apache.camel.component.couchdb.CouchDbConstants;
import org.apache.camel.component.couchdb.CouchDbConsumer;
import org.apache.camel.component.couchdb.CouchDbProducer;
import org.apache.camel.spi.EndpointServiceLocation;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@UriEndpoint(firstVersion="2.11.0", scheme="couchdb", title="CouchDB", syntax="couchdb:protocol:hostname:port/database", category={Category.DATABASE}, headersClass=CouchDbConstants.class)
public class CouchDbEndpoint
extends DefaultEndpoint
implements EndpointServiceLocation {
    public static final String DEFAULT_STYLE = "main_only";
    public static final long DEFAULT_HEARTBEAT = 30000L;
    public static final int DEFAULT_PORT = 5984;
    private static final String URI_ERROR = "Invalid URI. Format must be of the form couchdb:http[s]://hostname[:port]/database?[options...]";
    @UriPath(enums="http,https")
    @Metadata(required=true)
    private String protocol;
    @UriPath
    @Metadata(required=true)
    private String hostname;
    @UriPath(defaultValue="5984")
    private int port;
    @UriPath
    @Metadata(required=true)
    private String database;
    @UriParam(label="consumer", enums="all_docs,main_only", defaultValue="main_only")
    private String style = "main_only";
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam(label="consumer", defaultValue="30000", javaType="java.time.Duration")
    private long heartbeat = 30000L;
    @UriParam
    private boolean createDatabase;
    @UriParam(label="consumer", defaultValue="true")
    private boolean deletes = true;
    @UriParam(label="consumer", defaultValue="true")
    private boolean updates = true;
    @UriParam(label="consumer", defaultValue="10")
    private int maxMessagesPerPoll = 10;

    public CouchDbEndpoint() {
    }

    public CouchDbEndpoint(String endpointUri, String remaining, CouchDbComponent component) throws Exception {
        super(endpointUri, component);
        URI uri = new URI(remaining);
        this.protocol = uri.getScheme();
        if (this.protocol == null) {
            throw new IllegalArgumentException(URI_ERROR);
        }
        int n = this.port = uri.getPort() == -1 ? 5984 : uri.getPort();
        if (uri.getPath() == null || uri.getPath().isBlank()) {
            throw new IllegalArgumentException(URI_ERROR);
        }
        this.database = uri.getPath().substring(1);
        this.hostname = uri.getHost();
        if (this.hostname == null) {
            throw new IllegalArgumentException(URI_ERROR);
        }
    }

    @Override
    public String getServiceUrl() {
        return this.getProtocol() + ":" + this.getHostname() + ":" + this.getPort();
    }

    @Override
    public String getServiceProtocol() {
        return this.getProtocol();
    }

    @Override
    public Map<String, String> getServiceMetadata() {
        if (this.username != null) {
            return Map.of("username", this.username);
        }
        return null;
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        CouchDbConsumer answer = new CouchDbConsumer(this, this.createClient(), processor);
        answer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer(answer);
        return answer;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new CouchDbProducer(this, this.createClient());
    }

    protected CouchDbClientWrapper createClient() {
        Authenticator authenticator = this.username == null ? new NoAuthAuthenticator() : new BasicAuthenticator(this.username, this.password);
        Cloudant cloudant = new Cloudant("camel-couchdb", authenticator);
        cloudant.setServiceUrl(this.getServiceUrl());
        return new CouchDbClientWrapper(cloudant, this.database, this.createDatabase);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public void setHeartbeat(long heartbeat) {
        this.heartbeat = heartbeat;
    }

    public boolean isCreateDatabase() {
        return this.createDatabase;
    }

    public void setCreateDatabase(boolean createDatabase) {
        this.createDatabase = createDatabase;
    }

    public boolean isDeletes() {
        return this.deletes;
    }

    public void setDeletes(boolean deletes) {
        this.deletes = deletes;
    }

    public boolean isUpdates() {
        return this.updates;
    }

    public void setUpdates(boolean updates) {
        this.updates = updates;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }
}

