/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.PluginManager;

public class DefaultContextPluginManager
implements PluginManager {
    private final Map<Class<?>, Object> extensions = new ConcurrentHashMap();

    @Override
    public <T> T getContextPlugin(Class<T> type) {
        Object extension = this.extensions.get(type);
        if (extension == null) {
            for (Object e : this.extensions.values()) {
                if (!type.isInstance(e)) continue;
                return type.cast(e);
            }
        }
        if (extension instanceof Supplier) {
            Supplier supplier = (Supplier)extension;
            extension = supplier.get();
            this.addContextPlugin(type, extension);
        }
        return (T)extension;
    }

    @Override
    public <T> void addContextPlugin(Class<T> type, T module) {
        if (module != null) {
            try {
                this.extensions.put(type, module);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
    }

    @Override
    public <T> void lazyAddContextPlugin(Class<T> type, Supplier<T> module) {
        if (module != null) {
            this.extensions.put(type, module);
        }
    }
}

