/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;

public class RemovePropertiesProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private String id;
    private String routeId;
    private final String pattern;
    private final String[] excludePattern;

    public RemovePropertiesProcessor(String pattern, String[] excludePattern) {
        this.pattern = pattern;
        this.excludePattern = excludePattern;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            exchange.removeProperties(this.pattern, this.excludePattern);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        callback.done(true);
        return true;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getTraceLabel() {
        return "removeProperties[" + this.pattern + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String[] getExcludePattern() {
        return this.excludePattern;
    }
}

