/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import org.apache.camel.CamelContext;
import org.apache.camel.component.crypto.DigitalSignatureEndpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.support.jsse.KeyStoreParameters;

public class DigitalSignatureEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        DigitalSignatureEndpoint target = (DigitalSignatureEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                target.getConfiguration().setAlgorithm(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "alias": {
                target.getConfiguration().setAlias(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "buffersize": 
            case "bufferSize": {
                target.getConfiguration().setBufferSize(DigitalSignatureEndpointConfigurer.property(camelContext, Integer.class, value));
                return true;
            }
            case "certificate": {
                target.getConfiguration().setCertificate(DigitalSignatureEndpointConfigurer.property(camelContext, Certificate.class, value));
                return true;
            }
            case "certificatename": 
            case "certificateName": {
                target.getConfiguration().setCertificateName(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "clearheaders": 
            case "clearHeaders": {
                target.getConfiguration().setClearHeaders(DigitalSignatureEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "keystoreparameters": 
            case "keyStoreParameters": {
                target.getConfiguration().setKeyStoreParameters(DigitalSignatureEndpointConfigurer.property(camelContext, KeyStoreParameters.class, value));
                return true;
            }
            case "keystore": {
                target.getConfiguration().setKeystore(DigitalSignatureEndpointConfigurer.property(camelContext, KeyStore.class, value));
                return true;
            }
            case "keystorename": 
            case "keystoreName": {
                target.getConfiguration().setKeystoreName(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(DigitalSignatureEndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "password": {
                target.getConfiguration().setPassword(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "privatekey": 
            case "privateKey": {
                target.getConfiguration().setPrivateKey(DigitalSignatureEndpointConfigurer.property(camelContext, PrivateKey.class, value));
                return true;
            }
            case "privatekeyname": 
            case "privateKeyName": {
                target.getConfiguration().setPrivateKeyName(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "provider": {
                target.getConfiguration().setProvider(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "publickey": 
            case "publicKey": {
                target.getConfiguration().setPublicKey(DigitalSignatureEndpointConfigurer.property(camelContext, PublicKey.class, value));
                return true;
            }
            case "publickeyname": 
            case "publicKeyName": {
                target.getConfiguration().setPublicKeyName(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "securerandom": 
            case "secureRandom": {
                target.getConfiguration().setSecureRandom(DigitalSignatureEndpointConfigurer.property(camelContext, SecureRandom.class, value));
                return true;
            }
            case "securerandomname": 
            case "secureRandomName": {
                target.getConfiguration().setSecureRandomName(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "signatureheadername": 
            case "signatureHeaderName": {
                target.getConfiguration().setSignatureHeaderName(DigitalSignatureEndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                return String.class;
            }
            case "alias": {
                return String.class;
            }
            case "buffersize": 
            case "bufferSize": {
                return Integer.class;
            }
            case "certificate": {
                return Certificate.class;
            }
            case "certificatename": 
            case "certificateName": {
                return String.class;
            }
            case "clearheaders": 
            case "clearHeaders": {
                return Boolean.TYPE;
            }
            case "keystoreparameters": 
            case "keyStoreParameters": {
                return KeyStoreParameters.class;
            }
            case "keystore": {
                return KeyStore.class;
            }
            case "keystorename": 
            case "keystoreName": {
                return String.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "privatekey": 
            case "privateKey": {
                return PrivateKey.class;
            }
            case "privatekeyname": 
            case "privateKeyName": {
                return String.class;
            }
            case "provider": {
                return String.class;
            }
            case "publickey": 
            case "publicKey": {
                return PublicKey.class;
            }
            case "publickeyname": 
            case "publicKeyName": {
                return String.class;
            }
            case "securerandom": 
            case "secureRandom": {
                return SecureRandom.class;
            }
            case "securerandomname": 
            case "secureRandomName": {
                return String.class;
            }
            case "signatureheadername": 
            case "signatureHeaderName": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        DigitalSignatureEndpoint target = (DigitalSignatureEndpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "algorithm": {
                return target.getConfiguration().getAlgorithm();
            }
            case "alias": {
                return target.getConfiguration().getAlias();
            }
            case "buffersize": 
            case "bufferSize": {
                return target.getConfiguration().getBufferSize();
            }
            case "certificate": {
                return target.getConfiguration().getCertificate();
            }
            case "certificatename": 
            case "certificateName": {
                return target.getConfiguration().getCertificateName();
            }
            case "clearheaders": 
            case "clearHeaders": {
                return target.getConfiguration().isClearHeaders();
            }
            case "keystoreparameters": 
            case "keyStoreParameters": {
                return target.getConfiguration().getKeyStoreParameters();
            }
            case "keystore": {
                return target.getConfiguration().getKeystore();
            }
            case "keystorename": 
            case "keystoreName": {
                return target.getConfiguration().getKeystoreName();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "password": {
                return target.getConfiguration().getPassword();
            }
            case "privatekey": 
            case "privateKey": {
                return target.getConfiguration().getPrivateKey();
            }
            case "privatekeyname": 
            case "privateKeyName": {
                return target.getConfiguration().getPrivateKeyName();
            }
            case "provider": {
                return target.getConfiguration().getProvider();
            }
            case "publickey": 
            case "publicKey": {
                return target.getConfiguration().getPublicKey();
            }
            case "publickeyname": 
            case "publicKeyName": {
                return target.getConfiguration().getPublicKeyName();
            }
            case "securerandom": 
            case "secureRandom": {
                return target.getConfiguration().getSecureRandom();
            }
            case "securerandomname": 
            case "secureRandomName": {
                return target.getConfiguration().getSecureRandomName();
            }
            case "signatureheadername": 
            case "signatureHeaderName": {
                return target.getConfiguration().getSignatureHeaderName();
            }
        }
        return null;
    }
}

