/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class DigitalSignatureEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":cryptoOperation:name";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        return "crypto".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "cryptoOperation", null, true, copy);
        uri = this.buildPathParameter(syntax, (String)uri, "name", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(21);
        props.add("algorithm");
        props.add("alias");
        props.add("bufferSize");
        props.add("certificate");
        props.add("certificateName");
        props.add("clearHeaders");
        props.add("cryptoOperation");
        props.add("keyStoreParameters");
        props.add("keystore");
        props.add("keystoreName");
        props.add("lazyStartProducer");
        props.add("name");
        props.add("password");
        props.add("privateKey");
        props.add("privateKeyName");
        props.add("provider");
        props.add("publicKey");
        props.add("publicKeyName");
        props.add("secureRandom");
        props.add("secureRandomName");
        props.add("signatureHeaderName");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(4);
        secretProps.add("password");
        secretProps.add("privateKey");
        secretProps.add("privateKeyName");
        secretProps.add("secureRandom");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

