/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Predicate;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ClassicUuidGenerator;
import org.apache.camel.support.DefaultUuidGenerator;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.ExpressionAdapter;
import org.apache.camel.support.LanguageHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ShortUuidGenerator;
import org.apache.camel.support.SimpleUuidGenerator;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.SkipIterator;
import org.apache.camel.util.StringHelper;

public final class SimpleExpressionBuilder {
    private static final Pattern OFFSET_PATTERN = Pattern.compile("([+-])([^+-]+)");

    private SimpleExpressionBuilder() {
    }

    public static Expression headersOgnlExpression(String ognl) {
        return new KeyedOgnlExpressionAdapter(ognl, "headerOgnl(" + ognl + ")", (exchange, exp) -> {
            String text = exp.evaluate(exchange, String.class);
            return exchange.getIn().getHeader(text);
        });
    }

    public static Expression variablesOgnlExpression(String ognl) {
        return new KeyedOgnlExpressionAdapter(ognl, "variableOgnl(" + ognl + ")", (exchange, exp) -> {
            String text = exp.evaluate(exchange, String.class);
            return ExchangeHelper.getVariable(exchange, text);
        });
    }

    public static Expression messageHistoryExpression(final boolean detailed) {
        return new ExpressionAdapter(){
            private ExchangeFormatter formatter;

            @Override
            public void init(CamelContext context) {
                if (detailed) {
                    this.formatter = this.getOrCreateExchangeFormatter(context);
                }
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return MessageHelper.dumpMessageHistoryStacktrace(exchange, this.formatter, false);
            }

            private ExchangeFormatter getOrCreateExchangeFormatter(CamelContext camelContext) {
                return LanguageHelper.getOrCreateExchangeFormatter(camelContext, this.formatter);
            }

            public String toString() {
                return "messageHistory(" + detailed + ")";
            }
        };
    }

    public static Expression collateExpression(final String expression, final int group) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = context.resolveLanguage("simple").createExpression(expression);
                this.exp.init(context);
                this.exp = ExpressionBuilder.groupIteratorExpression(this.exp, null, Integer.toString(group), false);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            public String toString() {
                return "collate(" + expression + "," + group + ")";
            }
        };
    }

    public static Expression skipExpression(final String expression, final int number) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = context.resolveLanguage("simple").createExpression(expression);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return SimpleExpressionBuilder.skipIteratorExpression(this.exp, number).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "skip(" + expression + "," + number + ")";
            }
        };
    }

    public static Expression iifExpression(final String predicate, final String trueValue, final String falseValue) {
        return new ExpressionAdapter(){
            private Predicate pred;
            private Expression expTrue;
            private Expression expFalse;

            @Override
            public void init(CamelContext context) {
                this.pred = context.resolveLanguage("simple").createPredicate(predicate);
                this.pred.init(context);
                this.expTrue = context.resolveLanguage("simple").createExpression(trueValue);
                this.expTrue.init(context);
                this.expFalse = context.resolveLanguage("simple").createExpression(falseValue);
                this.expFalse.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                if (this.pred.matches(exchange)) {
                    return this.expTrue.evaluate(exchange, Object.class);
                }
                return this.expFalse.evaluate(exchange, Object.class);
            }

            public String toString() {
                return "iif(" + predicate + "," + trueValue + "," + falseValue + ")";
            }
        };
    }

    public static Expression joinExpression(final String expression, final String separator, final String prefix) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = context.resolveLanguage("simple").createExpression(expression);
                this.exp.init(context);
                this.exp = ExpressionBuilder.joinExpression(this.exp, separator, prefix);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            public String toString() {
                if (prefix != null) {
                    return "join(" + expression + "," + separator + "," + prefix + ")";
                }
                return "join(" + expression + "," + separator + ")";
            }
        };
    }

    public static Expression replaceExpression(final String expression, final String from, final String to) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = context.resolveLanguage("simple").createExpression(expression);
                this.exp.init(context);
                this.exp = ExpressionBuilder.replaceAll(this.exp, from, to);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            public String toString() {
                return "replace(" + expression + "," + from + "," + to + ")";
            }
        };
    }

    public static Expression substringExpression(final String expression, final String head, final String tail) {
        return new ExpressionAdapter(){
            private Expression exp;
            private Expression exp1;
            private Expression exp2;

            @Override
            public void init(CamelContext context) {
                this.exp = context.resolveLanguage("simple").createExpression(expression);
                this.exp.init(context);
                this.exp1 = ExpressionBuilder.simpleExpression(head);
                this.exp1.init(context);
                this.exp2 = ExpressionBuilder.simpleExpression(tail);
                this.exp2.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                int num1 = this.exp1.evaluate(exchange, Integer.class);
                int num2 = this.exp2.evaluate(exchange, Integer.class);
                if (num1 < 0 && num2 == 0) {
                    num2 = num1;
                    num1 = 0;
                }
                num1 = Math.abs(num1);
                num2 = Math.abs(num2);
                return ExpressionBuilder.substring(this.exp, num1, num2).evaluate(exchange, Object.class);
            }

            public String toString() {
                return "substring(" + expression + "," + head + "," + tail + ")";
            }
        };
    }

    public static Expression hashExpression(final String expression, final String algorithm) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = context.resolveLanguage("simple").createExpression(expression);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                byte[] data = this.exp.evaluate(exchange, byte[].class);
                if (data != null && data.length > 0) {
                    try {
                        MessageDigest digest = MessageDigest.getInstance(algorithm);
                        byte[] bytes = digest.digest(data);
                        return StringHelper.bytesToHex(bytes);
                    }
                    catch (Exception e) {
                        throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                    }
                }
                return null;
            }

            public String toString() {
                return "hash(" + expression + "," + algorithm + ")";
            }
        };
    }

    public static Expression randomExpression(final String min, final String max) {
        return new ExpressionAdapter(){
            private Expression exp1;
            private Expression exp2;

            @Override
            public Object evaluate(Exchange exchange) {
                int num1 = this.exp1.evaluate(exchange, Integer.class);
                int num2 = this.exp2.evaluate(exchange, Integer.class);
                Random random = new Random();
                return random.nextInt(num2 - num1) + num1;
            }

            @Override
            public void init(CamelContext context) {
                this.exp1 = ExpressionBuilder.simpleExpression(min);
                this.exp1.init(context);
                this.exp2 = ExpressionBuilder.simpleExpression(max);
                this.exp2.init(context);
            }

            public String toString() {
                return "random(" + min + "," + max + ")";
            }
        };
    }

    public static Expression randomExpression(int max) {
        return SimpleExpressionBuilder.randomExpression(0, max);
    }

    public static Expression randomExpression(final int min, final int max) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Random random = new Random();
                return random.nextInt(max - min) + min;
            }

            public String toString() {
                return "random(" + min + "," + max + ")";
            }
        };
    }

    public static Expression newEmptyExpression(final String type) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                if ("map".equalsIgnoreCase(type)) {
                    return new LinkedHashMap();
                }
                if ("string".equalsIgnoreCase(type)) {
                    return "";
                }
                if ("list".equalsIgnoreCase(type)) {
                    return new ArrayList();
                }
                throw new IllegalArgumentException("function empty(%s) has unknown type".formatted(type));
            }

            public String toString() {
                return "empty(%s)".formatted(type);
            }
        };
    }

    public static Expression uuidExpression(final String generator) {
        return new ExpressionAdapter(){
            UuidGenerator uuid;

            @Override
            public Object evaluate(Exchange exchange) {
                return this.uuid.generateUuid();
            }

            @Override
            public void init(CamelContext context) {
                this.uuid = "classic".equalsIgnoreCase(generator) ? new ClassicUuidGenerator() : ("short".equals(generator) ? new ShortUuidGenerator() : ("simple".equals(generator) ? new SimpleUuidGenerator() : (generator == null || "default".equals(generator) ? new DefaultUuidGenerator() : CamelContextHelper.mandatoryLookup(context, generator, UuidGenerator.class))));
            }

            public String toString() {
                if (generator != null) {
                    return "uuid(" + generator + ")";
                }
                return "uuid";
            }
        };
    }

    public static Expression fileNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileName", String.class);
            }

            public String toString() {
                return "file:name";
            }
        };
    }

    public static Expression fileOnlyNameExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String answer = exchange.getIn().getHeader("CamelFileNameOnly", String.class);
                if (answer == null) {
                    answer = exchange.getIn().getHeader("CamelFileName", String.class);
                    answer = FileUtil.stripPath(answer);
                }
                return answer;
            }

            public String toString() {
                return "file:onlyname";
            }
        };
    }

    public static Expression fileNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:name.noext";
            }
        };
    }

    public static Expression fileNameNoExtensionSingleExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.stripExt(name, true);
            }

            public String toString() {
                return "file:name.noext.single";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = SimpleExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt(name);
            }

            public String toString() {
                return "file:onlyname.noext";
            }
        };
    }

    public static Expression fileOnlyNameNoExtensionSingleExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = SimpleExpressionBuilder.fileOnlyNameExpression().evaluate(exchange, String.class);
                return FileUtil.stripExt(name, true);
            }

            public String toString() {
                return "file:onlyname.noext.single";
            }
        };
    }

    public static Expression fileExtensionExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.onlyExt(name);
            }

            public String toString() {
                return "file:ext";
            }
        };
    }

    public static Expression fileExtensionSingleExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                String name = exchange.getIn().getHeader("CamelFileName", String.class);
                return FileUtil.onlyExt(name, true);
            }

            public String toString() {
                return "file:ext.single";
            }
        };
    }

    public static Expression fileParentExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileParent", String.class);
            }

            public String toString() {
                return "file:parent";
            }
        };
    }

    public static Expression filePathExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFilePath", String.class);
            }

            public String toString() {
                return "file:path";
            }
        };
    }

    public static Expression fileAbsolutePathExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolutePath", String.class);
            }

            public String toString() {
                return "file:absolute.path";
            }
        };
    }

    public static Expression fileAbsoluteExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileAbsolute", Boolean.class);
            }

            public String toString() {
                return "file:absolute";
            }
        };
    }

    public static Expression fileSizeExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLength", Long.class);
            }

            public String toString() {
                return "file:length";
            }
        };
    }

    public static Expression fileLastModifiedExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return exchange.getIn().getHeader("CamelFileLastModified", Long.class);
            }

            public String toString() {
                return "file:modified";
            }
        };
    }

    public static Expression dateExpression(String command) {
        return SimpleExpressionBuilder.dateExpression(command, null, null);
    }

    public static Expression dateExpression(String command, String pattern) {
        return SimpleExpressionBuilder.dateExpression(command, null, pattern);
    }

    public static Expression dateExpression(final String commandWithOffsets, final String timezone, final String pattern) {
        final String command = commandWithOffsets.split("[+-]", 2)[0].trim();
        final List<Long> offsets = LanguageHelper.captureOffsets(commandWithOffsets, OFFSET_PATTERN);
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Date date = SimpleExpressionBuilder.evalDate(exchange, command);
                return LanguageHelper.applyDateOffsets(date, offsets, pattern, timezone);
            }

            public String toString() {
                if (timezone != null && pattern != null) {
                    return "date(" + commandWithOffsets + ":" + timezone + ":" + pattern + ")";
                }
                if (pattern != null) {
                    return "date(" + commandWithOffsets + ":" + pattern + ")";
                }
                return "date(" + commandWithOffsets + ")";
            }
        };
    }

    private static Date evalDate(Exchange exchange, String command) {
        Date date;
        if ("now".equals(command)) {
            date = new Date();
        } else if ("exchangeCreated".equals(command)) {
            date = LanguageHelper.dateFromExchangeCreated(exchange);
        } else if (command.startsWith("header.")) {
            date = LanguageHelper.dateFromHeader(exchange, command, (e, o) -> SimpleExpressionBuilder.tryConvertingAsDate(e, o, command));
        } else if (command.startsWith("variable.")) {
            date = LanguageHelper.dateFromVariable(exchange, command, (e, o) -> SimpleExpressionBuilder.tryConvertingAsDate(e, o, command));
        } else if (command.startsWith("exchangeProperty.")) {
            date = LanguageHelper.dateFromExchangeProperty(exchange, command, (e, o) -> SimpleExpressionBuilder.tryConvertingAsDate(e, o, command));
        } else if ("file".equals(command)) {
            date = LanguageHelper.dateFromFileLastModified(exchange, command);
        } else {
            throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
        }
        return date;
    }

    private static Date tryConvertingAsDate(Exchange exchange, Object obj, String command) {
        Date date = exchange.getContext().getTypeConverter().tryConvertTo(Date.class, exchange, obj);
        if (date == null) {
            throw new IllegalArgumentException("Cannot find Date/long object at command: " + command);
        }
        return date;
    }

    public static Expression skipIteratorExpression(final Expression expression, final int skip) {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                Iterator it = expression.evaluate(exchange, Iterator.class);
                ObjectHelper.notNull(it, "expression: " + String.valueOf(expression) + " evaluated on " + String.valueOf(exchange) + " must return an java.util.Iterator");
                return new SkipIterator(it, skip);
            }

            public String toString() {
                return "skip " + String.valueOf(expression) + " " + skip + " times";
            }
        };
    }

    public static Expression nullExpression() {
        return new ExpressionAdapter(){

            @Override
            public Object evaluate(Exchange exchange) {
                return null;
            }

            public String toString() {
                return "null";
            }
        };
    }

    public static Expression mandatoryBodyOgnlExpression(final String name, final String ognl) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private Expression exp;
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Object body;
                Class<?> type;
                String text = this.exp.evaluate(exchange, String.class);
                try {
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                try {
                    body = exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                Expression ognlExp = this.bean.createExpression(null, new Object[]{null, body, ognl});
                ognlExp.init(exchange.getContext());
                return ognlExp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.classResolver = context.getClassResolver();
                this.exp = ExpressionBuilder.simpleExpression(name);
                this.exp.init(context);
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "mandatoryBodyAs[" + name + "](" + ognl + ")";
            }
        };
    }

    public static Expression mandatoryBodyExpression(final String name) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private Expression exp;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text = this.exp.evaluate(exchange, String.class);
                try {
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                try {
                    return exchange.getIn().getMandatoryBody(type);
                }
                catch (InvalidPayloadException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
            }

            @Override
            public void init(CamelContext context) {
                this.classResolver = context.getClassResolver();
                this.exp = ExpressionBuilder.simpleExpression(name);
                this.exp.init(context);
            }

            public String toString() {
                return "mandatoryBodyAs[" + name + "]";
            }
        };
    }

    public static Expression messageOgnlExpression(final String name, final String ognl) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private Expression exp;
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text = this.exp.evaluate(exchange, String.class);
                try {
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                Object msg = exchange.getMessage(type);
                if (msg != null) {
                    Expression ognlExp = this.bean.createExpression(null, new Object[]{null, msg, ognl});
                    ognlExp.init(exchange.getContext());
                    return ognlExp.evaluate(exchange, Object.class);
                }
                return null;
            }

            @Override
            public void init(CamelContext context) {
                this.classResolver = context.getClassResolver();
                this.exp = ExpressionBuilder.simpleExpression(name);
                this.exp.init(context);
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "messageOgnlAs[" + name + "](" + ognl + ")";
            }
        };
    }

    public static Expression bodyOgnlExpression(final String name, final String ognl) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private Expression exp;
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Class<?> type;
                String text = this.exp.evaluate(exchange, String.class);
                try {
                    type = this.classResolver.resolveMandatoryClass(text);
                }
                catch (ClassNotFoundException e) {
                    throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
                }
                Object body = exchange.getIn().getBody(type);
                if (body != null) {
                    Expression ognlExp = this.bean.createExpression(null, new Object[]{null, body, ognl});
                    ognlExp.init(exchange.getContext());
                    return ognlExp.evaluate(exchange, Object.class);
                }
                return null;
            }

            @Override
            public void init(CamelContext context) {
                this.classResolver = context.getClassResolver();
                this.exp = ExpressionBuilder.simpleExpression(name);
                this.exp.init(context);
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "bodyOgnlAs[" + name + "](" + ognl + ")";
            }
        };
    }

    public static Expression exchangeOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Expression ognlExp = this.bean.createExpression(null, new Object[]{null, exchange, ognl});
                ognlExp.init(exchange.getContext());
                return ognlExp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "exchangeOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression camelContextOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.exp = ExpressionBuilder.beanExpression(context, ognl);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                return this.exp.evaluate(exchange, Object.class);
            }

            public String toString() {
                return "camelContextOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression bodyOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Object body = exchange.getIn().getBody();
                if (body == null) {
                    return null;
                }
                Expression ognlExp = this.bean.createExpression(null, new Object[]{null, body, ognl});
                ognlExp.init(exchange.getContext());
                return ognlExp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "bodyOgnl(" + ognl + ")";
            }
        };
    }

    public static Expression cacheExpression(final Expression expression) {
        return new ExpressionAdapter(){
            private final AtomicReference<Object> cache = new AtomicReference();

            @Override
            public Object evaluate(Exchange exchange) {
                Object answer = this.cache.get();
                if (answer == null) {
                    answer = expression.evaluate(exchange, Object.class);
                    this.cache.set(answer);
                }
                return answer;
            }

            public String toString() {
                return expression.toString();
            }
        };
    }

    public static Expression typeExpression(final String name) {
        return new ExpressionAdapter(){
            private ClassResolver classResolver;
            private Expression exp;

            @Override
            public void init(CamelContext context) {
                this.classResolver = context.getClassResolver();
                this.exp = ExpressionBuilder.simpleExpression(name);
                this.exp.init(context);
            }

            @Override
            public Object evaluate(Exchange exchange) {
                String text = this.exp.evaluate(exchange, String.class);
                Class<?> type = this.classResolver.resolveClass(text);
                if (type != null) {
                    return type;
                }
                int pos = text.lastIndexOf(46);
                if (pos > 0) {
                    String before = text.substring(0, pos);
                    String after = text.substring(pos + 1);
                    type = this.classResolver.resolveClass(before);
                    if (type != null) {
                        if (type.isEnum()) {
                            Class<?> enumClass = type;
                            for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
                                if (!enumValue.name().equalsIgnoreCase(after)) continue;
                                return type.cast(enumValue);
                            }
                            throw CamelExecutionException.wrapCamelExecutionException(exchange, new ClassNotFoundException("Cannot find enum: " + after + " on type: " + String.valueOf(type)));
                        }
                        String answer = ObjectHelper.lookupConstantFieldValue(type, after);
                        if (answer != null) {
                            return answer;
                        }
                    }
                }
                throw CamelExecutionException.wrapCamelExecutionException(exchange, new ClassNotFoundException("Cannot find type: " + text));
            }

            public String toString() {
                return "type:" + name;
            }
        };
    }

    public static Expression propertyOgnlExpression(String ognl) {
        return new KeyedOgnlExpressionAdapter(ognl, "propertyOgnl(" + ognl + ")", (exchange, exp) -> {
            String text = exp.evaluate(exchange, String.class);
            return exchange.getProperty(text);
        });
    }

    public static Expression exchangeExceptionOgnlExpression(final String ognl) {
        return new ExpressionAdapter(){
            private Language bean;

            @Override
            public Object evaluate(Exchange exchange) {
                Exception exception = exchange.getException();
                if (exception == null) {
                    exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
                }
                if (exception == null) {
                    return null;
                }
                Expression ognlExp = this.bean.createExpression(null, new Object[]{null, exception, ognl});
                ognlExp.init(exchange.getContext());
                return ognlExp.evaluate(exchange, Object.class);
            }

            @Override
            public void init(CamelContext context) {
                this.bean = context.resolveLanguage("bean");
            }

            public String toString() {
                return "exchangeExceptionOgnl(" + ognl + ")";
            }
        };
    }

    public static class KeyedOgnlExpressionAdapter
    extends ExpressionAdapter {
        private final String ognl;
        private final String toStringValue;
        private final KeyedEntityRetrievalStrategy keyedEntityRetrievalStrategy;
        private String key;
        private final String method;
        private Expression keyExpression;
        private Expression ognlExpression;
        private Language beanLanguage;

        KeyedOgnlExpressionAdapter(String ognl, String toStringValue, KeyedEntityRetrievalStrategy keyedEntityRetrievalStrategy) {
            this.ognl = ognl;
            this.toStringValue = toStringValue;
            this.keyedEntityRetrievalStrategy = keyedEntityRetrievalStrategy;
            List<String> methods = OgnlHelper.splitOgnl(ognl);
            this.key = methods.get(0);
            String keySuffix = "";
            if (this.key.startsWith("[") && this.key.endsWith("]")) {
                this.key = StringHelper.removeLeadingAndEndingQuotes(this.key.substring(1, this.key.length() - 1));
                keySuffix = StringHelper.after(methods.get(0), this.key);
            }
            this.key = OgnlHelper.removeOperators(this.key);
            this.method = StringHelper.after(ognl, this.key + keySuffix);
        }

        @Override
        public void init(CamelContext context) {
            this.beanLanguage = context.resolveLanguage("bean");
            this.ognlExpression = ExpressionBuilder.simpleExpression(this.ognl);
            this.ognlExpression.init(context);
        }

        @Override
        public Object evaluate(Exchange exchange) {
            Object property = this.keyedEntityRetrievalStrategy.getKeyedEntity(exchange, this.ognlExpression);
            if (property != null) {
                return property;
            }
            if (this.keyExpression == null) {
                this.keyExpression = ExpressionBuilder.simpleExpression(this.key);
                this.keyExpression.init(exchange.getContext());
            }
            if ((property = this.keyedEntityRetrievalStrategy.getKeyedEntity(exchange, this.keyExpression)) == null) {
                return null;
            }
            if (this.method != null) {
                Expression exp = this.beanLanguage.createExpression(null, new Object[]{null, property, this.method});
                exp.init(exchange.getContext());
                return exp.evaluate(exchange, Object.class);
            }
            return property;
        }

        public String toString() {
            return this.toStringValue;
        }

        public static interface KeyedEntityRetrievalStrategy {
            public Object getKeyedEntity(Exchange var1, Expression var2);
        }
    }
}

