/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.csimple;

import java.lang.reflect.Array;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExchangeException;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.GroupIterator;
import org.apache.camel.support.LanguageHelper;
import org.apache.camel.support.MessageHelper;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.InetAddressUtil;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.SkipIterator;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.json.Jsoner;
import org.apache.camel.util.xml.pretty.XmlPrettyPrinter;

public final class CSimpleHelper {
    private static final Pattern RANGE_PATTERN = Pattern.compile("^(\\d+)(\\.\\.)(\\d+)$");
    private static final Pattern OFFSET_PATTERN = Pattern.compile("([+-])([^+-]+)");
    private static ExchangeFormatter exchangeFormatter;

    private CSimpleHelper() {
    }

    public static <T> T convertTo(Exchange exchange, Class<T> type, Object value) {
        return exchange.getContext().getTypeConverter().convertTo(type, exchange, value);
    }

    public static <T> T tryConvertTo(Exchange exchange, Class<T> type, Object value) {
        return exchange.getContext().getTypeConverter().tryConvertTo(type, exchange, value);
    }

    public static <T> T messageAs(Exchange exchange, Class<T> type) {
        return exchange.getMessage(type);
    }

    public static <T> T bodyAs(Message message, Class<T> type) {
        return message.getBody(type);
    }

    public static <T> T mandatoryBodyAs(Message message, Class<T> type) throws InvalidPayloadException {
        return message.getMandatoryBody(type);
    }

    public static <T> T bodyAsIndex(Message message, Class<T> type, int key) {
        return CSimpleHelper.bodyAsIndex(message, type, Integer.toString(key));
    }

    public static <T> T bodyAsIndex(Message message, Class<T> type, String key) {
        Object obj = message.getBody();
        return CSimpleHelper.tryCast(message.getExchange().getContext(), type, key, obj);
    }

    public static <T> T mandatoryBodyAsIndex(Message message, Class<T> type, int key) throws InvalidPayloadException {
        T out = CSimpleHelper.bodyAsIndex(message, type, Integer.toString(key));
        if (out == null) {
            throw new InvalidPayloadException(message.getExchange(), type, message);
        }
        return out;
    }

    public static <T> T mandatoryBodyAsIndex(Message message, Class<T> type, String key) throws InvalidPayloadException {
        T out = CSimpleHelper.bodyAsIndex(message, type, key);
        if (out == null) {
            throw new InvalidPayloadException(message.getExchange(), type, message);
        }
        return out;
    }

    public static Object header(Message message, String name) {
        return message.getHeader(name);
    }

    public static <T> T headerAs(Message message, String name, Class<T> type) {
        return message.getHeader(name, type);
    }

    public static <T> T headerAsIndex(Message message, Class<T> type, String name, String key) {
        Object obj = message.getHeader(name);
        return CSimpleHelper.tryCast(message.getExchange().getContext(), type, key, obj);
    }

    private static <T> T tryCast(CamelContext context, Class<T> type, String key, Object obj) {
        Object objKey = CSimpleHelper.doObjectAsIndex(context, obj, key);
        if (objKey != null && objKey != obj) {
            return type.cast(objKey);
        }
        List<String> keys = OgnlHelper.splitOgnl(key);
        for (String k : keys) {
            if (k.startsWith("[") && k.endsWith("]")) {
                k = StringHelper.between(k, "[", "]");
            }
            obj = CSimpleHelper.doObjectAsIndex(context, obj, k);
        }
        return type.cast(obj);
    }

    public static Object exchangeProperty(Exchange exchange, String name) {
        return exchange.getProperty(name);
    }

    public static <T> T exchangePropertyAs(Exchange exchange, String name, Class<T> type) {
        return exchange.getProperty(name, type);
    }

    public static <T> T exchangePropertyAsIndex(Exchange exchange, Class<T> type, String name, String key) {
        Object obj = exchange.getProperty(name);
        Object objKey = CSimpleHelper.doObjectAsIndex(exchange.getContext(), obj, key);
        if (objKey != null && objKey != obj) {
            return type.cast(objKey);
        }
        List<String> keys = OgnlHelper.splitOgnl(key);
        for (String k : keys) {
            if (k.startsWith("[") && k.endsWith("]")) {
                k = StringHelper.between(k, "[", "]");
            }
            obj = CSimpleHelper.doObjectAsIndex(exchange.getContext(), obj, k);
        }
        return type.cast(obj);
    }

    public static Object variable(Exchange exchange, String name) {
        return exchange.getVariable(name);
    }

    public static <T> T variableAs(Exchange exchange, String name, Class<T> type) {
        return exchange.getVariable(name, type);
    }

    public static <T> T variableAsIndex(Exchange exchange, Class<T> type, String name, String key) {
        Object obj = exchange.getVariable(name);
        Object objKey = CSimpleHelper.doObjectAsIndex(exchange.getContext(), obj, key);
        if (objKey != null && objKey != obj) {
            return type.cast(objKey);
        }
        List<String> keys = OgnlHelper.splitOgnl(key);
        for (String k : keys) {
            if (k.startsWith("[") && k.endsWith("]")) {
                k = StringHelper.between(k, "[", "]");
            }
            obj = CSimpleHelper.doObjectAsIndex(exchange.getContext(), obj, k);
        }
        return type.cast(obj);
    }

    public static Map<String, Object> variables(Exchange exchange) {
        return exchange.getVariables();
    }

    public static String bodyOneLine(Exchange exchange) {
        String body = exchange.getIn().getBody(String.class);
        if (body == null) {
            return null;
        }
        body = body.replace(System.lineSeparator(), "");
        return body;
    }

    public static String prettyBody(Exchange exchange) {
        String body = exchange.getIn().getBody(String.class);
        if (body == null) {
            return null;
        }
        if (body.startsWith("{") && body.endsWith("}") || body.startsWith("[") && body.endsWith("]")) {
            body = Jsoner.prettyPrint(body.trim());
        } else if (body.startsWith("<") && body.endsWith(">")) {
            return CSimpleHelper.prettyXml(body.trim());
        }
        return body;
    }

    private static String prettyXml(String rawXml) {
        try {
            boolean includeDeclaration = rawXml.startsWith("<?xml");
            return XmlPrettyPrinter.pettyPrint(rawXml, 2, includeDeclaration);
        }
        catch (Exception e) {
            return rawXml;
        }
    }

    public static Exception exception(Exchange exchange) {
        return LanguageHelper.exception(exchange);
    }

    public static <T> T exceptionAs(Exchange exchange, Class<T> type) {
        Exception exception = exchange.getException();
        if (exception == null) {
            exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
        }
        if (exception != null) {
            return type.cast(exception);
        }
        return null;
    }

    public static String exceptionMessage(Exchange exchange) {
        return LanguageHelper.exceptionMessage(exchange);
    }

    public static String exceptionStacktrace(Exchange exchange) {
        return LanguageHelper.exceptionStacktrace(exchange);
    }

    public static String threadName() {
        return Thread.currentThread().getName();
    }

    public static long threadId() {
        return Thread.currentThread().getId();
    }

    public static String hostName() {
        return InetAddressUtil.getLocalHostNameSafe();
    }

    public static String fromRouteId(Exchange exchange) {
        return exchange.getFromRouteId();
    }

    public static String routeId(Exchange exchange) {
        return ExchangeHelper.getRouteId(exchange);
    }

    public static String routeGroup(Exchange exchange) {
        return ExchangeHelper.getRouteGroup(exchange);
    }

    public static String stepId(Exchange exchange) {
        return exchange.getProperty(ExchangePropertyKey.STEP_ID, String.class);
    }

    public static String fileName(Message message) {
        return message.getHeader("CamelFileName", String.class);
    }

    public static String fileNameNoExt(Message message) {
        String name = message.getHeader("CamelFileName", String.class);
        return FileUtil.stripExt(name);
    }

    public static String fileNameNoExtSingle(Message message) {
        String name = message.getHeader("CamelFileName", String.class);
        return FileUtil.stripExt(name, true);
    }

    public static String fileNameExt(Message message) {
        String name = message.getHeader("CamelFileName", String.class);
        return FileUtil.onlyExt(name);
    }

    public static String fileNameExtSingle(Message message) {
        String name = message.getHeader("CamelFileName", String.class);
        return FileUtil.onlyExt(name, true);
    }

    public static String fileOnlyName(Message message) {
        String answer = message.getHeader("CamelFileNameOnly", String.class);
        if (answer == null) {
            answer = message.getHeader("CamelFileName", String.class);
            answer = FileUtil.stripPath(answer);
        }
        return answer;
    }

    public static String fileOnlyNameNoExt(Message message) {
        String name = CSimpleHelper.fileOnlyName(message);
        return FileUtil.stripExt(name);
    }

    public static String fileOnlyNameNoExtSingle(Message message) {
        String name = CSimpleHelper.fileOnlyName(message);
        return FileUtil.stripExt(name, true);
    }

    public static String fileParent(Message message) {
        return message.getHeader("CamelFileParent", String.class);
    }

    public static String filePath(Message message) {
        return message.getHeader("CamelFilePath", String.class);
    }

    public static Boolean fileAbsolute(Message message) {
        return message.getHeader("CamelFileAbsolute", Boolean.class);
    }

    public static String fileAbsolutePath(Message message) {
        return message.getHeader("CamelFileAbsolutePath", String.class);
    }

    public static Long fileSize(Message message) {
        return message.getHeader("CamelFileLength", Long.class);
    }

    public static Long fileModified(Message message) {
        return message.getHeader("CamelFileLastModified", Long.class);
    }

    public static Date date(Exchange exchange, String commandWithOffsets) {
        return (Date)CSimpleHelper.doDate(exchange, commandWithOffsets, null, null);
    }

    public static String date(Exchange exchange, String commandWithOffsets, String timezone, String pattern) {
        return (String)CSimpleHelper.doDate(exchange, commandWithOffsets, timezone, pattern);
    }

    private static Object doDate(Exchange exchange, String commandWithOffsets, String timezone, String pattern) {
        String command = commandWithOffsets.split("[+-]", 2)[0].trim();
        List<Long> offsets = LanguageHelper.captureOffsets(commandWithOffsets, OFFSET_PATTERN);
        Date date = CSimpleHelper.evalDate(exchange, command);
        return LanguageHelper.applyDateOffsets(date, offsets, pattern, timezone);
    }

    private static Date evalDate(Exchange exchange, String command) {
        Date date;
        if ("now".equals(command)) {
            date = new Date();
        } else if ("exchangeCreated".equals(command)) {
            date = LanguageHelper.dateFromExchangeCreated(exchange);
        } else if (command.startsWith("header.")) {
            date = LanguageHelper.dateFromHeader(exchange, command, (e, o) -> CSimpleHelper.failDueToMissingObjectAtCommand(command));
        } else if (command.startsWith("exchangeProperty.")) {
            date = LanguageHelper.dateFromExchangeProperty(exchange, command, (e, o) -> CSimpleHelper.failDueToMissingObjectAtCommand(command));
        } else if ("file".equals(command)) {
            date = LanguageHelper.dateFromFileLastModified(exchange, command);
        } else {
            throw new IllegalArgumentException("Command not supported for dateExpression: " + command);
        }
        return date;
    }

    private static Date failDueToMissingObjectAtCommand(String command) {
        throw new IllegalArgumentException("Cannot find Date/long object at command:" + command);
    }

    public static String property(Exchange exchange, String key, String defaultValue) {
        try {
            PropertiesComponent pc = exchange.getContext().getPropertiesComponent();
            return pc.parseUri("{{" + key + "}}");
        }
        catch (Exception e) {
            if (defaultValue != null) {
                return defaultValue;
            }
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    public static Object ref(Exchange exchange, String key) {
        return exchange.getContext().getRegistry().lookupByName(key);
    }

    public static Class<?> type(Exchange exchange, Class<?> type) {
        return type;
    }

    public static Object type(Exchange exchange, Class<?> type, String field) {
        return org.apache.camel.util.ObjectHelper.lookupConstantFieldValue(type, field);
    }

    public static Object bean(Exchange exchange, Language bean, String ref, String method, Object scope) {
        Class<?> type = null;
        if (ref != null && ref.startsWith("type:")) {
            try {
                type = exchange.getContext().getClassResolver().resolveMandatoryClass(ref.substring(5));
                ref = null;
            }
            catch (ClassNotFoundException e) {
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
        Object[] properties = new Object[7];
        properties[3] = type;
        properties[4] = ref;
        properties[2] = method;
        properties[5] = scope;
        Expression exp = bean.createExpression(null, properties);
        exp.init(exchange.getContext());
        return exp.evaluate(exchange, Object.class);
    }

    public static Object increment(Exchange exchange, Object number) {
        Number num = exchange.getContext().getTypeConverter().tryConvertTo(Number.class, exchange, number);
        if (num instanceof Integer) {
            int val = num.intValue();
            return ++val;
        }
        if (num instanceof Long) {
            long val = num.longValue();
            return ++val;
        }
        CamelExchangeException cause = new CamelExchangeException("Cannot evaluate message body as a number", exchange);
        throw RuntimeCamelException.wrapRuntimeCamelException(cause);
    }

    public static Object decrement(Exchange exchange, Object number) {
        Number num = exchange.getContext().getTypeConverter().tryConvertTo(Number.class, exchange, number);
        if (num instanceof Integer) {
            int val = num.intValue();
            return --val;
        }
        if (num instanceof Long) {
            long val = num.longValue();
            return --val;
        }
        CamelExchangeException cause = new CamelExchangeException("Cannot evaluate message body as a number", exchange);
        throw RuntimeCamelException.wrapRuntimeCamelException(cause);
    }

    public static String replace(Exchange exchange, String from, String to) {
        String source = exchange.getMessage().getBody(String.class);
        if (source != null) {
            return source.replace(from, to);
        }
        return null;
    }

    public static Object empty(Exchange exchange, String type) {
        if ("map".equalsIgnoreCase(type)) {
            return new LinkedHashMap();
        }
        if ("string".equalsIgnoreCase(type)) {
            return "";
        }
        if ("list".equalsIgnoreCase(type)) {
            return new ArrayList();
        }
        throw new IllegalArgumentException("function empty(%s) has unknown type".formatted(type));
    }

    public static String substring(Exchange exchange, Object num1, Object num2) {
        int head = exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, num1);
        int tail = exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, num2);
        if (head < 0 && tail == 0) {
            tail = head;
            head = 0;
        }
        head = Math.abs(head);
        tail = Math.abs(tail);
        String text = exchange.getMessage().getBody(String.class);
        if (text == null) {
            return null;
        }
        return StringHelper.between(text, head, tail);
    }

    public static int random(Exchange exchange, Object min, Object max) {
        int num1 = exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, min);
        int num2 = exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, max);
        Random random = new Random();
        return random.nextInt(num2 - num1) + num1;
    }

    public static SkipIterator skip(Exchange exchange, Object skip) {
        int num = exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, skip);
        Iterator<?> it = ObjectHelper.createIterator(exchange.getMessage().getBody());
        return new SkipIterator(it, num);
    }

    public static GroupIterator collate(Exchange exchange, Object group) {
        int num = exchange.getContext().getTypeConverter().tryConvertTo(Integer.TYPE, exchange, group);
        Iterator<?> it = ObjectHelper.createIterator(exchange.getMessage().getBody());
        return new GroupIterator(it, num);
    }

    public static String messageHistory(Exchange exchange, boolean detailed) {
        ExchangeFormatter formatter = CSimpleHelper.getOrCreateExchangeFormatter(exchange.getContext());
        return MessageHelper.dumpMessageHistoryStacktrace(exchange, formatter, detailed);
    }

    public static String sys(String name) {
        return System.getProperty(name);
    }

    public static String sysenv(String name) {
        return LanguageHelper.sysenv(name);
    }

    private static ExchangeFormatter getOrCreateExchangeFormatter(CamelContext camelContext) {
        return LanguageHelper.getOrCreateExchangeFormatter(camelContext, exchangeFormatter);
    }

    public static boolean isEqualTo(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceEquals(exchange.getContext().getTypeConverter(), leftValue, rightValue);
    }

    public static boolean isEqualToIgnoreCase(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceEquals(exchange.getContext().getTypeConverter(), leftValue, rightValue, true);
    }

    public static boolean isNotEqualTo(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceNotEquals(exchange.getContext().getTypeConverter(), leftValue, rightValue);
    }

    public static boolean isGreaterThan(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceCompare(exchange.getContext().getTypeConverter(), leftValue, rightValue) > 0;
    }

    public static boolean isGreaterThanOrEqualTo(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceCompare(exchange.getContext().getTypeConverter(), leftValue, rightValue) >= 0;
    }

    public static boolean isLessThan(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceCompare(exchange.getContext().getTypeConverter(), leftValue, rightValue) < 0;
    }

    public static boolean isLessThanOrEqualTo(Exchange exchange, Object leftValue, Object rightValue) {
        return ObjectHelper.typeCoerceCompare(exchange.getContext().getTypeConverter(), leftValue, rightValue) <= 0;
    }

    public static boolean contains(Exchange exchange, Object leftValue, Object rightValue) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        return ObjectHelper.typeCoerceContains(exchange.getContext().getTypeConverter(), leftValue, rightValue, false);
    }

    public static boolean containsIgnoreCase(Exchange exchange, Object leftValue, Object rightValue) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        return ObjectHelper.typeCoerceContains(exchange.getContext().getTypeConverter(), leftValue, rightValue, true);
    }

    public static boolean regexp(Exchange exchange, Object leftValue, Object rightValue) {
        String text = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, leftValue);
        String pattern = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, rightValue);
        return text.matches(pattern);
    }

    public static boolean in(Exchange exchange, Object leftValue, Object rightValue) {
        Iterator<?> it = ObjectHelper.createIterator(rightValue);
        ArrayList values = new ArrayList();
        while (it.hasNext()) {
            values.add(it.next());
        }
        for (Object value : values) {
            if (!CSimpleHelper.isEqualTo(exchange, leftValue, value)) continue;
            return true;
        }
        return false;
    }

    public static boolean range(Exchange exchange, Object leftValue, Object rightValue) {
        String range = exchange.getContext().getTypeConverter().convertTo(String.class, exchange, rightValue);
        Matcher matcher = RANGE_PATTERN.matcher(range);
        if (matcher.matches()) {
            String from = matcher.group(1);
            String to = matcher.group(3);
            return CSimpleHelper.isGreaterThanOrEqualTo(exchange, leftValue, from) && CSimpleHelper.isLessThanOrEqualTo(exchange, leftValue, to);
        }
        throw new IllegalArgumentException("Range operator is not valid. Valid syntax:'from..to' (where from and to are numbers).");
    }

    public static boolean startsWith(Exchange exchange, Object leftValue, Object rightValue) {
        return LanguageHelper.startsWith(exchange, leftValue, rightValue);
    }

    public static boolean endsWith(Exchange exchange, Object leftValue, Object rightValue) {
        return LanguageHelper.endsWith(exchange, leftValue, rightValue);
    }

    public static boolean is(Exchange exchange, Object leftValue, Class<?> type) {
        return type.isInstance(leftValue);
    }

    private static Object doObjectAsIndex(CamelContext context, Object obj, String key) {
        if (obj != null && obj.getClass().isArray()) {
            int size = Array.getLength(obj);
            Integer num = CSimpleHelper.indexAsNumber(context, key, size);
            if (num != null && num >= 0 && size > 0 && size > num - 1) {
                obj = Array.get(obj, num);
            }
        } else if (obj instanceof List) {
            List list = (List)obj;
            Integer num = CSimpleHelper.indexAsNumber(context, key, list.size());
            if (num != null && num >= 0 && !list.isEmpty() && list.size() > num - 1) {
                obj = list.get(num);
            }
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            obj = map.get(key);
        } else {
            return null;
        }
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Integer indexAsNumber(CamelContext context, String key, int size) {
        if (!key.startsWith("last")) return context.getTypeConverter().tryConvertTo(Integer.class, key);
        Integer num = size - 1;
        String after = StringHelper.after(key, "-");
        if (after == null) return num;
        Integer redux = context.getTypeConverter().tryConvertTo(Integer.class, after.trim());
        if (redux == null) throw new ExpressionIllegalSyntaxException(key);
        return num - redux;
    }

    public static Object join(Exchange exchange, Object value, String separator, String prefix) {
        Iterator it = CSimpleHelper.convertTo(exchange, Iterator.class, value);
        StringBuilder sb = new StringBuilder(256);
        while (it.hasNext()) {
            String s;
            Object o = it.next();
            if (o == null || (s = CSimpleHelper.tryConvertTo(exchange, String.class, o)) == null) continue;
            if (!sb.isEmpty()) {
                sb.append(separator);
            }
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static Object hash(Exchange exchange, Object value, String algorithm) {
        byte[] data = CSimpleHelper.convertTo(exchange, byte[].class, value);
        if (data != null && data.length > 0) {
            try {
                MessageDigest digest = MessageDigest.getInstance(algorithm);
                byte[] bytes = digest.digest(data);
                return StringHelper.bytesToHex(bytes);
            }
            catch (Exception e) {
                throw CamelExecutionException.wrapCamelExecutionException(exchange, e);
            }
        }
        return null;
    }

    public static UuidGenerator customUuidGenerator(Exchange exchange, String generator) {
        return CamelContextHelper.mandatoryLookup(exchange.getContext(), generator, UuidGenerator.class);
    }
}

