/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataformat;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.processor.MarshalProcessor;
import org.apache.camel.support.processor.UnmarshalProcessor;
import org.apache.camel.support.service.ServiceHelper;

@UriEndpoint(firstVersion="2.12.0", scheme="dataformat", title="Data Format", syntax="dataformat:name:operation", remote=false, producerOnly=true, category={Category.CORE, Category.TRANSFORMATION}, lenientProperties=true)
public class DataFormatEndpoint
extends DefaultEndpoint {
    private AsyncProcessor processor;
    private DataFormat dataFormat;
    @UriPath(description="Name of data format")
    @Metadata(required=true)
    private String name;
    @UriPath(enums="marshal,unmarshal")
    @Metadata(required=true)
    private String operation;

    public DataFormatEndpoint() {
    }

    public DataFormatEndpoint(String endpointUri, Component component, DataFormat dataFormat) {
        super(endpointUri, component);
        this.dataFormat = dataFormat;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    @Override
    public Producer createProducer() throws Exception {
        return new DefaultAsyncProducer(this){

            @Override
            public boolean process(Exchange exchange, AsyncCallback callback) {
                return DataFormatEndpoint.this.processor.process(exchange, callback);
            }

            @Override
            public String toString() {
                return "DataFormatProducer[" + String.valueOf(DataFormatEndpoint.this.dataFormat) + "]";
            }
        };
    }

    @Override
    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Cannot consume from data format");
    }

    @Override
    public boolean isLenientProperties() {
        return true;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        if (this.dataFormat == null && this.name != null) {
            this.dataFormat = this.getCamelContext().resolveDataFormat(this.name);
        }
        if (this.operation.equals("marshal")) {
            MarshalProcessor marshal = new MarshalProcessor(this.dataFormat);
            marshal.setCamelContext(this.getCamelContext());
            this.processor = marshal;
        } else {
            UnmarshalProcessor unmarshal = new UnmarshalProcessor(this.dataFormat);
            unmarshal.setCamelContext(this.getCamelContext());
            this.processor = unmarshal;
        }
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.dataFormat, this.processor);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.processor, this.dataFormat);
        super.doStop();
    }
}

