/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dataset;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.dataset.DataSetTestEndpoint;
import org.apache.camel.component.mock.MockComponent;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.util.URISupport;

@Component(value="dataset-test")
public class DataSetTestComponent
extends MockComponent {
    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Long timeout = this.getAndRemoveParameter(parameters, "timeout", Long.class);
        DataSetTestEndpoint answer = new DataSetTestEndpoint(uri, this);
        if (timeout != null) {
            answer.setTimeout(timeout);
        }
        answer.setLog(this.isLog());
        this.setProperties(answer, parameters);
        String endpointUri = URISupport.appendParametersToURI(remaining, parameters);
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint(this.getCamelContext(), endpointUri);
        answer.setExpectedMessageEndpoint(endpoint);
        return answer;
    }
}

