/*
 * Decompiled with CFR 0.152.
 */
package com.datasonnet.plugins;

import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaType;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.plugins.BaseJacksonDataFormatPlugin;
import com.datasonnet.spi.PluginException;
import com.datasonnet.spi.ujsonUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Optional;
import ujson.Null$;
import ujson.Value;

public class DefaultYamlFormatPlugin
extends BaseJacksonDataFormatPlugin {
    private static final ObjectMapper DEFAULT_OBJECT_MAPPER = new ObjectMapper();
    private static final YAMLFactory DEFAULT_YAML_FACTORY = new YAMLFactory();
    public static final String DS_PARAM_MARKER_LINE = "markerline";
    public static final String DS_PARAM_DISABLE_QUOTES = "disablequotes";

    public DefaultYamlFormatPlugin() {
        this.supportedTypes.add(MediaTypes.APPLICATION_YAML);
        this.readerSupportedClasses.add(String.class);
        this.readerSupportedClasses.add(CharSequence.class);
        this.readerSupportedClasses.add(ByteBuffer.class);
        this.readerSupportedClasses.add(byte[].class);
        this.writerSupportedClasses.add(String.class);
        this.writerSupportedClasses.add(CharSequence.class);
        this.writerSupportedClasses.add(ByteBuffer.class);
        this.writerSupportedClasses.add(byte[].class);
        this.readerParams.add(DS_PARAM_MARKER_LINE);
        this.writerParams.addAll(this.readerParams);
        this.writerParams.add(DS_PARAM_DISABLE_QUOTES);
    }

    @Override
    public Value read(Document<?> doc) throws PluginException {
        if (doc.getContent() == null) {
            return Null$.MODULE$;
        }
        try {
            YAMLParser yamlParser = DEFAULT_YAML_FACTORY.createParser((String)doc.getContent());
            List docs = ((MappingIterator)DEFAULT_OBJECT_MAPPER.readValues((JsonParser)yamlParser, (TypeReference)new TypeReference<JsonNode>(){})).readAll();
            if (docs.size() <= 1) {
                return this.ujsonFrom((JsonNode)DEFAULT_OBJECT_MAPPER.valueToTree(docs.get(0)));
            }
            return this.ujsonFrom((JsonNode)DEFAULT_OBJECT_MAPPER.valueToTree(docs));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new PluginException("Failed to read yaml data");
        }
    }

    @Override
    public <T> Document<T> write(Value input, MediaType mediaType, Class<T> targetType) throws PluginException {
        Charset charset = mediaType.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        try {
            Object inputAsJava = ujsonUtils.javaObjectFrom(input);
            ObjectMapper yamlMapper = new ObjectMapper(DEFAULT_YAML_FACTORY);
            StringBuilder value = null;
            if (inputAsJava instanceof List) {
                List listInputAsJava = (List)inputAsJava;
                value = new StringBuilder();
                for (Object obj : listInputAsJava) {
                    value.append(yamlMapper.writeValueAsString(obj));
                }
            } else {
                String paramStr;
                boolean disableMarkerLines;
                String yaml = yamlMapper.writeValueAsString(inputAsJava);
                if (mediaType.getParameters().containsKey(DS_PARAM_MARKER_LINE) && !(disableMarkerLines = Boolean.parseBoolean(Optional.ofNullable(paramStr = mediaType.getParameters().get(DS_PARAM_MARKER_LINE)).orElse("true")))) {
                    yaml = yaml.replaceFirst("---(\\n| )", "");
                }
                value = new StringBuilder(yaml);
            }
            String output = value.toString();
            if (mediaType.getParameters().containsKey(DS_PARAM_DISABLE_QUOTES)) {
                output = output.replaceAll("\"", "");
            }
            if (targetType.isAssignableFrom(String.class)) {
                return new DefaultDocument<String>(output, MediaTypes.APPLICATION_YAML);
            }
            if (targetType.isAssignableFrom(CharSequence.class)) {
                return new DefaultDocument<String>(output, MediaTypes.APPLICATION_YAML);
            }
            if (targetType.isAssignableFrom(ByteBuffer.class)) {
                return new DefaultDocument<ByteBuffer>(ByteBuffer.wrap(output.getBytes(charset)), MediaTypes.APPLICATION_YAML);
            }
            if (targetType.isAssignableFrom(byte[].class)) {
                return new DefaultDocument<byte[]>(output.getBytes(charset), MediaTypes.APPLICATION_YAML);
            }
            throw new PluginException("Unable to parse to target type.");
        }
        catch (JsonProcessingException e) {
            throw new PluginException("Failed to write yaml data");
        }
    }
}

