/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.datasonnet;

import com.datasonnet.document.DefaultDocument;
import com.datasonnet.document.Document;
import com.datasonnet.document.MediaTypes;
import com.datasonnet.header.Header;
import com.datasonnet.jsonnet.Materializer;
import com.datasonnet.jsonnet.Val;
import com.datasonnet.spi.DataFormatService;
import com.datasonnet.spi.Library;
import com.datasonnet.spi.PluginException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;

public final class CML
extends Library {
    private static final CML INSTANCE = new CML();
    private final ThreadLocal<Exchange> exchange = new ThreadLocal();

    private CML() {
    }

    public static CML getInstance() {
        return INSTANCE;
    }

    public ThreadLocal<Exchange> getExchange() {
        return this.exchange;
    }

    @Override
    public String namespace() {
        return "cml";
    }

    @Override
    public Set<String> libsonnets() {
        return Collections.emptySet();
    }

    @Override
    public Map<String, Val.Func> functions(DataFormatService dataFormats, Header header) {
        HashMap<String, Val.Func> answer = new HashMap<String, Val.Func>();
        answer.put("properties", this.makeSimpleFunc(Collections.singletonList("key"), params -> this.properties((Val)params.get(0))));
        answer.put("header", this.makeSimpleFunc(Collections.singletonList("key"), params -> this.header((Val)params.get(0), dataFormats)));
        answer.put("variable", this.makeSimpleFunc(Collections.singletonList("key"), params -> this.variable((Val)params.get(0), dataFormats)));
        answer.put("exchangeProperty", this.makeSimpleFunc(Collections.singletonList("key"), params -> this.exchangeProperty((Val)params.get(0), dataFormats)));
        return answer;
    }

    @Override
    public Map<String, Val.Obj> modules(DataFormatService dataFormats, Header header) {
        return Collections.emptyMap();
    }

    private Val properties(Val key) {
        if (key instanceof Val.Str) {
            return new Val.Str(this.exchange.get().getContext().resolvePropertyPlaceholders("{{" + ((Val.Str)key).value() + "}}"));
        }
        throw new IllegalArgumentException("Expected String got: " + key.prettyName());
    }

    private Val header(Val key, DataFormatService dataformats) {
        if (key instanceof Val.Str) {
            return this.valFrom(this.exchange.get().getMessage().getHeader(((Val.Str)key).value()), dataformats);
        }
        throw new IllegalArgumentException("Expected String got: " + key.prettyName());
    }

    private Val variable(Val key, DataFormatService dataformats) {
        if (key instanceof Val.Str) {
            return this.valFrom(this.exchange.get().getVariable(((Val.Str)key).value()), dataformats);
        }
        throw new IllegalArgumentException("Expected String got: " + key.prettyName());
    }

    private Val exchangeProperty(Val key, DataFormatService dataformats) {
        if (key instanceof Val.Str) {
            return this.valFrom(this.exchange.get().getProperty(((Val.Str)key).value()), dataformats);
        }
        throw new IllegalArgumentException("Expected String got: " + key.prettyName());
    }

    private Val valFrom(Object obj, DataFormatService dataformats) {
        DefaultDocument<Object> doc = obj instanceof Document ? (DefaultDocument<Object>)obj : new DefaultDocument<Object>(obj, MediaTypes.APPLICATION_JAVA);
        try {
            return Materializer.reverse(dataformats.mandatoryRead(doc));
        }
        catch (PluginException e) {
            throw new IllegalStateException(e);
        }
    }
}

