/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spi;

import java.util.function.BiPredicate;
import org.apache.camel.Component;
import org.apache.camel.Ordered;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.ThrowingBiConsumer;
import org.apache.camel.util.function.ThrowingConsumer;

@FunctionalInterface
public interface ComponentCustomizer
extends Ordered {
    public static Builder<Component> builder() {
        return ComponentCustomizer.builder(Component.class);
    }

    public static <T extends Component> Builder<T> builder(Class<T> type) {
        return new Builder<T>(type);
    }

    public static <T extends Component> ComponentCustomizer forType(Class<T> type, ThrowingConsumer<T, Exception> consumer) {
        return ComponentCustomizer.builder(type).build(consumer);
    }

    public void configure(String var1, Component var2);

    default public boolean isEnabled(String name, Component target) {
        return true;
    }

    @Override
    default public int getOrder() {
        return 0;
    }

    public static class Builder<T extends Component> {
        private final Class<T> type;
        private BiPredicate<String, Component> condition;
        private int order;

        public Builder(Class<T> type) {
            this.type = type;
        }

        public Builder<T> withOrder(int order) {
            this.order = order;
            return this;
        }

        public Builder<T> withCondition(BiPredicate<String, Component> condition) {
            this.condition = condition;
            return this;
        }

        public ComponentCustomizer build(final ThrowingConsumer<T, Exception> consumer) {
            return this.build(new ThrowingBiConsumer<String, T, Exception>(){

                @Override
                public void accept(String name, T target) throws Exception {
                    consumer.accept(target);
                }
            });
        }

        public ComponentCustomizer build(final ThrowingBiConsumer<String, T, Exception> consumer) {
            final int order = this.order;
            final BiPredicate<String, Component> condition = this.condition();
            return new ComponentCustomizer(){

                @Override
                public void configure(String name, Component target) {
                    ObjectHelper.notNull(name, "component name");
                    ObjectHelper.notNull(target, "component instance");
                    try {
                        consumer.accept(name, target);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public boolean isEnabled(String name, Component target) {
                    ObjectHelper.notNull(name, "component name");
                    ObjectHelper.notNull(target, "component instance");
                    return condition.test(name, target);
                }

                @Override
                public int getOrder() {
                    return order;
                }
            };
        }

        private BiPredicate<String, Component> condition() {
            if (this.type.equals(Component.class)) {
                return this.condition != null ? this.condition : new BiPredicate<String, Component>(){

                    @Override
                    public boolean test(String s, Component language2) {
                        return true;
                    }
                };
            }
            if (this.condition == null) {
                return new BiPredicate<String, Component>(){

                    @Override
                    public boolean test(String name, Component target) {
                        return type.isAssignableFrom(target.getClass());
                    }
                };
            }
            return new BiPredicate<String, Component>(){

                @Override
                public boolean test(String name, Component target) {
                    return type.isAssignableFrom(target.getClass()) && condition.test(name, target);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface Policy
    extends BiPredicate<String, Component> {
        public static Policy none() {
            return new Policy(){

                @Override
                public boolean test(String s, Component target) {
                    return false;
                }
            };
        }

        public static Policy any() {
            return new Policy(){

                @Override
                public boolean test(String s, Component target) {
                    return true;
                }
            };
        }
    }
}

