/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.ParameterParser;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;

public final class DiskFileItem
implements FileItem<DiskFileItem> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private static final String UID = UUID.randomUUID().toString().replace('-', '_');
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private String fieldName;
    private final String contentType;
    private volatile boolean isFormField;
    private final String fileName;
    private volatile long size = -1L;
    private final int threshold;
    private final Path repository;
    private byte[] cachedContent;
    private DeferredFileOutputStream dfos;
    private final Path tempFile;
    private FileItemHeaders fileItemHeaders;
    private Charset charsetDefault = DEFAULT_CHARSET;

    public static Builder builder() {
        return new Builder();
    }

    public static String checkFileName(String fileName) {
        if (fileName != null) {
            int indexOf0 = fileName.indexOf(0);
            if (indexOf0 != -1) {
                StringBuilder sb = new StringBuilder();
                block3: for (int i = 0; i < fileName.length(); ++i) {
                    char c = fileName.charAt(i);
                    switch (c) {
                        case '\u0000': {
                            sb.append("\\0");
                            continue block3;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                throw new InvalidPathException(fileName, sb.toString(), indexOf0);
            }
            Paths.get(fileName, new String[0]);
        }
        return fileName;
    }

    private static String getUniqueId() {
        int limit = 100000000;
        int current = COUNTER.getAndIncrement();
        String id = Integer.toString(current);
        if (current < 100000000) {
            id = ("00000000" + id).substring(id.length());
        }
        return id;
    }

    private DiskFileItem(String fieldName, String contentType, boolean isFormField, String fileName, int threshold, Path repository, FileItemHeaders fileItemHeaders, Charset defaultCharset) {
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.charsetDefault = defaultCharset;
        this.isFormField = isFormField;
        this.fileName = fileName;
        this.fileItemHeaders = fileItemHeaders;
        this.threshold = threshold;
        this.repository = repository != null ? repository : PathUtils.getTempDirectory();
        this.tempFile = this.repository.resolve(String.format("upload_%s_%s.tmp", UID, DiskFileItem.getUniqueId()));
    }

    @Override
    public DiskFileItem delete() throws IOException {
        this.cachedContent = null;
        Path outputFile = this.getPath();
        if (outputFile != null && !this.isInMemory() && Files.exists(outputFile, new LinkOption[0])) {
            Files.delete(outputFile);
        }
        return this;
    }

    @Override
    public byte[] get() throws IOException {
        if (this.isInMemory()) {
            if (this.cachedContent == null && this.dfos != null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent != null ? (byte[])this.cachedContent.clone() : new byte[]{};
        }
        return Files.readAllBytes(this.dfos.getFile().toPath());
    }

    public Charset getCharset() {
        ParameterParser parser = new ParameterParser();
        parser.setLowerCaseNames(true);
        Map<String, String> params = parser.parse(this.getContentType(), ';');
        return Charsets.toCharset(params.get("charset"), this.charsetDefault);
    }

    public Charset getCharsetDefault() {
        return this.charsetDefault;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.fileItemHeaders;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return Files.newInputStream(this.dfos.getFile().toPath(), new OpenOption[0]);
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    @Override
    public String getName() {
        return DiskFileItem.checkFileName(this.fileName);
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.dfos == null) {
            this.dfos = DeferredFileOutputStream.builder().setThreshold(this.threshold).setOutputFile(this.getTempFile().toFile()).get();
        }
        return this.dfos;
    }

    public Path getPath() {
        if (this.dfos == null) {
            return null;
        }
        if (this.isInMemory()) {
            return null;
        }
        return this.dfos.getFile().toPath();
    }

    @Override
    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        return this.dfos != null ? this.dfos.getByteCount() : 0L;
    }

    @Override
    public String getString() throws IOException {
        return new String(this.get(), this.getCharset());
    }

    @Override
    public String getString(Charset charset) throws IOException {
        return new String(this.get(), Charsets.toCharset(charset, this.charsetDefault));
    }

    protected Path getTempFile() {
        return this.tempFile;
    }

    @Override
    public boolean isFormField() {
        return this.isFormField;
    }

    @Override
    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    public DiskFileItem setCharsetDefault(Charset charset) {
        this.charsetDefault = charset;
        return this;
    }

    @Override
    public DiskFileItem setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Override
    public DiskFileItem setFormField(boolean state) {
        this.isFormField = state;
        return this;
    }

    @Override
    public DiskFileItem setHeaders(FileItemHeaders headers) {
        this.fileItemHeaders = headers;
        return this;
    }

    public String toString() {
        return String.format("name=%s, StoreLocation=%s, size=%s bytes, isFormField=%s, FieldName=%s", this.getName(), this.getPath(), this.getSize(), this.isFormField(), this.getFieldName());
    }

    @Override
    public DiskFileItem write(Path file) throws IOException {
        block10: {
            if (this.isInMemory()) {
                try (OutputStream fout = Files.newOutputStream(file, new OpenOption[0]);){
                    fout.write(this.get());
                    break block10;
                }
                catch (IOException e) {
                    throw new IOException("Unexpected output data", e);
                }
            }
            Path outputFile = this.getPath();
            if (outputFile == null) {
                throw new FileUploadException("Cannot write uploaded file to disk.");
            }
            this.size = Files.size(outputFile);
            Files.move(outputFile, file, StandardCopyOption.REPLACE_EXISTING);
        }
        return this;
    }

    public static class Builder
    extends FileItemFactory.AbstractFileItemBuilder<DiskFileItem, Builder> {
        public Builder() {
            this.setBufferSize(10240);
            this.setPath(PathUtils.getTempDirectory());
            this.setCharset(DEFAULT_CHARSET);
            this.setCharsetDefault(DEFAULT_CHARSET);
        }

        @Override
        public DiskFileItem get() {
            DiskFileItem diskFileItem = new DiskFileItem(this.getFieldName(), this.getContentType(), this.isFormField(), this.getFileName(), this.getBufferSize(), this.getPath(), this.getFileItemHeaders(), this.getCharset());
            FileCleaningTracker tracker = this.getFileCleaningTracker();
            if (tracker != null) {
                tracker.track(diskFileItem.getTempFile().toFile(), (Object)diskFileItem);
            }
            return diskFileItem;
        }
    }
}

