/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload2.core;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload2.core.DiskFileItem;
import org.apache.commons.fileupload2.core.FileItemHeaders;
import org.apache.commons.fileupload2.core.FileItemInput;
import org.apache.commons.fileupload2.core.FileItemInputIteratorImpl;
import org.apache.commons.fileupload2.core.FileUploadByteCountLimitException;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.core.MultipartInput;
import org.apache.commons.io.input.BoundedInputStream;

class FileItemInputImpl
implements FileItemInput {
    private final FileItemInputIteratorImpl fileItemInputIteratorImpl;
    private final String contentType;
    private final String fieldName;
    private final String fileName;
    private final boolean formField;
    private final InputStream inputStream;
    private boolean inputStreamClosed;
    private FileItemHeaders headers;

    FileItemInputImpl(FileItemInputIteratorImpl fileItemIterator, String fileName, String fieldName, String contentType, boolean formField, long contentLength) throws FileUploadException, IOException {
        MultipartInput.ItemInputStream itemInputStream;
        this.fileItemInputIteratorImpl = fileItemIterator;
        this.fileName = fileName;
        this.fieldName = fieldName;
        this.contentType = contentType;
        this.formField = formField;
        long fileSizeMax = this.fileItemInputIteratorImpl.getFileSizeMax();
        if (fileSizeMax != -1L && contentLength != -1L && contentLength > fileSizeMax) {
            throw new FileUploadByteCountLimitException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", fieldName, fileSizeMax), contentLength, fileSizeMax, fileName, fieldName);
        }
        InputStream istream = itemInputStream = this.fileItemInputIteratorImpl.getMultiPartInput().newInputStream();
        if (fileSizeMax != -1L) {
            istream = ((BoundedInputStream.Builder)((BoundedInputStream.Builder)((BoundedInputStream.Builder)BoundedInputStream.builder().setInputStream(istream)).setMaxCount(fileSizeMax + 1L)).setOnMaxCount((max, count) -> {
                itemInputStream.close(true);
                throw new FileUploadByteCountLimitException(String.format("The field %s exceeds its maximum permitted size of %s bytes.", fieldName, fileSizeMax), (long)count, fileSizeMax, fileName, fieldName);
            })).get();
        }
        this.inputStream = istream;
    }

    public void close() throws IOException {
        this.inputStream.close();
        this.inputStreamClosed = true;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public FileItemHeaders getHeaders() {
        return this.headers;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.inputStreamClosed) {
            throw new FileItemInput.ItemSkippedException("getInputStream()");
        }
        return this.inputStream;
    }

    @Override
    public String getName() {
        return DiskFileItem.checkFileName(this.fileName);
    }

    @Override
    public boolean isFormField() {
        return this.formField;
    }

    @Override
    public FileItemInputImpl setHeaders(FileItemHeaders headers) {
        this.headers = headers;
        return this;
    }
}

