/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.datasonnet;

import com.datasonnet.document.MediaType;
import java.lang.annotation.Annotation;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.language.datasonnet.Datasonnet;
import org.apache.camel.language.datasonnet.DatasonnetExpression;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.support.language.DefaultAnnotationExpressionFactory;
import org.apache.camel.support.language.LanguageAnnotation;

public class DatasonnetAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    @Override
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class<?> expressionReturnType) {
        String ds = this.getExpressionFromAnnotation(annotation);
        DatasonnetExpression answer = new DatasonnetExpression(ds);
        Class<?> resultType = this.getResultType(annotation);
        if (resultType.equals(Object.class)) {
            resultType = expressionReturnType;
        }
        String source = this.getSource(annotation);
        answer.setSource(ExpressionBuilder.singleInputExpression(source));
        if (annotation instanceof Datasonnet) {
            Datasonnet ann = (Datasonnet)annotation;
            if (!ann.bodyMediaType().isEmpty()) {
                answer.setBodyMediaType(MediaType.valueOf(ann.bodyMediaType()));
            }
            if (!ann.outputMediaType().isEmpty()) {
                answer.setOutputMediaType(MediaType.valueOf(ann.outputMediaType()));
            }
        }
        return ExpressionBuilder.convertToExpression((Expression)answer, resultType);
    }

    protected Class<?> getResultType(Annotation annotation) {
        return (Class)this.getAnnotationObjectValue(annotation, "resultType");
    }

    protected String getSource(Annotation annotation) {
        String answer = null;
        try {
            answer = (String)this.getAnnotationObjectValue(annotation, "source");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (answer != null && answer.isBlank()) {
            return null;
        }
        return answer;
    }
}

