/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.transform;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.InputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.jackson.SchemaHelper;
import org.apache.camel.component.jackson.SchemaResolver;
import org.apache.camel.component.jackson.SchemaType;
import org.apache.camel.component.jackson.transform.Json;
import org.apache.camel.component.jackson.transform.JsonFormatSchema;
import org.apache.camel.spi.Resource;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.util.ObjectHelper;

public class JsonSchemaResolver
implements SchemaResolver,
Processor {
    private final ConcurrentMap<String, JsonNode> schemes = new ConcurrentHashMap<String, JsonNode>();
    private JsonNode schema;
    private String contentClass;

    public String getSchema() {
        if (this.schema != null) {
            try {
                return Json.mapper().writeValueAsString(this.schema);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public void setSchema(String schema) {
        if (ObjectHelper.isNotEmpty(schema)) {
            try {
                this.schema = Json.mapper().readTree(schema);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.schema = null;
        }
    }

    public String getContentClass() {
        return this.contentClass;
    }

    public void setContentClass(String contentClass) {
        this.contentClass = ObjectHelper.isNotEmpty(contentClass) ? contentClass : null;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        Object payload = exchange.getMessage().getBody();
        if (payload == null) {
            return;
        }
        JsonNode answer = this.computeIfAbsent(exchange);
        if (answer != null) {
            exchange.setProperty("X-Content-Schema", (Object)answer);
            exchange.setProperty("X-Content-Schema-Type", (Object)SchemaType.JSON.type());
            exchange.setProperty("X-Content-Class", (Object)SchemaHelper.resolveContentClass(exchange, this.contentClass));
        }
    }

    private JsonNode computeIfAbsent(Exchange exchange) {
        String contentClass;
        if (this.schema != null) {
            return this.schema;
        }
        JsonNode answer = exchange.getProperty("X-Content-Schema", JsonNode.class);
        if (answer == null && exchange.getProperties().containsKey("schema")) {
            answer = JsonSchemaResolver.tryLoadingSchema(exchange);
        }
        if (answer == null && (contentClass = SchemaHelper.resolveContentClass(exchange, this.contentClass)) != null) {
            answer = this.schemes.computeIfAbsent(contentClass, JsonSchemaResolver.tryLoadingSchemaFromResourceLoader(exchange));
        }
        if (answer != null) {
            this.schema = answer;
        }
        return answer;
    }

    private static Function<String, JsonNode> tryLoadingSchemaFromResourceLoader(Exchange exchange) {
        return t -> {
            Resource res = PluginHelper.getResourceLoader(exchange.getContext()).resolveResource("classpath:schemas/" + SchemaType.JSON.type() + "/" + t + "." + SchemaType.JSON.type());
            try {
                if (!res.exists()) return null;
                try (InputStream is = res.getInputStream();){
                    if (is == null) return null;
                    JsonNode jsonNode = Json.mapper().readTree(is);
                    return jsonNode;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load Json schema for type: " + t + ", resource: " + res.getLocation(), e);
            }
        };
    }

    private static JsonNode tryLoadingSchema(Exchange exchange) {
        JsonNode answer;
        String schemaJson = exchange.getProperty("schema", String.class);
        try {
            answer = Json.mapper().readTree(schemaJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to load Json schema", e);
        }
        return answer;
    }

    @Override
    public FormatSchema resolve(Exchange exchange) {
        JsonNode answer = exchange.getProperty("X-Content-Schema", JsonNode.class);
        if (answer == null) {
            answer = this.computeIfAbsent(exchange);
        }
        return new JsonFormatSchema(answer);
    }
}

