/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.concurrent.ExecutorService;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.ProcessClause;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="recipientList")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RecipientListDefinition<Type extends ProcessorDefinition<Type>>
extends ExpressionNode
implements ExecutorServiceAwareDefinition<RecipientListDefinition<Type>> {
    @XmlTransient
    private ExecutorService executorServiceBean;
    @XmlTransient
    private AggregationStrategy aggregationStrategyBean;
    @XmlTransient
    private Processor onPrepareProcessor;
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String delimiter;
    @XmlAttribute
    @Metadata(javaType="org.apache.camel.AggregationStrategy")
    private String aggregationStrategy;
    @XmlAttribute
    @Metadata(label="advanced")
    private String aggregationStrategyMethodName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String aggregationStrategyMethodAllowNull;
    @Deprecated(since="4.7.0")
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String parallelAggregate;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String parallelProcessing;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String synchronous;
    @XmlAttribute
    @Metadata(javaType="java.time.Duration", defaultValue="0")
    private String timeout;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ExecutorService")
    private String executorService;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String stopOnException;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String ignoreInvalidEndpoints;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String streaming;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.Processor")
    private String onPrepare;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Integer")
    private String cacheSize;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String shareUnitOfWork;

    public RecipientListDefinition() {
    }

    public RecipientListDefinition(RecipientListDefinition source2) {
        super(source2);
        this.executorServiceBean = source2.executorServiceBean;
        this.aggregationStrategyBean = source2.aggregationStrategyBean;
        this.onPrepareProcessor = source2.onPrepareProcessor;
        this.delimiter = source2.delimiter;
        this.aggregationStrategy = source2.aggregationStrategy;
        this.aggregationStrategyMethodName = source2.aggregationStrategyMethodName;
        this.aggregationStrategyMethodAllowNull = source2.aggregationStrategyMethodAllowNull;
        this.parallelAggregate = source2.parallelAggregate;
        this.parallelProcessing = source2.parallelProcessing;
        this.synchronous = source2.synchronous;
        this.timeout = source2.timeout;
        this.executorService = source2.executorService;
        this.stopOnException = source2.stopOnException;
        this.ignoreInvalidEndpoints = source2.ignoreInvalidEndpoints;
        this.streaming = source2.streaming;
        this.onPrepare = source2.onPrepare;
        this.cacheSize = source2.cacheSize;
        this.shareUnitOfWork = source2.shareUnitOfWork;
    }

    public RecipientListDefinition(ExpressionDefinition expression) {
        super(expression);
    }

    public RecipientListDefinition(Expression expression) {
        super(expression);
    }

    @Override
    public RecipientListDefinition copyDefinition() {
        return new RecipientListDefinition<Type>(this);
    }

    public String toString() {
        return "RecipientList[" + String.valueOf(this.getExpression()) + "]";
    }

    @Override
    public String getShortName() {
        return "recipientList";
    }

    @Override
    public String getLabel() {
        return "recipientList[" + String.valueOf(this.getExpression()) + "]";
    }

    public Type end() {
        return (Type)super.end();
    }

    public RecipientListDefinition<Type> delimiter(String delimiter) {
        this.setDelimiter(delimiter);
        return this;
    }

    public RecipientListDefinition<Type> aggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public RecipientListDefinition<Type> aggregationStrategy(String aggregationStrategy) {
        this.setAggregationStrategy(aggregationStrategy);
        return this;
    }

    public RecipientListDefinition<Type> aggregationStrategyMethodName(String methodName) {
        this.setAggregationStrategyMethodName(methodName);
        return this;
    }

    public RecipientListDefinition<Type> aggregationStrategyMethodAllowNull() {
        this.setAggregationStrategyMethodAllowNull(Boolean.toString(true));
        return this;
    }

    public RecipientListDefinition<Type> ignoreInvalidEndpoints() {
        this.setIgnoreInvalidEndpoints(Boolean.toString(true));
        return this;
    }

    public RecipientListDefinition<Type> parallelProcessing() {
        this.setParallelProcessing(Boolean.toString(true));
        return this;
    }

    public RecipientListDefinition<Type> parallelProcessing(String parallelProcessing) {
        this.setParallelProcessing(parallelProcessing);
        return this;
    }

    public RecipientListDefinition<Type> parallelProcessing(boolean parallelProcessing) {
        return this.parallelProcessing(Boolean.toString(parallelProcessing));
    }

    @Deprecated(since="4.7.0")
    public RecipientListDefinition<Type> parallelAggregate() {
        return this.parallelAggregate(Boolean.toString(true));
    }

    @Deprecated(since="4.7.0")
    public RecipientListDefinition<Type> parallelAggregate(boolean parallelAggregate) {
        this.setParallelAggregate(Boolean.toString(parallelAggregate));
        return this;
    }

    @Deprecated(since="4.7.0")
    public RecipientListDefinition<Type> parallelAggregate(String parallelAggregate) {
        this.setParallelAggregate(parallelAggregate);
        return this;
    }

    public RecipientListDefinition<Type> synchronous() {
        return this.synchronous(true);
    }

    public RecipientListDefinition<Type> synchronous(boolean synchronous) {
        return this.synchronous(Boolean.toString(synchronous));
    }

    public RecipientListDefinition<Type> synchronous(String synchronous) {
        this.setSynchronous(synchronous);
        return this;
    }

    public RecipientListDefinition<Type> streaming() {
        this.setStreaming(Boolean.toString(true));
        return this;
    }

    public RecipientListDefinition<Type> stopOnException() {
        this.setStopOnException(Boolean.toString(true));
        return this;
    }

    @Override
    public RecipientListDefinition<Type> executorService(ExecutorService executorService) {
        this.executorServiceBean = executorService;
        return this;
    }

    @Override
    public RecipientListDefinition<Type> executorService(String executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public RecipientListDefinition<Type> onPrepare(Processor onPrepare) {
        this.setOnPrepareProcessor(onPrepare);
        return this;
    }

    public ProcessClause<RecipientListDefinition<Type>> onPrepare() {
        ProcessClause<RecipientListDefinition<Type>> clause = new ProcessClause<RecipientListDefinition<Type>>(this);
        this.setOnPrepareProcessor(clause);
        return clause;
    }

    public RecipientListDefinition<Type> onPrepare(String ref) {
        this.setOnPrepare(ref);
        return this;
    }

    public RecipientListDefinition<Type> timeout(long timeout2) {
        this.setTimeout(Long.toString(timeout2));
        return this;
    }

    public RecipientListDefinition<Type> shareUnitOfWork() {
        this.setShareUnitOfWork(Boolean.toString(true));
        return this;
    }

    public RecipientListDefinition<Type> cacheSize(int cacheSize) {
        this.setCacheSize(Integer.toString(cacheSize));
        return this;
    }

    public RecipientListDefinition<Type> cacheSize(String cacheSize) {
        this.setCacheSize(cacheSize);
        return this;
    }

    public AggregationStrategy getAggregationStrategyBean() {
        return this.aggregationStrategyBean;
    }

    @Override
    public ExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorService;
    }

    @Override
    public void setExpression(ExpressionDefinition expression) {
        super.setExpression(expression);
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getParallelProcessing() {
        return this.parallelProcessing;
    }

    public void setParallelProcessing(String parallelProcessing) {
        this.parallelProcessing = parallelProcessing;
    }

    public String getSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(String synchronous) {
        this.synchronous = synchronous;
    }

    public String getIgnoreInvalidEndpoints() {
        return this.ignoreInvalidEndpoints;
    }

    public void setIgnoreInvalidEndpoints(String ignoreInvalidEndpoints) {
        this.ignoreInvalidEndpoints = ignoreInvalidEndpoints;
    }

    public String getStopOnException() {
        return this.stopOnException;
    }

    public void setStopOnException(String stopOnException) {
        this.stopOnException = stopOnException;
    }

    public String getAggregationStrategy() {
        return this.aggregationStrategy;
    }

    public void setAggregationStrategy(String aggregationStrategy) {
        this.aggregationStrategy = aggregationStrategy;
    }

    public void setAggregationStrategy(AggregationStrategy aggregationStrategy) {
        this.aggregationStrategyBean = aggregationStrategy;
    }

    public String getAggregationStrategyMethodName() {
        return this.aggregationStrategyMethodName;
    }

    public void setAggregationStrategyMethodName(String aggregationStrategyMethodName) {
        this.aggregationStrategyMethodName = aggregationStrategyMethodName;
    }

    public String getAggregationStrategyMethodAllowNull() {
        return this.aggregationStrategyMethodAllowNull;
    }

    public void setAggregationStrategyMethodAllowNull(String aggregationStrategyMethodAllowNull) {
        this.aggregationStrategyMethodAllowNull = aggregationStrategyMethodAllowNull;
    }

    public String getStreaming() {
        return this.streaming;
    }

    public void setStreaming(String streaming) {
        this.streaming = streaming;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout2) {
        this.timeout = timeout2;
    }

    public String getOnPrepare() {
        return this.onPrepare;
    }

    public void setOnPrepare(String onPrepare) {
        this.onPrepare = onPrepare;
    }

    public Processor getOnPrepareProcessor() {
        return this.onPrepareProcessor;
    }

    public void setOnPrepareProcessor(Processor onPrepareProcessor) {
        this.onPrepareProcessor = onPrepareProcessor;
    }

    public String getShareUnitOfWork() {
        return this.shareUnitOfWork;
    }

    public void setShareUnitOfWork(String shareUnitOfWork) {
        this.shareUnitOfWork = shareUnitOfWork;
    }

    public String getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(String cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Deprecated(since="4.7.0")
    public String getParallelAggregate() {
        return this.parallelAggregate;
    }

    @Deprecated(since="4.7.0")
    public void setParallelAggregate(String parallelAggregate) {
        this.parallelAggregate = parallelAggregate;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.executorService = executorService;
    }
}

