/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.model.ExecutorServiceAwareDefinition;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;

@Metadata(label="eip,routing")
@XmlRootElement(name="threads")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThreadsDefinition
extends NoOutputDefinition<ThreadsDefinition>
implements ExecutorServiceAwareDefinition<ThreadsDefinition> {
    @XmlTransient
    private ExecutorService executorServiceBean;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.ExecutorService")
    private String executorService;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String poolSize;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String maxPoolSize;
    @XmlAttribute
    @Metadata(javaType="java.lang.Long")
    private String keepAliveTime;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.util.concurrent.TimeUnit", enums="NANOSECONDS,MICROSECONDS,MILLISECONDS,SECONDS,MINUTES,HOURS,DAYS")
    private String timeUnit;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer")
    private String maxQueueSize;
    @XmlAttribute
    @Metadata(label="advanced", javaType="java.lang.Boolean")
    private String allowCoreThreadTimeOut;
    @XmlAttribute
    @Metadata(defaultValue="Threads")
    private String threadName;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy", enums="Abort,CallerRuns")
    private String rejectedPolicy;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="true")
    private String callerRunsWhenRejected;

    public ThreadsDefinition() {
        this.threadName = "Threads";
    }

    protected ThreadsDefinition(ThreadsDefinition source2) {
        super(source2);
        this.executorServiceBean = source2.executorServiceBean;
        this.executorService = source2.executorService;
        this.poolSize = source2.poolSize;
        this.maxPoolSize = source2.maxPoolSize;
        this.keepAliveTime = source2.keepAliveTime;
        this.timeUnit = source2.timeUnit;
        this.maxQueueSize = source2.maxQueueSize;
        this.allowCoreThreadTimeOut = source2.allowCoreThreadTimeOut;
        this.threadName = source2.threadName;
        this.rejectedPolicy = source2.rejectedPolicy;
        this.callerRunsWhenRejected = source2.callerRunsWhenRejected;
    }

    @Override
    public ThreadsDefinition copyDefinition() {
        return new ThreadsDefinition(this);
    }

    @Override
    public String getShortName() {
        return "threads";
    }

    @Override
    public String getLabel() {
        return "threads";
    }

    public String toString() {
        return "Threads[" + String.valueOf(this.getOutputs()) + "]";
    }

    @Override
    public ThreadsDefinition executorService(ExecutorService executorService) {
        this.executorServiceBean = executorService;
        return this;
    }

    @Override
    public ThreadsDefinition executorService(String executorService) {
        this.setExecutorService(executorService);
        return this;
    }

    public ThreadsDefinition poolSize(int poolSize) {
        return this.poolSize(Integer.toString(poolSize));
    }

    public ThreadsDefinition poolSize(String poolSize) {
        this.setPoolSize(poolSize);
        return this;
    }

    public ThreadsDefinition maxPoolSize(int maxPoolSize) {
        return this.maxPoolSize(Integer.toString(maxPoolSize));
    }

    public ThreadsDefinition maxPoolSize(String maxPoolSize) {
        this.setMaxPoolSize(maxPoolSize);
        return this;
    }

    public ThreadsDefinition keepAliveTime(long keepAliveTime) {
        return this.keepAliveTime(Long.toString(keepAliveTime));
    }

    public ThreadsDefinition keepAliveTime(String keepAliveTime) {
        this.setKeepAliveTime(keepAliveTime);
        return this;
    }

    public ThreadsDefinition timeUnit(TimeUnit keepAliveTimeUnits) {
        return this.timeUnit(keepAliveTimeUnits.name());
    }

    public ThreadsDefinition timeUnit(String keepAliveTimeUnits) {
        this.setTimeUnit(keepAliveTimeUnits);
        return this;
    }

    public ThreadsDefinition maxQueueSize(int maxQueueSize) {
        return this.maxQueueSize(Integer.toString(maxQueueSize));
    }

    public ThreadsDefinition maxQueueSize(String maxQueueSize) {
        this.setMaxQueueSize(maxQueueSize);
        return this;
    }

    public ThreadsDefinition rejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        return this.rejectedPolicy(rejectedPolicy.name());
    }

    public ThreadsDefinition rejectedPolicy(String rejectedPolicy) {
        this.setRejectedPolicy(rejectedPolicy);
        return this;
    }

    public ThreadsDefinition threadName(String threadName) {
        this.setThreadName(threadName);
        return this;
    }

    public ThreadsDefinition callerRunsWhenRejected(boolean callerRunsWhenRejected) {
        return this.callerRunsWhenRejected(Boolean.toString(callerRunsWhenRejected));
    }

    public ThreadsDefinition callerRunsWhenRejected(String callerRunsWhenRejected) {
        this.setCallerRunsWhenRejected(callerRunsWhenRejected);
        return this;
    }

    public ThreadsDefinition allowCoreThreadTimeOut(boolean allowCoreThreadTimeOut) {
        return this.allowCoreThreadTimeOut(Boolean.toString(allowCoreThreadTimeOut));
    }

    public ThreadsDefinition allowCoreThreadTimeOut(String allowCoreThreadTimeOut) {
        this.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
        return this;
    }

    @Override
    public ExecutorService getExecutorServiceBean() {
        return this.executorServiceBean;
    }

    @Override
    public String getExecutorServiceRef() {
        return this.executorService;
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public void setKeepAliveTime(String keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setMaxQueueSize(String maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public String getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public void setRejectedPolicy(String rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }

    public String getCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(String callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    public String getAllowCoreThreadTimeOut() {
        return this.allowCoreThreadTimeOut;
    }

    public void setAllowCoreThreadTimeOut(String allowCoreThreadTimeOut) {
        this.allowCoreThreadTimeOut = allowCoreThreadTimeOut;
    }

    public String getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(String executorService) {
        this.executorService = executorService;
    }
}

