/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.cloud;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.PropertyDefinition;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;

@XmlType(name="serviceCallConfiguration")
@XmlAccessorType(value=XmlAccessType.FIELD)
@Configurer
@Deprecated(since="3.19.0")
public abstract class ServiceCallConfiguration
extends IdentifiedType {
    @XmlElement(name="properties")
    @Metadata(label="advanced")
    protected List<PropertyDefinition> properties;

    public List<PropertyDefinition> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyDefinition> properties) {
        this.properties = properties;
    }

    public ServiceCallConfiguration property(String key, String value) {
        if (this.properties == null) {
            this.properties = new ArrayList<PropertyDefinition>();
        }
        PropertyDefinition prop = new PropertyDefinition();
        prop.setKey(key);
        prop.setValue(value);
        this.properties.add(prop);
        return this;
    }

    protected Map<String, String> getPropertiesAsMap(CamelContext camelContext) throws Exception {
        Map<String, String> answer;
        if (this.properties == null || this.properties.isEmpty()) {
            answer = Collections.emptyMap();
        } else {
            answer = new HashMap<String, String>();
            for (PropertyDefinition prop : this.properties) {
                String key = CamelContextHelper.parseText(camelContext, prop.getKey());
                String value = CamelContextHelper.parseText(camelContext, prop.getValue());
                answer.put(key, value);
            }
        }
        return answer;
    }

    protected Map<String, Object> getConfiguredOptions(CamelContext context, Object target) {
        HashMap<String, Object> answer = new HashMap<String, Object>();
        PropertyConfigurer configurer = PluginHelper.getConfigurerResolver(context).resolvePropertyConfigurer(target.getClass().getName(), context);
        if (configurer instanceof ExtendedPropertyConfigurerGetter) {
            ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)((Object)configurer);
            Set<String> all = getter.getAllOptions(target).keySet();
            for (String name : all) {
                Object value = getter.getOptionValue(target, name, true);
                if (value == null) continue;
                String key = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                answer.put(key, value);
            }
        } else {
            PluginHelper.getBeanIntrospection(context).getProperties(target, answer, null, false);
        }
        return answer;
    }

    protected void postProcessFactoryParameters(CamelContext camelContext, Map<String, Object> parameters) throws Exception {
    }
}

