/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.camel.builder.DataFormatBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.3.0", label="dataformat,transformation,security", title="Crypto (Java Cryptographic Extension)")
@XmlRootElement(name="crypto")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CryptoDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String algorithm;
    @XmlAttribute
    private String keyRef;
    @XmlAttribute
    @Metadata(label="advanced")
    private String cryptoProvider;
    @XmlAttribute
    @Metadata(label="advanced")
    private String initVectorRef;
    @XmlAttribute
    @Metadata(label="advanced")
    private String algorithmParameterRef;
    @XmlAttribute
    @Metadata(javaType="java.lang.Integer", defaultValue="4096")
    private String bufferSize;
    @XmlAttribute
    @Metadata(defaultValue="HmacSHA1")
    private String macAlgorithm = "HmacSHA1";
    @XmlAttribute
    @Metadata(defaultValue="true", javaType="java.lang.Boolean")
    private String shouldAppendHMAC;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="false", javaType="java.lang.Boolean")
    private String inline;

    public CryptoDataFormat() {
        super("crypto");
    }

    protected CryptoDataFormat(CryptoDataFormat source2) {
        super(source2);
        this.algorithm = source2.algorithm;
        this.keyRef = source2.keyRef;
        this.cryptoProvider = source2.cryptoProvider;
        this.initVectorRef = source2.initVectorRef;
        this.algorithmParameterRef = source2.algorithmParameterRef;
        this.bufferSize = source2.bufferSize;
        this.macAlgorithm = source2.macAlgorithm;
        this.shouldAppendHMAC = source2.shouldAppendHMAC;
        this.inline = source2.inline;
    }

    private CryptoDataFormat(Builder builder) {
        this();
        this.algorithm = builder.algorithm;
        this.keyRef = builder.keyRef;
        this.cryptoProvider = builder.cryptoProvider;
        this.initVectorRef = builder.initVectorRef;
        this.algorithmParameterRef = builder.algorithmParameterRef;
        this.bufferSize = builder.bufferSize;
        this.macAlgorithm = builder.macAlgorithm;
        this.shouldAppendHMAC = builder.shouldAppendHMAC;
        this.inline = builder.inline;
    }

    @Override
    public CryptoDataFormat copyDefinition() {
        return new CryptoDataFormat(this);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getCryptoProvider() {
        return this.cryptoProvider;
    }

    public void setCryptoProvider(String cryptoProvider) {
        this.cryptoProvider = cryptoProvider;
    }

    public String getKeyRef() {
        return this.keyRef;
    }

    public void setKeyRef(String keyRef) {
        this.keyRef = keyRef;
    }

    public String getInitVectorRef() {
        return this.initVectorRef;
    }

    public void setInitVectorRef(String initVectorRef) {
        this.initVectorRef = initVectorRef;
    }

    public String getAlgorithmParameterRef() {
        return this.algorithmParameterRef;
    }

    public void setAlgorithmParameterRef(String algorithmParameterRef) {
        this.algorithmParameterRef = algorithmParameterRef;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public void setMacAlgorithm(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
    }

    public String getShouldAppendHMAC() {
        return this.shouldAppendHMAC;
    }

    public void setShouldAppendHMAC(String shouldAppendHMAC) {
        this.shouldAppendHMAC = shouldAppendHMAC;
    }

    public String getInline() {
        return this.inline;
    }

    public void setInline(String inline) {
        this.inline = inline;
    }

    @XmlTransient
    public static class Builder
    implements DataFormatBuilder<CryptoDataFormat> {
        private String algorithm;
        private String keyRef;
        private String cryptoProvider;
        private String initVectorRef;
        private String algorithmParameterRef;
        private String bufferSize;
        private String macAlgorithm = "HmacSHA1";
        private String shouldAppendHMAC;
        private String inline;

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder cryptoProvider(String cryptoProvider) {
            this.cryptoProvider = cryptoProvider;
            return this;
        }

        public Builder keyRef(String keyRef) {
            this.keyRef = keyRef;
            return this;
        }

        public Builder initVectorRef(String initVectorRef) {
            this.initVectorRef = initVectorRef;
            return this;
        }

        public Builder algorithmParameterRef(String algorithmParameterRef) {
            this.algorithmParameterRef = algorithmParameterRef;
            return this;
        }

        public Builder bufferSize(String bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = Integer.toString(bufferSize);
            return this;
        }

        public Builder macAlgorithm(String macAlgorithm) {
            this.macAlgorithm = macAlgorithm;
            return this;
        }

        public Builder shouldAppendHMAC(String shouldAppendHMAC) {
            this.shouldAppendHMAC = shouldAppendHMAC;
            return this;
        }

        public Builder shouldAppendHMAC(boolean shouldAppendHMAC) {
            this.shouldAppendHMAC = Boolean.toString(shouldAppendHMAC);
            return this;
        }

        public Builder inline(String inline) {
            this.inline = inline;
            return this;
        }

        public Builder inline(boolean inline) {
            this.inline = Boolean.toString(inline);
            return this;
        }

        @Override
        public CryptoDataFormat end() {
            return new CryptoDataFormat(this);
        }
    }
}

