/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Map;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.NoTypeConversionAvailableException;
import org.apache.camel.Processor;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.processor.ProcessorHelper;
import org.apache.camel.processor.SendDynamicAwareResolver;
import org.apache.camel.spi.EndpointUtilizationStatistics;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.ProducerCache;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.spi.SendDynamicAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.cache.DefaultProducerCache;
import org.apache.camel.support.cache.EmptyProducerCache;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendDynamicProcessor
extends AsyncProcessorSupport
implements IdAware,
RouteIdAware,
CamelContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(SendDynamicProcessor.class);
    protected SendDynamicAware dynamicAware;
    protected volatile String scheme;
    protected CamelContext camelContext;
    protected final String uri;
    protected final Expression expression;
    protected String variableSend;
    protected String variableReceive;
    protected ExchangePattern pattern;
    protected ProducerCache producerCache;
    protected HeadersMapFactory headersMapFactory;
    protected String id;
    protected String routeId;
    protected boolean ignoreInvalidEndpoint;
    protected int cacheSize;
    protected boolean allowOptimisedComponents = true;
    protected boolean autoStartupComponents = true;

    public SendDynamicProcessor(String uri, Expression expression) {
        this.uri = uri;
        this.expression = expression;
    }

    public String toString() {
        return this.id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        ExchangePattern destinationExchangePattern;
        Endpoint endpoint;
        if (!this.isStarted()) {
            exchange.setException(new IllegalStateException("SendProcessor has not been started: " + String.valueOf(this)));
            callback.done(true);
            return true;
        }
        ExchangePattern existingPattern = exchange.getPattern();
        Object recipient = null;
        Processor preAwareProcessor = null;
        Processor postAwareProcessor = null;
        Object staticUri = null;
        boolean prototype = this.cacheSize < 0;
        try {
            recipient = this.expression.evaluate(exchange, Object.class);
            if (this.dynamicAware != null) {
                SendDynamicAware.DynamicAwareEntry entry;
                String originalUri = this.uri;
                String uri = SendDynamicProcessor.resolveUri(exchange, recipient);
                String scheme = SendDynamicProcessor.resolveScheme(exchange, uri);
                if (this.dynamicAware.getScheme().equals(scheme) && (entry = this.dynamicAware.prepare(exchange, uri, originalUri)) != null) {
                    staticUri = this.dynamicAware.resolveStaticUri(exchange, entry);
                    preAwareProcessor = this.dynamicAware.createPreProcessor(exchange, entry);
                    postAwareProcessor = this.dynamicAware.createPostProcessor(exchange, entry);
                    if (staticUri != null && LOG.isDebugEnabled()) {
                        LOG.debug("Optimising toD via SendDynamicAware component: {} to use static uri: {}", (Object)scheme, (Object)URISupport.sanitizeUri((String)staticUri));
                    }
                }
            }
            Object targetRecipient = staticUri != null ? staticUri : recipient;
            if ((targetRecipient = SendDynamicProcessor.prepareRecipient(exchange, targetRecipient)) == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send dynamic evaluated as null so cannot send to any endpoint");
                }
                callback.done(true);
                return true;
            }
            Endpoint existing = SendDynamicProcessor.getExistingEndpoint(exchange, targetRecipient);
            if (existing == null) {
                endpoint = SendDynamicProcessor.resolveEndpoint(exchange, targetRecipient, prototype);
            } else {
                endpoint = existing;
                prototype = false;
            }
            destinationExchangePattern = EndpointHelper.resolveExchangePatternFromUrl(endpoint.getEndpointUri());
        }
        catch (Exception e2) {
            if (this.isIgnoreInvalidEndpoint()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Endpoint uri is invalid: {}. This exception will be ignored.", recipient, (Object)e2);
                }
            } else {
                exchange.setException(e2);
            }
            callback.done(true);
            return true;
        }
        Object body = null;
        Map<String, Object> headers = null;
        if (this.variableReceive != null) {
            try {
                body = exchange.getMessage().getBody();
                headers = this.headersMapFactory.newMap(exchange.getMessage().getHeaders());
            }
            catch (Exception throwable) {
                exchange.setException(throwable);
                callback.done(true);
                return true;
            }
        }
        Object originalBody = body;
        Map<String, Object> originalHeaders = headers;
        Processor preProcessor = preAwareProcessor;
        Processor postProcessor = postAwareProcessor;
        ExchangePattern pattern = destinationExchangePattern != null ? destinationExchangePattern : this.pattern;
        boolean stopEndpoint = prototype;
        return this.producerCache.doInAsyncProducer(endpoint, exchange, callback, (p, e, c) -> {
            Exchange target = this.configureExchange(e, pattern, endpoint);
            try {
                if (preProcessor != null) {
                    preProcessor.process(target);
                }
                if (this.variableSend != null) {
                    Object value = ExchangeHelper.getVariable(exchange, this.variableSend);
                    exchange.getMessage().setBody(value);
                }
            }
            catch (Exception t) {
                e.setException(t);
                target.setPattern(existingPattern);
                c.done(true);
            }
            LOG.debug(">>>> {} {}", (Object)endpoint, (Object)e);
            return p.process(target, doneSync -> {
                target.setPattern(existingPattern);
                try {
                    if (postProcessor != null) {
                        postProcessor.process(target);
                    }
                }
                catch (Exception e1) {
                    target.setException(e1);
                }
                if (stopEndpoint) {
                    ServiceHelper.stopAndShutdownService(endpoint);
                }
                if (ExchangeHelper.shouldSetVariableResult(target, this.variableReceive)) {
                    ExchangeHelper.setVariableFromMessageBodyAndHeaders(target, this.variableReceive, target.getMessage());
                    target.getMessage().setBody(originalBody);
                    target.getMessage().setHeaders(originalHeaders);
                }
                c.done(doneSync);
            });
        });
    }

    protected static String resolveUri(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        String uri;
        if (recipient == null) {
            return null;
        }
        if (recipient instanceof String) {
            String string = (String)recipient;
            uri = string.trim();
        } else if (recipient instanceof Endpoint) {
            Endpoint endpoint = (Endpoint)recipient;
            uri = endpoint.getEndpointKey();
        } else {
            uri = exchange.getContext().getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
        }
        try {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(exchange.getContext(), uri);
        }
        catch (Exception e) {
            throw new ResolveEndpointFailedException(uri, e);
        }
        return uri;
    }

    protected static String resolveScheme(Exchange exchange, String uri) {
        return ExchangeHelper.resolveScheme(uri);
    }

    protected static Object prepareRecipient(Exchange exchange, Object recipient) throws NoTypeConversionAvailableException {
        if (recipient instanceof Endpoint || recipient instanceof NormalizedEndpointUri) {
            return recipient;
        }
        if (recipient instanceof String) {
            String string = (String)recipient;
            recipient = string.trim();
        }
        if (recipient != null) {
            String string;
            CamelContext ecc = exchange.getContext();
            String uri = recipient instanceof String ? (string = (String)recipient) : ecc.getTypeConverter().mandatoryConvertTo(String.class, exchange, recipient);
            int colon = uri.indexOf(58);
            if (colon == -1 || colon == uri.length() - 1) {
                throw new ResolveEndpointFailedException(uri, "Endpoint should include scheme:path");
            }
            return ecc.getCamelContextExtension().normalizeUri(uri);
        }
        return null;
    }

    protected static Endpoint getExistingEndpoint(Exchange exchange, Object recipient) {
        return ProcessorHelper.getExistingEndpoint(exchange, recipient);
    }

    protected static Endpoint resolveEndpoint(Exchange exchange, Object recipient, boolean prototype) {
        return prototype ? ExchangeHelper.resolvePrototypeEndpoint(exchange, recipient) : ExchangeHelper.resolveEndpoint(exchange, recipient);
    }

    protected Exchange configureExchange(Exchange exchange, ExchangePattern pattern, Endpoint endpoint) {
        if (pattern != null) {
            exchange.setPattern(pattern);
        }
        exchange.setProperty(ExchangePropertyKey.TO_ENDPOINT, (Object)endpoint.getEndpointUri());
        return exchange;
    }

    @Override
    protected void doInit() throws Exception {
        block7: {
            this.expression.init(this.camelContext);
            if ((this.isAllowOptimisedComponents() || this.isAutoStartupComponents()) && this.uri != null) {
                String u = EndpointHelper.resolveEndpointUriPropertyPlaceholders(this.camelContext, this.uri);
                this.scheme = ExchangeHelper.resolveScheme(u);
            }
            if (this.isAllowOptimisedComponents() && this.uri != null) {
                try {
                    if (this.scheme != null) {
                        String defaultScheme;
                        Component comp;
                        SendDynamicAwareResolver resolver = new SendDynamicAwareResolver();
                        this.dynamicAware = resolver.resolve(this.camelContext, this.scheme);
                        if (this.dynamicAware == null && (comp = this.camelContext.getComponent(this.scheme, false, this.isAutoStartupComponents())) != null && !this.scheme.equals(defaultScheme = comp.getDefaultName())) {
                            this.dynamicAware = resolver.resolve(this.camelContext, defaultScheme);
                            this.dynamicAware.setScheme(this.scheme);
                        }
                        if (this.dynamicAware != null && LOG.isDebugEnabled()) {
                            LOG.debug("Detected SendDynamicAware component: {} optimising toD: {}", (Object)this.scheme, (Object)URISupport.sanitizeUri(this.uri));
                        }
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug("Error creating optimised SendDynamicAwareResolver for uri: {} due to {}. This exception is ignored", new Object[]{URISupport.sanitizeUri(this.uri), e.getMessage(), e});
                }
            }
        }
        ServiceHelper.initService((Object)this.dynamicAware);
        this.headersMapFactory = this.camelContext.getCamelContextExtension().getHeadersMapFactory();
    }

    @Override
    protected void doStart() throws Exception {
        if (this.autoStartupComponents && this.scheme != null) {
            this.camelContext.getComponent(this.scheme);
        }
        if (this.producerCache == null) {
            if (this.cacheSize < 0) {
                this.producerCache = new EmptyProducerCache(this, this.camelContext);
                LOG.debug("DynamicSendTo {} is not using ProducerCache", (Object)this);
            } else {
                this.producerCache = new DefaultProducerCache(this, this.camelContext, this.cacheSize);
                LOG.debug("DynamicSendTo {} using ProducerCache with cacheSize={}", (Object)this, (Object)this.cacheSize);
            }
        }
        ServiceHelper.startService(this.dynamicAware, this.producerCache);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producerCache, this.dynamicAware);
    }

    public EndpointUtilizationStatistics getEndpointUtilizationStatistics() {
        return this.producerCache.getEndpointUtilizationStatistics();
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public SendDynamicAware getDynamicAware() {
        return this.dynamicAware;
    }

    public String getUri() {
        return this.uri;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ExchangePattern getPattern() {
        return this.pattern;
    }

    public void setPattern(ExchangePattern pattern) {
        this.pattern = pattern;
    }

    public String getVariableSend() {
        return this.variableSend;
    }

    public void setVariableSend(String variableSend) {
        this.variableSend = variableSend;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    public boolean isIgnoreInvalidEndpoint() {
        return this.ignoreInvalidEndpoint;
    }

    public void setIgnoreInvalidEndpoint(boolean ignoreInvalidEndpoint) {
        this.ignoreInvalidEndpoint = ignoreInvalidEndpoint;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean isAllowOptimisedComponents() {
        return this.allowOptimisedComponents;
    }

    public void setAllowOptimisedComponents(boolean allowOptimisedComponents) {
        this.allowOptimisedComponents = allowOptimisedComponents;
    }

    public boolean isAutoStartupComponents() {
        return this.autoStartupComponents;
    }

    public void setAutoStartupComponents(boolean autoStartupComponents) {
        this.autoStartupComponents = autoStartupComponents;
    }
}

