/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.spi.ExchangeFormatter;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.ExceptionHelper;
import org.apache.camel.support.processor.DefaultExchangeFormatter;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.TimeUtils;

public final class LanguageHelper {
    private LanguageHelper() {
    }

    public static Exception exception(Exchange exchange) {
        Exception exception = exchange.getException();
        if (exception == null) {
            exception = exchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, Exception.class);
        }
        return exception;
    }

    public static String exceptionMessage(Exchange exchange) {
        Exception exception = LanguageHelper.exception(exchange);
        if (exception != null) {
            return exception.getMessage();
        }
        return null;
    }

    public static String exceptionStacktrace(Exchange exchange) {
        Exception exception = LanguageHelper.exception(exchange);
        return ExceptionHelper.stackTraceToString(exception);
    }

    public static boolean endsWith(Exchange exchange, Object leftValue, Object rightValue) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        String leftStr = exchange.getContext().getTypeConverter().convertTo(String.class, leftValue);
        String rightStr = exchange.getContext().getTypeConverter().convertTo(String.class, rightValue);
        if (leftStr != null && rightStr != null) {
            return leftStr.endsWith(rightStr);
        }
        return false;
    }

    public static boolean startsWith(Exchange exchange, Object leftValue, Object rightValue) {
        if (leftValue == null && rightValue == null) {
            return true;
        }
        if (leftValue == null || rightValue == null) {
            return false;
        }
        String leftStr = exchange.getContext().getTypeConverter().convertTo(String.class, leftValue);
        String rightStr = exchange.getContext().getTypeConverter().convertTo(String.class, rightValue);
        if (leftStr != null && rightStr != null) {
            return leftStr.startsWith(rightStr);
        }
        return false;
    }

    public static ExchangeFormatter getOrCreateExchangeFormatter(CamelContext camelContext, ExchangeFormatter exchangeFormatter) {
        if (exchangeFormatter == null && (exchangeFormatter = camelContext.getRegistry().findSingleByType(ExchangeFormatter.class)) == null) {
            DefaultExchangeFormatter def = new DefaultExchangeFormatter();
            def.setShowExchangeId(true);
            def.setMultiline(true);
            def.setShowHeaders(true);
            def.setStyle(DefaultExchangeFormatter.OutputStyle.Fixed);
            try {
                Integer maxChars = CamelContextHelper.parseInteger(camelContext, camelContext.getGlobalOption("CamelLogDebugBodyMaxChars"));
                if (maxChars != null) {
                    def.setMaxChars(maxChars);
                }
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
            exchangeFormatter = def;
        }
        return exchangeFormatter;
    }

    public static String sysenv(String name) {
        return IOHelper.lookupEnvironmentVariable(name);
    }

    public static String escapeQuotes(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char prev = i > 0 ? text.charAt(i - 1) : (char)'\u0000';
            char ch = text.charAt(i);
            if (ch == '\"' && (i == 0 || prev != '\\')) {
                sb.append('\\');
                sb.append('\"');
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static Date dateFromFileLastModified(Exchange exchange, String command) {
        Date date;
        Long num = exchange.getIn().getHeader("CamelFileLastModified", Long.class);
        if (num != null && num > 0L) {
            date = new Date(num);
        } else {
            date = exchange.getIn().getHeader("CamelFileLastModified", Date.class);
            if (date == null) {
                throw new IllegalArgumentException("Cannot find CamelFileLastModified header at command: " + command);
            }
        }
        return date;
    }

    private static Date toDate(Exchange exchange, BiFunction<Exchange, Object, Date> orElseFunction, Object obj) {
        if (obj instanceof Date) {
            Date date = (Date)obj;
            return date;
        }
        if (obj instanceof Long) {
            Long date = (Long)obj;
            return new Date(date);
        }
        if (orElseFunction != null) {
            return orElseFunction.apply(exchange, obj);
        }
        return null;
    }

    public static Date dateFromExchangeProperty(Exchange exchange, String command, BiFunction<Exchange, Object, Date> orElseFunction) {
        String key = command.substring(command.lastIndexOf(46) + 1);
        Object obj = exchange.getProperty(key);
        return LanguageHelper.toDate(exchange, orElseFunction, obj);
    }

    public static Date dateFromHeader(Exchange exchange, String command, BiFunction<Exchange, Object, Date> orElseFunction) {
        String key = command.substring(command.lastIndexOf(46) + 1);
        Object obj = exchange.getMessage().getHeader(key);
        return LanguageHelper.toDate(exchange, orElseFunction, obj);
    }

    public static Date dateFromVariable(Exchange exchange, String command, BiFunction<Exchange, Object, Date> orElseFunction) {
        String key = command.substring(command.lastIndexOf(46) + 1);
        Object obj = exchange.getVariable(key);
        return LanguageHelper.toDate(exchange, orElseFunction, obj);
    }

    public static Date dateFromExchangeCreated(Exchange exchange) {
        return exchange.getClock().asDate();
    }

    public static Object applyDateOffsets(Date date, List<Long> offsets, String pattern, String timezone) {
        long dateAsLong = date.getTime();
        for (long offset : offsets) {
            dateAsLong += offset;
        }
        if (pattern != null && !pattern.isEmpty()) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            if (timezone != null && !timezone.isEmpty()) {
                df.setTimeZone(TimeZone.getTimeZone(timezone));
            }
            return df.format(new Date(dateAsLong));
        }
        return new Date(dateAsLong);
    }

    public static List<Long> captureOffsets(String commandWithOffsets, Pattern offsetPattern) {
        ArrayList<Long> offsets = new ArrayList<Long>();
        Matcher offsetMatcher = offsetPattern.matcher(commandWithOffsets);
        while (offsetMatcher.find()) {
            String time = offsetMatcher.group(2).trim();
            long value = TimeUtils.toMilliSeconds(time);
            offsets.add(offsetMatcher.group(1).equals("+") ? value : -value);
        }
        return offsets;
    }
}

