/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v2_39_1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum ObjectType {
    DATA_ELEMENT("DATA_ELEMENT"),
    DATA_ELEMENT_GROUP("DATA_ELEMENT_GROUP"),
    INDICATOR("INDICATOR"),
    INDICATOR_GROUP("INDICATOR_GROUP"),
    DATA_SET("DATA_SET"),
    ORGANISATION_UNIT("ORGANISATION_UNIT"),
    ORGANISATION_UNIT_GROUP("ORGANISATION_UNIT_GROUP"),
    ORGANISATION_UNIT_GROUP_SET("ORGANISATION_UNIT_GROUP_SET"),
    USER("USER"),
    USER_GROUP("USER_GROUP"),
    PROGRAM("PROGRAM"),
    PROGRAM_STAGE("PROGRAM_STAGE"),
    TRACKED_ENTITY_TYPE("TRACKED_ENTITY_TYPE"),
    TRACKED_ENTITY_ATTRIBUTE("TRACKED_ENTITY_ATTRIBUTE"),
    CATEGORY_OPTION("CATEGORY_OPTION"),
    CATEGORY_OPTION_GROUP("CATEGORY_OPTION_GROUP"),
    DOCUMENT("DOCUMENT"),
    OPTION("OPTION"),
    OPTION_SET("OPTION_SET"),
    CONSTANT("CONSTANT"),
    LEGEND_SET("LEGEND_SET"),
    PROGRAM_INDICATOR("PROGRAM_INDICATOR"),
    SQL_VIEW("SQL_VIEW"),
    SECTION("SECTION"),
    CATEGORY_OPTION_COMBO("CATEGORY_OPTION_COMBO"),
    CATEGORY_OPTION_GROUP_SET("CATEGORY_OPTION_GROUP_SET"),
    DATA_ELEMENT_GROUP_SET("DATA_ELEMENT_GROUP_SET"),
    VALIDATION_RULE("VALIDATION_RULE"),
    VALIDATION_RULE_GROUP("VALIDATION_RULE_GROUP"),
    CATEGORY("CATEGORY"),
    VISUALIZATION("VISUALIZATION"),
    MAP("MAP"),
    EVENT_REPORT("EVENT_REPORT"),
    EVENT_CHART("EVENT_CHART"),
    RELATIONSHIP_TYPE("RELATIONSHIP_TYPE");

    private final String value;
    private static final Map<String, ObjectType> CONSTANTS;

    private ObjectType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static ObjectType fromValue(String value) {
        ObjectType constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, ObjectType>();
        for (ObjectType c : ObjectType.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

