/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.internal.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import org.hisp.dhis.integration.sdk.api.converter.ConverterFactory;
import org.hisp.dhis.integration.sdk.api.converter.RequestConverter;
import org.hisp.dhis.integration.sdk.api.converter.ResponseConverter;
import org.hisp.dhis.integration.sdk.internal.converter.JacksonConverter;
import org.hisp.dhis.integration.sdk.internal.converter.JacksonRequestConverter;
import org.hisp.dhis.integration.sdk.internal.converter.JacksonResponseConverter;

public class JacksonConverterFactory
implements ConverterFactory {
    private final ObjectMapper objectMapper;

    public JacksonConverterFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public JacksonConverterFactory() {
        this.objectMapper = new ObjectMapper().registerModule(new Jdk8Module().configureAbsentsAsNulls(true));
    }

    @Override
    public JacksonConverter createConverter() {
        return new JacksonConverter(this.objectMapper);
    }

    @Override
    public <T> RequestConverter<T> createRequestConverter(Class<T> requestType) {
        return new JacksonRequestConverter<T>(requestType, this.createConverter());
    }

    @Override
    public <T> ResponseConverter<T> createResponseConverter(Class<T> responseType) {
        return new JacksonResponseConverter<T>(responseType, this.createConverter());
    }
}

