/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.integration.sdk.internal.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.hisp.dhis.integration.sdk.api.Dhis2Response;
import org.hisp.dhis.integration.sdk.api.converter.ConverterFactory;
import org.hisp.dhis.integration.sdk.api.operation.GetOperation;
import org.hisp.dhis.integration.sdk.api.operation.PagingCollectOperation;
import org.hisp.dhis.integration.sdk.api.operation.SimpleCollectOperation;
import org.hisp.dhis.integration.sdk.internal.DefaultDhis2Response;
import org.hisp.dhis.integration.sdk.internal.operation.AbstractOperation;
import org.hisp.dhis.integration.sdk.internal.operation.DefaultSimpleCollectOperation;
import org.hisp.dhis.integration.sdk.internal.operation.page.DefaultPagingCollectOperation;

public class DefaultGetOperation
extends AbstractOperation<Dhis2Response>
implements GetOperation {
    protected final List<String> fields = new ArrayList<String>();
    protected List<String> filters = new ArrayList<String>();
    protected String rootJunction;

    public DefaultGetOperation(String baseApiUrl, String path, OkHttpClient httpClient, ConverterFactory converterFactory, String ... pathParams) {
        super(baseApiUrl, path, httpClient, converterFactory, pathParams);
    }

    @Override
    public Dhis2Response doTransfer(HttpUrl httpUrl) {
        HttpUrl.Builder httpUrlBuilder = httpUrl.newBuilder();
        if (!this.fields.isEmpty()) {
            StringBuilder fieldsAsString = new StringBuilder();
            for (String field : this.fields) {
                fieldsAsString.append(field).append(",");
            }
            httpUrlBuilder.addQueryParameter("fields", fieldsAsString.substring(0, fieldsAsString.length() - 1));
        }
        for (String filter : this.filters) {
            httpUrlBuilder.addQueryParameter("filter", filter);
        }
        if (this.rootJunction != null) {
            httpUrlBuilder.addQueryParameter("rootJunction", this.rootJunction);
        }
        Response response = this.onHttpResponse(() -> this.httpClient.newCall(new Request.Builder().url(httpUrlBuilder.build()).get().build()).execute());
        return new DefaultDhis2Response(response, this.converterFactory);
    }

    @Override
    public PagingCollectOperation withPaging() {
        return new DefaultPagingCollectOperation(this.baseApiUrl, this.path, this.httpClient, this.converterFactory, this, this.pathParams);
    }

    @Override
    public SimpleCollectOperation withoutPaging() {
        return new DefaultSimpleCollectOperation(this.baseApiUrl, this.path, this.httpClient, this.converterFactory, this, this.pathParams);
    }

    @Override
    public GetOperation withFields(String ... names) {
        this.fields.addAll(Arrays.asList(names));
        return this;
    }

    @Override
    public GetOperation withField(String name) {
        this.fields.add(name);
        return this;
    }

    @Override
    public GetOperation withFilter(String filter) {
        this.filters.add(filter);
        return this;
    }

    @Override
    public GetOperation withOrRootJunction() {
        this.rootJunction = "OR";
        return this;
    }

    @Override
    public GetOperation withAndRootJunction() {
        this.rootJunction = "AND";
        return this;
    }
}

