/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.dhis2.api.Dhis2Resource;
import org.apache.camel.spi.TypeConverterRegistry;

@Converter(generateLoader=true)
public final class Dhis2Converters {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private Dhis2Converters() {
    }

    @Converter(fallback=true)
    public static <T> T convertTo(Class<T> type, Exchange exchange, Object resource, TypeConverterRegistry registry) {
        if (resource instanceof Dhis2Resource && type.getName().startsWith("org.hisp.dhis.api.model")) {
            return OBJECT_MAPPER.convertValue(resource, type);
        }
        return null;
    }
}

