/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.dhis2.Dhis2Configuration;
import org.apache.camel.component.dhis2.Dhis2Endpoint;
import org.apache.camel.component.dhis2.internal.Dhis2ApiName;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;

public class Dhis2EndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Dhis2Endpoint target = (Dhis2Endpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold(Dhis2EndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold(Dhis2EndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier(Dhis2EndpointConfigurer.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "baseapiurl": 
            case "baseApiUrl": {
                ((Dhis2Configuration)target.getConfiguration()).setBaseApiUrl(Dhis2EndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(Dhis2EndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "client": {
                ((Dhis2Configuration)target.getConfiguration()).setClient(Dhis2EndpointConfigurer.property(camelContext, Dhis2Client.class, value));
                return true;
            }
            case "delay": {
                target.setDelay(Dhis2EndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler(Dhis2EndpointConfigurer.property(camelContext, ExceptionHandler.class, value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern(Dhis2EndpointConfigurer.property(camelContext, ExchangePattern.class, value));
                return true;
            }
            case "greedy": {
                target.setGreedy(Dhis2EndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "inbody": 
            case "inBody": {
                target.setInBody(Dhis2EndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay(Dhis2EndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(Dhis2EndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "password": {
                ((Dhis2Configuration)target.getConfiguration()).setPassword(Dhis2EndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "personalaccesstoken": 
            case "personalAccessToken": {
                ((Dhis2Configuration)target.getConfiguration()).setPersonalAccessToken(Dhis2EndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy(Dhis2EndpointConfigurer.property(camelContext, PollingConsumerPollStrategy.class, value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount(Dhis2EndpointConfigurer.property(camelContext, Long.TYPE, value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel(Dhis2EndpointConfigurer.property(camelContext, LoggingLevel.class, value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService(Dhis2EndpointConfigurer.property(camelContext, ScheduledExecutorService.class, value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(Dhis2EndpointConfigurer.property(camelContext, Object.class, value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties(Dhis2EndpointConfigurer.property(camelContext, Map.class, value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle(Dhis2EndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler(Dhis2EndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit(Dhis2EndpointConfigurer.property(camelContext, TimeUnit.class, value));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay(Dhis2EndpointConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "username": {
                ((Dhis2Configuration)target.getConfiguration()).setUsername(Dhis2EndpointConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return Integer.TYPE;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return Integer.TYPE;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return Integer.TYPE;
            }
            case "baseapiurl": 
            case "baseApiUrl": {
                return String.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "client": {
                return Dhis2Client.class;
            }
            case "delay": {
                return Long.TYPE;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return ExceptionHandler.class;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return ExchangePattern.class;
            }
            case "greedy": {
                return Boolean.TYPE;
            }
            case "inbody": 
            case "inBody": {
                return String.class;
            }
            case "initialdelay": 
            case "initialDelay": {
                return Long.TYPE;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "personalaccesstoken": 
            case "personalAccessToken": {
                return String.class;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return PollingConsumerPollStrategy.class;
            }
            case "repeatcount": 
            case "repeatCount": {
                return Long.TYPE;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return LoggingLevel.class;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return ScheduledExecutorService.class;
            }
            case "scheduler": {
                return Object.class;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Map.class;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return Boolean.TYPE;
            }
            case "startscheduler": 
            case "startScheduler": {
                return Boolean.TYPE;
            }
            case "timeunit": 
            case "timeUnit": {
                return TimeUnit.class;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return Boolean.TYPE;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Dhis2Endpoint target = (Dhis2Endpoint)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "baseapiurl": 
            case "baseApiUrl": {
                return ((Dhis2Configuration)target.getConfiguration()).getBaseApiUrl();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "client": {
                return ((Dhis2Configuration)target.getConfiguration()).getClient();
            }
            case "delay": {
                return target.getDelay();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "inbody": 
            case "inBody": {
                return target.getInBody();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "password": {
                return ((Dhis2Configuration)target.getConfiguration()).getPassword();
            }
            case "personalaccesstoken": 
            case "personalAccessToken": {
                return ((Dhis2Configuration)target.getConfiguration()).getPersonalAccessToken();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
            case "username": {
                return ((Dhis2Configuration)target.getConfiguration()).getUsername();
            }
        }
        return null;
    }

    @Override
    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "schedulerproperties": 
            case "schedulerProperties": {
                return Object.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("ApiName", Dhis2ApiName.class);
        map.put("MethodName", String.class);
        map.put("BaseApiUrl", String.class);
        map.put("InBody", String.class);
        map.put("SendEmptyMessageWhenIdle", Boolean.TYPE);
        map.put("BridgeErrorHandler", Boolean.TYPE);
        map.put("ExceptionHandler", ExceptionHandler.class);
        map.put("ExchangePattern", ExchangePattern.class);
        map.put("PollStrategy", PollingConsumerPollStrategy.class);
        map.put("LazyStartProducer", Boolean.TYPE);
        map.put("Client", Dhis2Client.class);
        map.put("BackoffErrorThreshold", Integer.TYPE);
        map.put("BackoffIdleThreshold", Integer.TYPE);
        map.put("BackoffMultiplier", Integer.TYPE);
        map.put("Delay", Long.TYPE);
        map.put("Greedy", Boolean.TYPE);
        map.put("InitialDelay", Long.TYPE);
        map.put("RepeatCount", Long.TYPE);
        map.put("RunLoggingLevel", LoggingLevel.class);
        map.put("ScheduledExecutorService", ScheduledExecutorService.class);
        map.put("Scheduler", Object.class);
        map.put("SchedulerProperties", Map.class);
        map.put("StartScheduler", Boolean.TYPE);
        map.put("TimeUnit", TimeUnit.class);
        map.put("UseFixedDelay", Boolean.TYPE);
        map.put("Password", String.class);
        map.put("PersonalAccessToken", String.class);
        map.put("Username", String.class);
        ALL_OPTIONS = map;
    }
}

