/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson;

import org.apache.camel.Exchange;

public class SchemaHelper {
    public static final String SCHEMA = "schema";
    public static final String VALIDATE = "validate";
    public static final String CONTENT_SCHEMA = "X-Content-Schema";
    public static final String CONTENT_SCHEMA_TYPE = "X-Content-Schema-Type";
    public static final String CONTENT_CLASS = "X-Content-Class";

    private SchemaHelper() {
    }

    public static String resolveContentClass(Exchange exchange, String fallback) {
        String contentClass = exchange.getProperty(CONTENT_CLASS, String.class);
        if (contentClass != null) {
            return contentClass;
        }
        Object payload = exchange.getMessage().getBody();
        if (payload != null && SchemaHelper.isPojo(payload.getClass())) {
            return payload.getClass().getName();
        }
        return fallback;
    }

    public static boolean isString(Class<?> type) {
        return String.class.isAssignableFrom(type);
    }

    public static boolean isNumber(Class<?> type) {
        return Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || type.isArray() && type.getComponentType().isPrimitive() || Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type);
    }

    public static boolean isPojo(Class<?> type) {
        Package pkg = type.getPackage();
        if (pkg != null && (pkg.getName().startsWith("java") || pkg.getName().startsWith("javax") || pkg.getName().startsWith("com.sun") || pkg.getName().startsWith("com.oracle"))) {
            return false;
        }
        if (SchemaHelper.isNumber(type)) {
            return false;
        }
        if (SchemaHelper.isPrimitive(type)) {
            return false;
        }
        return !SchemaHelper.isString(type);
    }
}

