/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_2_2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"algorithm", "count", "dataEndDate", "dataStartDate", "maxResults", "orderBy", "threshold"})
public class OutlierDetectionMetadata
implements Serializable {
    @JsonProperty(value="algorithm")
    private AlgorithmRef algorithm;
    @JsonProperty(value="count")
    private Integer count;
    @JsonProperty(value="dataEndDate")
    private Date dataEndDate;
    @JsonProperty(value="dataStartDate")
    private Date dataStartDate;
    @JsonProperty(value="maxResults")
    private Integer maxResults;
    @JsonProperty(value="orderBy")
    private OrderByRef orderBy;
    @JsonProperty(value="threshold")
    private Double threshold;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = 578196203065430403L;

    public OutlierDetectionMetadata() {
    }

    public OutlierDetectionMetadata(OutlierDetectionMetadata source2) {
        this.algorithm = source2.algorithm;
        this.count = source2.count;
        this.dataEndDate = source2.dataEndDate;
        this.dataStartDate = source2.dataStartDate;
        this.maxResults = source2.maxResults;
        this.orderBy = source2.orderBy;
        this.threshold = source2.threshold;
    }

    public OutlierDetectionMetadata(AlgorithmRef algorithm, Integer count, Date dataEndDate, Date dataStartDate, Integer maxResults, OrderByRef orderBy, Double threshold) {
        this.algorithm = algorithm;
        this.count = count;
        this.dataEndDate = dataEndDate;
        this.dataStartDate = dataStartDate;
        this.maxResults = maxResults;
        this.orderBy = orderBy;
        this.threshold = threshold;
    }

    @JsonProperty(value="algorithm")
    public AlgorithmRef getAlgorithm() {
        return this.algorithm;
    }

    @JsonProperty(value="algorithm")
    public void setAlgorithm(AlgorithmRef algorithm) {
        this.algorithm = algorithm;
    }

    public OutlierDetectionMetadata withAlgorithm(AlgorithmRef algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    @JsonProperty(value="count")
    public Optional<Integer> getCount() {
        return Optional.ofNullable(this.count);
    }

    @JsonProperty(value="count")
    public void setCount(Integer count) {
        this.count = count;
    }

    public OutlierDetectionMetadata withCount(Integer count) {
        this.count = count;
        return this;
    }

    @JsonProperty(value="dataEndDate")
    public Optional<Date> getDataEndDate() {
        return Optional.ofNullable(this.dataEndDate);
    }

    @JsonProperty(value="dataEndDate")
    public void setDataEndDate(Date dataEndDate) {
        this.dataEndDate = dataEndDate;
    }

    public OutlierDetectionMetadata withDataEndDate(Date dataEndDate) {
        this.dataEndDate = dataEndDate;
        return this;
    }

    @JsonProperty(value="dataStartDate")
    public Optional<Date> getDataStartDate() {
        return Optional.ofNullable(this.dataStartDate);
    }

    @JsonProperty(value="dataStartDate")
    public void setDataStartDate(Date dataStartDate) {
        this.dataStartDate = dataStartDate;
    }

    public OutlierDetectionMetadata withDataStartDate(Date dataStartDate) {
        this.dataStartDate = dataStartDate;
        return this;
    }

    @JsonProperty(value="maxResults")
    public Optional<Integer> getMaxResults() {
        return Optional.ofNullable(this.maxResults);
    }

    @JsonProperty(value="maxResults")
    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public OutlierDetectionMetadata withMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @JsonProperty(value="orderBy")
    public OrderByRef getOrderBy() {
        return this.orderBy;
    }

    @JsonProperty(value="orderBy")
    public void setOrderBy(OrderByRef orderBy) {
        this.orderBy = orderBy;
    }

    public OutlierDetectionMetadata withOrderBy(OrderByRef orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @JsonProperty(value="threshold")
    public Optional<Double> getThreshold() {
        return Optional.ofNullable(this.threshold);
    }

    @JsonProperty(value="threshold")
    public void setThreshold(Double threshold) {
        this.threshold = threshold;
    }

    public OutlierDetectionMetadata withThreshold(Double threshold) {
        this.threshold = threshold;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public OutlierDetectionMetadata withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("algorithm".equals(name)) {
            if (!(value instanceof AlgorithmRef)) {
                throw new IllegalArgumentException("property \"algorithm\" is of type \"org.hisp.dhis.api.model.v40_2_2.OutlierDetectionMetadata.AlgorithmRef\", but got " + value.getClass().toString());
            }
            this.setAlgorithm((AlgorithmRef)((Object)value));
            return true;
        }
        if ("count".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"count\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setCount((Integer)value);
            return true;
        }
        if ("dataEndDate".equals(name)) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("property \"dataEndDate\" is of type \"java.util.Date\", but got " + value.getClass().toString());
            }
            this.setDataEndDate((Date)value);
            return true;
        }
        if ("dataStartDate".equals(name)) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("property \"dataStartDate\" is of type \"java.util.Date\", but got " + value.getClass().toString());
            }
            this.setDataStartDate((Date)value);
            return true;
        }
        if ("maxResults".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"maxResults\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setMaxResults((Integer)value);
            return true;
        }
        if ("orderBy".equals(name)) {
            if (!(value instanceof OrderByRef)) {
                throw new IllegalArgumentException("property \"orderBy\" is of type \"org.hisp.dhis.api.model.v40_2_2.OutlierDetectionMetadata.OrderByRef\", but got " + value.getClass().toString());
            }
            this.setOrderBy((OrderByRef)((Object)value));
            return true;
        }
        if ("threshold".equals(name)) {
            if (!(value instanceof Double)) {
                throw new IllegalArgumentException("property \"threshold\" is of type \"java.lang.Double\", but got " + value.getClass().toString());
            }
            this.setThreshold((Double)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("algorithm".equals(name)) {
            return this.getAlgorithm();
        }
        if ("count".equals(name)) {
            return this.getCount();
        }
        if ("dataEndDate".equals(name)) {
            return this.getDataEndDate();
        }
        if ("dataStartDate".equals(name)) {
            return this.getDataStartDate();
        }
        if ("maxResults".equals(name)) {
            return this.getMaxResults();
        }
        if ("orderBy".equals(name)) {
            return this.getOrderBy();
        }
        if ("threshold".equals(name)) {
            return this.getThreshold();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public OutlierDetectionMetadata with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(OutlierDetectionMetadata.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("algorithm");
        sb.append('=');
        sb.append(this.algorithm == null ? "<null>" : this.algorithm);
        sb.append(',');
        sb.append("count");
        sb.append('=');
        sb.append(this.count == null ? "<null>" : this.count);
        sb.append(',');
        sb.append("dataEndDate");
        sb.append('=');
        sb.append(this.dataEndDate == null ? "<null>" : this.dataEndDate);
        sb.append(',');
        sb.append("dataStartDate");
        sb.append('=');
        sb.append(this.dataStartDate == null ? "<null>" : this.dataStartDate);
        sb.append(',');
        sb.append("maxResults");
        sb.append('=');
        sb.append(this.maxResults == null ? "<null>" : this.maxResults);
        sb.append(',');
        sb.append("orderBy");
        sb.append('=');
        sb.append(this.orderBy == null ? "<null>" : this.orderBy);
        sb.append(',');
        sb.append("threshold");
        sb.append('=');
        sb.append(this.threshold == null ? "<null>" : this.threshold);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.dataStartDate == null ? 0 : this.dataStartDate.hashCode());
        result = result * 31 + (this.maxResults == null ? 0 : this.maxResults.hashCode());
        result = result * 31 + (this.count == null ? 0 : this.count.hashCode());
        result = result * 31 + (this.orderBy == null ? 0 : this.orderBy.hashCode());
        result = result * 31 + (this.threshold == null ? 0 : this.threshold.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.dataEndDate == null ? 0 : this.dataEndDate.hashCode());
        result = result * 31 + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof OutlierDetectionMetadata)) {
            return false;
        }
        OutlierDetectionMetadata rhs = (OutlierDetectionMetadata)other;
        return (this.dataStartDate == rhs.dataStartDate || this.dataStartDate != null && this.dataStartDate.equals(rhs.dataStartDate)) && (this.maxResults == rhs.maxResults || this.maxResults != null && this.maxResults.equals(rhs.maxResults)) && (this.count == rhs.count || this.count != null && this.count.equals(rhs.count)) && (this.orderBy == rhs.orderBy || this.orderBy != null && this.orderBy.equals((Object)rhs.orderBy)) && (this.threshold == rhs.threshold || this.threshold != null && this.threshold.equals(rhs.threshold)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.dataEndDate == rhs.dataEndDate || this.dataEndDate != null && this.dataEndDate.equals(rhs.dataEndDate)) && (this.algorithm == rhs.algorithm || this.algorithm != null && this.algorithm.equals((Object)rhs.algorithm));
    }

    public static enum OrderByRef {
        MEAN_ABS_DEV("MEAN_ABS_DEV"),
        Z_SCORE("Z_SCORE");

        private final String value;
        private static final Map<String, OrderByRef> CONSTANTS;

        private OrderByRef(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static OrderByRef fromValue(String value) {
            OrderByRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, OrderByRef>();
            for (OrderByRef c : OrderByRef.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum AlgorithmRef {
        Z_SCORE("Z_SCORE"),
        MIN_MAX("MIN_MAX"),
        MOD_Z_SCORE("MOD_Z_SCORE");

        private final String value;
        private static final Map<String, AlgorithmRef> CONSTANTS;

        private AlgorithmRef(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static AlgorithmRef fromValue(String value) {
            AlgorithmRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, AlgorithmRef>();
            for (AlgorithmRef c : AlgorithmRef.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

