/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_2_2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"axis", "dimensionItem", "type"})
public class Series
implements Serializable {
    @JsonProperty(value="axis")
    private Integer axis;
    @JsonProperty(value="dimensionItem")
    private String dimensionItem;
    @JsonProperty(value="type")
    private TypeRef type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = 7603418415524516993L;

    public Series() {
    }

    public Series(Series source2) {
        this.axis = source2.axis;
        this.dimensionItem = source2.dimensionItem;
        this.type = source2.type;
    }

    public Series(Integer axis, String dimensionItem, TypeRef type) {
        this.axis = axis;
        this.dimensionItem = dimensionItem;
        this.type = type;
    }

    @JsonProperty(value="axis")
    public Optional<Integer> getAxis() {
        return Optional.ofNullable(this.axis);
    }

    @JsonProperty(value="axis")
    public void setAxis(Integer axis) {
        this.axis = axis;
    }

    public Series withAxis(Integer axis) {
        this.axis = axis;
        return this;
    }

    @JsonProperty(value="dimensionItem")
    public Optional<String> getDimensionItem() {
        return Optional.ofNullable(this.dimensionItem);
    }

    @JsonProperty(value="dimensionItem")
    public void setDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
    }

    public Series withDimensionItem(String dimensionItem) {
        this.dimensionItem = dimensionItem;
        return this;
    }

    @JsonProperty(value="type")
    public TypeRef getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TypeRef type) {
        this.type = type;
    }

    public Series withType(TypeRef type) {
        this.type = type;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Series withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("axis".equals(name)) {
            if (!(value instanceof Integer)) {
                throw new IllegalArgumentException("property \"axis\" is of type \"java.lang.Integer\", but got " + value.getClass().toString());
            }
            this.setAxis((Integer)value);
            return true;
        }
        if ("dimensionItem".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"dimensionItem\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setDimensionItem((String)value);
            return true;
        }
        if ("type".equals(name)) {
            if (!(value instanceof TypeRef)) {
                throw new IllegalArgumentException("property \"type\" is of type \"org.hisp.dhis.api.model.v40_2_2.Series.TypeRef\", but got " + value.getClass().toString());
            }
            this.setType((TypeRef)((Object)value));
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("axis".equals(name)) {
            return this.getAxis();
        }
        if ("dimensionItem".equals(name)) {
            return this.getDimensionItem();
        }
        if ("type".equals(name)) {
            return this.getType();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public Series with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Series.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("axis");
        sb.append('=');
        sb.append(this.axis == null ? "<null>" : this.axis);
        sb.append(',');
        sb.append("dimensionItem");
        sb.append('=');
        sb.append(this.dimensionItem == null ? "<null>" : this.dimensionItem);
        sb.append(',');
        sb.append("type");
        sb.append('=');
        sb.append(this.type == null ? "<null>" : this.type);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.axis == null ? 0 : this.axis.hashCode());
        result = result * 31 + (this.dimensionItem == null ? 0 : this.dimensionItem.hashCode());
        result = result * 31 + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Series)) {
            return false;
        }
        Series rhs = (Series)other;
        return (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.axis == rhs.axis || this.axis != null && this.axis.equals(rhs.axis)) && (this.dimensionItem == rhs.dimensionItem || this.dimensionItem != null && this.dimensionItem.equals(rhs.dimensionItem)) && (this.type == rhs.type || this.type != null && this.type.equals((Object)rhs.type));
    }

    public static enum TypeRef {
        COLUMN("COLUMN"),
        STACKED_COLUMN("STACKED_COLUMN"),
        BAR("BAR"),
        STACKED_BAR("STACKED_BAR"),
        LINE("LINE"),
        AREA("AREA"),
        STACKED_AREA("STACKED_AREA"),
        PIE("PIE"),
        RADAR("RADAR"),
        GAUGE("GAUGE"),
        YEAR_OVER_YEAR_LINE("YEAR_OVER_YEAR_LINE"),
        YEAR_OVER_YEAR_COLUMN("YEAR_OVER_YEAR_COLUMN"),
        SCATTER("SCATTER"),
        BUBBLE("BUBBLE"),
        SINGLE_VALUE("SINGLE_VALUE"),
        PIVOT_TABLE("PIVOT_TABLE");

        private final String value;
        private static final Map<String, TypeRef> CONSTANTS;

        private TypeRef(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TypeRef fromValue(String value) {
            TypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TypeRef>();
            for (TypeRef c : TypeRef.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

