/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dhis2;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.dhis2.Dhis2Component;
import org.apache.camel.component.dhis2.Dhis2Configuration;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.hisp.dhis.integration.sdk.api.Dhis2Client;

public class Dhis2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
ExtendedPropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private Dhis2Configuration getOrCreateConfiguration(Dhis2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Dhis2Configuration());
        }
        return (Dhis2Configuration)target.getConfiguration();
    }

    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Dhis2Component target = (Dhis2Component)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(Dhis2ComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "baseapiurl": 
            case "baseApiUrl": {
                this.getOrCreateConfiguration(target).setBaseApiUrl(Dhis2ComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler(Dhis2ComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "client": {
                this.getOrCreateConfiguration(target).setClient(Dhis2ComponentConfigurer.property(camelContext, Dhis2Client.class, value));
                return true;
            }
            case "configuration": {
                target.setConfiguration(Dhis2ComponentConfigurer.property(camelContext, Dhis2Configuration.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(Dhis2ComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword(Dhis2ComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "personalaccesstoken": 
            case "personalAccessToken": {
                this.getOrCreateConfiguration(target).setPersonalAccessToken(Dhis2ComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
            case "username": {
                this.getOrCreateConfiguration(target).setUsername(Dhis2ComponentConfigurer.property(camelContext, String.class, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "baseapiurl": 
            case "baseApiUrl": {
                return String.class;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return Boolean.TYPE;
            }
            case "client": {
                return Dhis2Client.class;
            }
            case "configuration": {
                return Dhis2Configuration.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
            case "password": {
                return String.class;
            }
            case "personalaccesstoken": 
            case "personalAccessToken": {
                return String.class;
            }
            case "username": {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Dhis2Component target = (Dhis2Component)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "baseapiurl": 
            case "baseApiUrl": {
                return this.getOrCreateConfiguration(target).getBaseApiUrl();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "client": {
                return this.getOrCreateConfiguration(target).getClient();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "personalaccesstoken": 
            case "personalAccessToken": {
                return this.getOrCreateConfiguration(target).getPersonalAccessToken();
            }
            case "username": {
                return this.getOrCreateConfiguration(target).getUsername();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("BaseApiUrl", String.class);
        map.put("BridgeErrorHandler", Boolean.TYPE);
        map.put("LazyStartProducer", Boolean.TYPE);
        map.put("AutowiredEnabled", Boolean.TYPE);
        map.put("Client", Dhis2Client.class);
        map.put("Configuration", Dhis2Configuration.class);
        map.put("Password", String.class);
        map.put("PersonalAccessToken", String.class);
        map.put("Username", String.class);
        ALL_OPTIONS = map;
    }
}

