/*
 * Decompiled with CFR 0.152.
 */
package org.hisp.dhis.api.model.v40_2_2;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.hisp.dhis.api.model.v40_2_2.DataRef;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"category", "completed", "data", "dataType", "id", "level", "message", "time", "uid"})
public class Notification
implements Serializable {
    @JsonProperty(value="category")
    private CategoryRef category;
    @JsonProperty(value="completed")
    private Boolean completed;
    @JsonProperty(value="data")
    private DataRef data;
    @JsonProperty(value="dataType")
    private DataTypeRef dataType;
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="level")
    private LevelRef level;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="time")
    private Date time;
    @JsonProperty(value="uid")
    private String uid;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    protected static final Object NOT_FOUND_VALUE = new Object();
    private static final long serialVersionUID = -4978208233836850144L;

    public Notification() {
    }

    public Notification(Notification source2) {
        this.category = source2.category;
        this.completed = source2.completed;
        this.data = source2.data;
        this.dataType = source2.dataType;
        this.id = source2.id;
        this.level = source2.level;
        this.message = source2.message;
        this.time = source2.time;
        this.uid = source2.uid;
    }

    public Notification(CategoryRef category, Boolean completed, DataRef data, DataTypeRef dataType, String id, LevelRef level, String message, Date time, String uid) {
        this.category = category;
        this.completed = completed;
        this.data = data;
        this.dataType = dataType;
        this.id = id;
        this.level = level;
        this.message = message;
        this.time = time;
        this.uid = uid;
    }

    @JsonProperty(value="category")
    public CategoryRef getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(CategoryRef category) {
        this.category = category;
    }

    public Notification withCategory(CategoryRef category) {
        this.category = category;
        return this;
    }

    @JsonProperty(value="completed")
    public Optional<Boolean> getCompleted() {
        return Optional.ofNullable(this.completed);
    }

    @JsonProperty(value="completed")
    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public Notification withCompleted(Boolean completed) {
        this.completed = completed;
        return this;
    }

    @JsonProperty(value="data")
    public Optional<DataRef> getData() {
        return Optional.ofNullable(this.data);
    }

    @JsonProperty(value="data")
    public void setData(DataRef data) {
        this.data = data;
    }

    public Notification withData(DataRef data) {
        this.data = data;
        return this;
    }

    @JsonProperty(value="dataType")
    public DataTypeRef getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(DataTypeRef dataType) {
        this.dataType = dataType;
    }

    public Notification withDataType(DataTypeRef dataType) {
        this.dataType = dataType;
        return this;
    }

    @JsonProperty(value="id")
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Notification withId(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="level")
    public LevelRef getLevel() {
        return this.level;
    }

    @JsonProperty(value="level")
    public void setLevel(LevelRef level) {
        this.level = level;
    }

    public Notification withLevel(LevelRef level) {
        this.level = level;
        return this;
    }

    @JsonProperty(value="message")
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    @JsonProperty(value="message")
    public void setMessage(String message) {
        this.message = message;
    }

    public Notification withMessage(String message) {
        this.message = message;
        return this;
    }

    @JsonProperty(value="time")
    public Optional<Date> getTime() {
        return Optional.ofNullable(this.time);
    }

    @JsonProperty(value="time")
    public void setTime(Date time) {
        this.time = time;
    }

    public Notification withTime(Date time) {
        this.time = time;
        return this;
    }

    @JsonProperty(value="uid")
    public Optional<String> getUid() {
        return Optional.ofNullable(this.uid);
    }

    @JsonProperty(value="uid")
    public void setUid(String uid) {
        this.uid = uid;
    }

    public Notification withUid(String uid) {
        this.uid = uid;
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public Notification withAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
        return this;
    }

    protected boolean declaredProperty(String name, Object value) {
        if ("category".equals(name)) {
            if (!(value instanceof CategoryRef)) {
                throw new IllegalArgumentException("property \"category\" is of type \"org.hisp.dhis.api.model.v40_2_2.Notification.CategoryRef\", but got " + value.getClass().toString());
            }
            this.setCategory((CategoryRef)((Object)value));
            return true;
        }
        if ("completed".equals(name)) {
            if (!(value instanceof Boolean)) {
                throw new IllegalArgumentException("property \"completed\" is of type \"java.lang.Boolean\", but got " + value.getClass().toString());
            }
            this.setCompleted((Boolean)value);
            return true;
        }
        if ("data".equals(name)) {
            if (!(value instanceof DataRef)) {
                throw new IllegalArgumentException("property \"data\" is of type \"org.hisp.dhis.api.model.v40_2_2.DataRef\", but got " + value.getClass().toString());
            }
            this.setData((DataRef)value);
            return true;
        }
        if ("dataType".equals(name)) {
            if (!(value instanceof DataTypeRef)) {
                throw new IllegalArgumentException("property \"dataType\" is of type \"org.hisp.dhis.api.model.v40_2_2.Notification.DataTypeRef\", but got " + value.getClass().toString());
            }
            this.setDataType((DataTypeRef)((Object)value));
            return true;
        }
        if ("id".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"id\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setId((String)value);
            return true;
        }
        if ("level".equals(name)) {
            if (!(value instanceof LevelRef)) {
                throw new IllegalArgumentException("property \"level\" is of type \"org.hisp.dhis.api.model.v40_2_2.Notification.LevelRef\", but got " + value.getClass().toString());
            }
            this.setLevel((LevelRef)((Object)value));
            return true;
        }
        if ("message".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"message\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setMessage((String)value);
            return true;
        }
        if ("time".equals(name)) {
            if (!(value instanceof Date)) {
                throw new IllegalArgumentException("property \"time\" is of type \"java.util.Date\", but got " + value.getClass().toString());
            }
            this.setTime((Date)value);
            return true;
        }
        if ("uid".equals(name)) {
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("property \"uid\" is of type \"java.lang.String\", but got " + value.getClass().toString());
            }
            this.setUid((String)value);
            return true;
        }
        return false;
    }

    protected Object declaredPropertyOrNotFound(String name, Object notFoundValue) {
        if ("category".equals(name)) {
            return this.getCategory();
        }
        if ("completed".equals(name)) {
            return this.getCompleted();
        }
        if ("data".equals(name)) {
            return this.getData();
        }
        if ("dataType".equals(name)) {
            return this.getDataType();
        }
        if ("id".equals(name)) {
            return this.getId();
        }
        if ("level".equals(name)) {
            return this.getLevel();
        }
        if ("message".equals(name)) {
            return this.getMessage();
        }
        if ("time".equals(name)) {
            return this.getTime();
        }
        if ("uid".equals(name)) {
            return this.getUid();
        }
        return notFoundValue;
    }

    public <T> T get(String name) {
        Object value = this.declaredPropertyOrNotFound(name, NOT_FOUND_VALUE);
        if (NOT_FOUND_VALUE != value) {
            return (T)value;
        }
        return (T)this.getAdditionalProperties().get(name);
    }

    public void set(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
    }

    public Notification with(String name, Object value) {
        if (!this.declaredProperty(name, value)) {
            this.getAdditionalProperties().put(name, value);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Notification.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("category");
        sb.append('=');
        sb.append(this.category == null ? "<null>" : this.category);
        sb.append(',');
        sb.append("completed");
        sb.append('=');
        sb.append(this.completed == null ? "<null>" : this.completed);
        sb.append(',');
        sb.append("data");
        sb.append('=');
        sb.append(this.data == null ? "<null>" : this.data);
        sb.append(',');
        sb.append("dataType");
        sb.append('=');
        sb.append(this.dataType == null ? "<null>" : this.dataType);
        sb.append(',');
        sb.append("id");
        sb.append('=');
        sb.append(this.id == null ? "<null>" : this.id);
        sb.append(',');
        sb.append("level");
        sb.append('=');
        sb.append(this.level == null ? "<null>" : this.level);
        sb.append(',');
        sb.append("message");
        sb.append('=');
        sb.append(this.message == null ? "<null>" : this.message);
        sb.append(',');
        sb.append("time");
        sb.append('=');
        sb.append(this.time == null ? "<null>" : this.time);
        sb.append(',');
        sb.append("uid");
        sb.append('=');
        sb.append(this.uid == null ? "<null>" : this.uid);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.uid == null ? 0 : this.uid.hashCode());
        result = result * 31 + (this.data == null ? 0 : this.data.hashCode());
        result = result * 31 + (this.level == null ? 0 : this.level.hashCode());
        result = result * 31 + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = result * 31 + (this.completed == null ? 0 : this.completed.hashCode());
        result = result * 31 + (this.id == null ? 0 : this.id.hashCode());
        result = result * 31 + (this.time == null ? 0 : this.time.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.category == null ? 0 : this.category.hashCode());
        result = result * 31 + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Notification)) {
            return false;
        }
        Notification rhs = (Notification)other;
        return (this.uid == rhs.uid || this.uid != null && this.uid.equals(rhs.uid)) && (this.data == rhs.data || this.data != null && this.data.equals(rhs.data)) && (this.level == rhs.level || this.level != null && this.level.equals((Object)rhs.level)) && (this.dataType == rhs.dataType || this.dataType != null && this.dataType.equals((Object)rhs.dataType)) && (this.completed == rhs.completed || this.completed != null && this.completed.equals(rhs.completed)) && (this.id == rhs.id || this.id != null && this.id.equals(rhs.id)) && (this.time == rhs.time || this.time != null && this.time.equals(rhs.time)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.category == rhs.category || this.category != null && this.category.equals((Object)rhs.category)) && (this.message == rhs.message || this.message != null && this.message.equals(rhs.message));
    }

    public static enum LevelRef {
        OFF("OFF"),
        DEBUG("DEBUG"),
        LOOP("LOOP"),
        INFO("INFO"),
        WARN("WARN"),
        ERROR("ERROR");

        private final String value;
        private static final Map<String, LevelRef> CONSTANTS;

        private LevelRef(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static LevelRef fromValue(String value) {
            LevelRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, LevelRef>();
            for (LevelRef c : LevelRef.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum DataTypeRef {
        PARAMETERS("PARAMETERS");

        private final String value;
        private static final Map<String, DataTypeRef> CONSTANTS;

        private DataTypeRef(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DataTypeRef fromValue(String value) {
            DataTypeRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DataTypeRef>();
            for (DataTypeRef c : DataTypeRef.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum CategoryRef {
        DATA_STATISTICS("DATA_STATISTICS"),
        DATA_INTEGRITY("DATA_INTEGRITY"),
        RESOURCE_TABLE("RESOURCE_TABLE"),
        ANALYTICS_TABLE("ANALYTICS_TABLE"),
        CONTINUOUS_ANALYTICS_TABLE("CONTINUOUS_ANALYTICS_TABLE"),
        DATA_SYNC("DATA_SYNC"),
        TRACKER_PROGRAMS_DATA_SYNC("TRACKER_PROGRAMS_DATA_SYNC"),
        EVENT_PROGRAMS_DATA_SYNC("EVENT_PROGRAMS_DATA_SYNC"),
        FILE_RESOURCE_CLEANUP("FILE_RESOURCE_CLEANUP"),
        IMAGE_PROCESSING("IMAGE_PROCESSING"),
        META_DATA_SYNC("META_DATA_SYNC"),
        AGGREGATE_DATA_EXCHANGE("AGGREGATE_DATA_EXCHANGE"),
        SMS_SEND("SMS_SEND"),
        SEND_SCHEDULED_MESSAGE("SEND_SCHEDULED_MESSAGE"),
        PROGRAM_NOTIFICATIONS("PROGRAM_NOTIFICATIONS"),
        VALIDATION_RESULTS_NOTIFICATION("VALIDATION_RESULTS_NOTIFICATION"),
        CREDENTIALS_EXPIRY_ALERT("CREDENTIALS_EXPIRY_ALERT"),
        MONITORING("MONITORING"),
        PUSH_ANALYSIS("PUSH_ANALYSIS"),
        TRACKER_SEARCH_OPTIMIZATION("TRACKER_SEARCH_OPTIMIZATION"),
        PREDICTOR("PREDICTOR"),
        DATA_SET_NOTIFICATION("DATA_SET_NOTIFICATION"),
        REMOVE_USED_OR_EXPIRED_RESERVED_VALUES("REMOVE_USED_OR_EXPIRED_RESERVED_VALUES"),
        TRACKER_IMPORT_JOB("TRACKER_IMPORT_JOB"),
        TRACKER_IMPORT_NOTIFICATION_JOB("TRACKER_IMPORT_NOTIFICATION_JOB"),
        TRACKER_IMPORT_RULE_ENGINE_JOB("TRACKER_IMPORT_RULE_ENGINE_JOB"),
        MATERIALIZED_SQL_VIEW_UPDATE("MATERIALIZED_SQL_VIEW_UPDATE"),
        LEADER_ELECTION("LEADER_ELECTION"),
        LEADER_RENEWAL("LEADER_RENEWAL"),
        COMPLETE_DATA_SET_REGISTRATION_IMPORT("COMPLETE_DATA_SET_REGISTRATION_IMPORT"),
        DATAVALUE_IMPORT_INTERNAL("DATAVALUE_IMPORT_INTERNAL"),
        METADATA_IMPORT("METADATA_IMPORT"),
        DATAVALUE_IMPORT("DATAVALUE_IMPORT"),
        GEOJSON_IMPORT("GEOJSON_IMPORT"),
        EVENT_IMPORT("EVENT_IMPORT"),
        ENROLLMENT_IMPORT("ENROLLMENT_IMPORT"),
        TEI_IMPORT("TEI_IMPORT"),
        DISABLE_INACTIVE_USERS("DISABLE_INACTIVE_USERS"),
        ACCOUNT_EXPIRY_ALERT("ACCOUNT_EXPIRY_ALERT"),
        SYSTEM_VERSION_UPDATE_CHECK("SYSTEM_VERSION_UPDATE_CHECK"),
        TEST("TEST"),
        MOCK("MOCK"),
        GML_IMPORT("GML_IMPORT"),
        ANALYTICSTABLE_UPDATE("ANALYTICSTABLE_UPDATE"),
        PROGRAM_DATA_SYNC("PROGRAM_DATA_SYNC");

        private final String value;
        private static final Map<String, CategoryRef> CONSTANTS;

        private CategoryRef(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static CategoryRef fromValue(String value) {
            CategoryRef constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, CategoryRef>();
            for (CategoryRef c : CategoryRef.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

