/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean.producer;

import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.pojo.Action;
import com.myjeeva.digitalocean.pojo.Actions;
import com.myjeeva.digitalocean.pojo.Delete;
import com.myjeeva.digitalocean.pojo.Region;
import com.myjeeva.digitalocean.pojo.Snapshots;
import com.myjeeva.digitalocean.pojo.Volume;
import com.myjeeva.digitalocean.pojo.Volumes;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.producer.DigitalOceanProducer;
import org.apache.camel.util.ObjectHelper;

public class DigitalOceanBlockStoragesProducer
extends DigitalOceanProducer {
    public DigitalOceanBlockStoragesProducer(DigitalOceanEndpoint endpoint, DigitalOceanConfiguration configuration) {
        super(endpoint, configuration);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        switch (this.determineOperation(exchange)) {
            case list: {
                this.getVolumes(exchange);
                break;
            }
            case get: {
                this.getVolume(exchange);
                break;
            }
            case listSnapshots: {
                this.getVolumeSnapshots(exchange);
                break;
            }
            case create: {
                this.createVolume(exchange);
                break;
            }
            case delete: {
                this.deleteVolume(exchange);
                break;
            }
            case attach: {
                this.attachVolumeToDroplet(exchange);
                break;
            }
            case detach: {
                this.detachVolumeToDroplet(exchange);
                break;
            }
            case resize: {
                this.resizeVolume(exchange);
                break;
            }
            case listActions: {
                this.getVolumeActions(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void getVolumes(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        String region = exchange.getIn().getHeader("CamelDigitalOceanRegion", String.class);
        if (ObjectHelper.isEmpty(region)) {
            throw new IllegalArgumentException("CamelDigitalOceanRegion must be specified");
        }
        Volumes volumes = this.getEndpoint().getDigitalOceanClient().getAvailableVolumes(region);
        LOG.trace("All Volumes for region {} [{}] ", (Object)region, volumes.getVolumes());
        exchange.getMessage().setBody(volumes.getVolumes());
    }

    private void createVolume(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Message in = exchange.getIn();
        Volume volume = new Volume();
        if (!ObjectHelper.isNotEmpty(exchange.getIn().getHeader("CamelDigitalOceanVolumeSizeGigabytes"))) {
            throw new IllegalArgumentException("CamelDigitalOceanVolumeSizeGigabytes must be specified");
        }
        volume.setSize(in.getHeader("CamelDigitalOceanVolumeSizeGigabytes", Integer.class));
        if (!ObjectHelper.isNotEmpty(exchange.getIn().getHeader("CamelDigitalOceanName"))) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        volume.setName(in.getHeader("CamelDigitalOceanName", String.class));
        if (!ObjectHelper.isNotEmpty(exchange.getIn().getHeader("CamelDigitalOceanRegion"))) {
            throw new IllegalArgumentException("CamelDigitalOceanRegion must be specified");
        }
        volume.setRegion(new Region(in.getHeader("CamelDigitalOceanRegion", String.class)));
        if (!ObjectHelper.isNotEmpty(exchange.getIn().getHeader("CamelDigitalOceanDescription"))) {
            throw new IllegalArgumentException("CamelDigitalOceanDescription must be specified");
        }
        volume.setDescription(in.getHeader("CamelDigitalOceanDescription", String.class));
        volume = this.getEndpoint().getDigitalOceanClient().createVolume(volume);
        LOG.trace("Volume created {}", (Object)volume);
        exchange.getMessage().setBody(volume);
    }

    private void getVolume(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        String volumeId = exchange.getIn().getHeader("CamelDigitalOceanId", String.class);
        Volume volume = null;
        if (ObjectHelper.isEmpty(volumeId)) {
            String name = exchange.getIn().getHeader("CamelDigitalOceanName", String.class);
            String region = exchange.getIn().getHeader("CamelDigitalOceanRegion", String.class);
            if (ObjectHelper.isEmpty(name) && ObjectHelper.isEmpty(region)) {
                throw new IllegalArgumentException("CamelDigitalOceanId or CamelDigitalOceanName and CamelDigitalOceanRegion must be specified");
            }
            List<Volume> volumes = this.getEndpoint().getDigitalOceanClient().getVolumeInfo(name, region).getVolumes();
            if (!volumes.isEmpty()) {
                volume = volumes.get(0);
            }
        } else {
            volume = this.getEndpoint().getDigitalOceanClient().getVolumeInfo(volumeId);
        }
        LOG.trace("Volume [{}] ", (Object)volume);
        exchange.getMessage().setBody(volume);
    }

    private void getVolumeSnapshots(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        String volumeId = exchange.getIn().getHeader("CamelDigitalOceanId", String.class);
        if (ObjectHelper.isEmpty(volumeId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        Snapshots snapshots = this.getEndpoint().getDigitalOceanClient().getVolumeSnapshots(volumeId, this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("All Snapshots for volume {} [{}] ", (Object)volumeId, snapshots.getSnapshots());
        exchange.getMessage().setBody(snapshots.getSnapshots());
    }

    private void deleteVolume(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Delete delete;
        String volumeId = exchange.getIn().getHeader("CamelDigitalOceanId", String.class);
        if (ObjectHelper.isEmpty(volumeId)) {
            String name = exchange.getIn().getHeader("CamelDigitalOceanName", String.class);
            String region = exchange.getIn().getHeader("CamelDigitalOceanRegion", String.class);
            if (ObjectHelper.isEmpty(name) && ObjectHelper.isEmpty(region)) {
                throw new IllegalArgumentException("CamelDigitalOceanId or CamelDigitalOceanName and CamelDigitalOceanRegion must be specified");
            }
            delete = this.getEndpoint().getDigitalOceanClient().deleteVolume(name, region);
        } else {
            delete = this.getEndpoint().getDigitalOceanClient().deleteVolume(volumeId);
        }
        LOG.trace("Delete Volume [{}] ", (Object)delete);
        exchange.getMessage().setBody(delete);
    }

    private void attachVolumeToDroplet(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Action action;
        String volumeId = exchange.getIn().getHeader("CamelDigitalOceanId", String.class);
        String volumeName = exchange.getIn().getHeader("CamelDigitalOceanVolumeName", String.class);
        Integer dropletId = exchange.getIn().getHeader("CamelDigitalOceanDropletId", Integer.class);
        String region = exchange.getIn().getHeader("CamelDigitalOceanRegion", String.class);
        if (ObjectHelper.isEmpty(dropletId)) {
            throw new IllegalArgumentException("CamelDigitalOceanDropletId must be specified");
        }
        if (ObjectHelper.isEmpty(region)) {
            throw new IllegalArgumentException("CamelDigitalOceanRegion must be specified");
        }
        if (ObjectHelper.isNotEmpty(volumeName)) {
            action = this.getEndpoint().getDigitalOceanClient().attachVolumeByName(dropletId, volumeName, region);
            LOG.trace("Attach Volume {} to Droplet {} [{}] ", new Object[]{volumeName, dropletId, action});
        } else if (ObjectHelper.isNotEmpty(volumeId)) {
            action = this.getEndpoint().getDigitalOceanClient().attachVolume(dropletId, volumeId, region);
            LOG.trace("Attach Volume {} to Droplet {} [{}] ", new Object[]{volumeId, dropletId, action});
        } else {
            throw new IllegalArgumentException("CamelDigitalOceanId or CamelDigitalOceanVolumeName must be specified");
        }
        exchange.getMessage().setBody(action);
    }

    private void detachVolumeToDroplet(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Action action;
        String volumeId = exchange.getIn().getHeader("CamelDigitalOceanId", String.class);
        String volumeName = exchange.getIn().getHeader("CamelDigitalOceanVolumeName", String.class);
        Integer dropletId = exchange.getIn().getHeader("CamelDigitalOceanDropletId", Integer.class);
        String region = exchange.getIn().getHeader("CamelDigitalOceanRegion", String.class);
        if (ObjectHelper.isEmpty(dropletId)) {
            throw new IllegalArgumentException("CamelDigitalOceanDropletId must be specified");
        }
        if (ObjectHelper.isEmpty(region)) {
            throw new IllegalArgumentException("CamelDigitalOceanRegion must be specified");
        }
        if (ObjectHelper.isNotEmpty(volumeName)) {
            action = this.getEndpoint().getDigitalOceanClient().detachVolumeByName(dropletId, volumeName, region);
            LOG.trace("Detach Volume {} to Droplet {} [{}] ", new Object[]{volumeName, dropletId, action});
        } else if (ObjectHelper.isNotEmpty(volumeId)) {
            action = this.getEndpoint().getDigitalOceanClient().detachVolume(dropletId, volumeId, region);
            LOG.trace("Detach Volume {} to Droplet {} [{}] ", new Object[]{volumeId, dropletId, action});
        } else {
            throw new IllegalArgumentException("CamelDigitalOceanId or CamelDigitalOceanVolumeName must be specified");
        }
        exchange.getMessage().setBody(action);
    }

    private void resizeVolume(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        String volumeId = exchange.getIn().getHeader("CamelDigitalOceanId", String.class);
        if (ObjectHelper.isEmpty(volumeId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        String region = exchange.getIn().getHeader("CamelDigitalOceanRegion", String.class);
        if (ObjectHelper.isEmpty(region)) {
            throw new IllegalArgumentException("CamelDigitalOceanRegion must be specified");
        }
        Double size = exchange.getIn().getHeader("CamelDigitalOceanVolumeSizeGigabytes", Double.class);
        if (ObjectHelper.isEmpty(size)) {
            throw new IllegalArgumentException("CamelDigitalOceanVolumeSizeGigabytes must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().resizeVolume(volumeId, region, size);
        LOG.trace("Resize Volume {} [{}] ", (Object)volumeId, (Object)action);
    }

    private void getVolumeActions(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        String volumeId = exchange.getIn().getHeader("CamelDigitalOceanId", String.class);
        if (ObjectHelper.isEmpty(volumeId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        Actions actions = this.getEndpoint().getDigitalOceanClient().getAvailableVolumeActions(volumeId);
        LOG.trace("Actions for Volume {} [{}] ", (Object)volumeId, actions.getActions());
        exchange.getMessage().setBody(actions.getActions());
    }
}

