/*
 * Decompiled with CFR 0.152.
 */
package com.myjeeva.digitalocean.common;

import org.apache.commons.lang3.StringUtils;

public enum Protocol {
    HTTP("http"),
    HTTPS("https"),
    TCP("tcp");

    private String value;

    private Protocol(String value) {
        this.value = value;
    }

    public static Protocol fromValue(String value) {
        if (StringUtils.isBlank(value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        for (Protocol ds : Protocol.values()) {
            if (!value.equalsIgnoreCase(ds.value)) continue;
            return ds;
        }
        throw new IllegalArgumentException("Cannot create enum from " + value + " value!");
    }

    public String toString() {
        return this.value;
    }
}

