/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.digitalocean.producer;

import com.myjeeva.digitalocean.common.ActionType;
import com.myjeeva.digitalocean.exception.DigitalOceanException;
import com.myjeeva.digitalocean.exception.RequestUnsuccessfulException;
import com.myjeeva.digitalocean.pojo.Action;
import com.myjeeva.digitalocean.pojo.Actions;
import com.myjeeva.digitalocean.pojo.Delete;
import com.myjeeva.digitalocean.pojo.Image;
import com.myjeeva.digitalocean.pojo.Images;
import org.apache.camel.Exchange;
import org.apache.camel.component.digitalocean.DigitalOceanConfiguration;
import org.apache.camel.component.digitalocean.DigitalOceanEndpoint;
import org.apache.camel.component.digitalocean.constants.DigitalOceanImageTypes;
import org.apache.camel.component.digitalocean.producer.DigitalOceanProducer;
import org.apache.camel.util.ObjectHelper;

public class DigitalOceanImagesProducer
extends DigitalOceanProducer {
    public DigitalOceanImagesProducer(DigitalOceanEndpoint endpoint, DigitalOceanConfiguration configuration) {
        super(endpoint, configuration);
    }

    @Override
    public void process(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        switch (this.determineOperation(exchange)) {
            case list: {
                this.getImages(exchange);
                break;
            }
            case ownList: {
                this.getUserImages(exchange);
                break;
            }
            case listActions: {
                this.getImageActions(exchange);
                break;
            }
            case get: {
                this.getImage(exchange);
                break;
            }
            case update: {
                this.updateImage(exchange);
                break;
            }
            case delete: {
                this.deleteImage(exchange);
                break;
            }
            case transfer: {
                this.transferImage(exchange);
                break;
            }
            case convert: {
                this.convertImageToSnapshot(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported operation");
            }
        }
    }

    private void getUserImages(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Images images = this.getEndpoint().getDigitalOceanClient().getUserImages(this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("User images : page {} / {} per page [{}] ", new Object[]{this.configuration.getPage(), this.configuration.getPerPage(), images.getImages()});
        exchange.getMessage().setBody(images.getImages());
    }

    private void getImages(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        DigitalOceanImageTypes type = exchange.getIn().getHeader("CamelDigitalOceanType", DigitalOceanImageTypes.class);
        Images images = ObjectHelper.isNotEmpty(type) ? this.getEndpoint().getDigitalOceanClient().getAvailableImages(this.configuration.getPage(), this.configuration.getPerPage(), ActionType.valueOf(type.name())) : this.getEndpoint().getDigitalOceanClient().getAvailableImages(this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("All Images : page {} / {} per page [{}] ", new Object[]{this.configuration.getPage(), this.configuration.getPerPage(), images.getImages()});
        exchange.getMessage().setBody(images.getImages());
    }

    private void getImage(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Image image;
        Integer imageId = exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        String slug = exchange.getIn().getHeader("CamelDigitalOceanDropletImage", String.class);
        if (ObjectHelper.isNotEmpty(imageId)) {
            image = this.getEndpoint().getDigitalOceanClient().getImageInfo(imageId);
        } else if (ObjectHelper.isNotEmpty(slug)) {
            image = this.getEndpoint().getDigitalOceanClient().getImageInfo(slug);
        } else {
            throw new IllegalArgumentException("CamelDigitalOceanId or CamelDigitalOceanDropletImage must be specified");
        }
        LOG.trace("Image [{}] ", (Object)image);
        exchange.getMessage().setBody(image);
    }

    private void getImageActions(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Integer imageId = exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        if (ObjectHelper.isEmpty(imageId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        Actions actions = this.getEndpoint().getDigitalOceanClient().getAvailableImageActions(imageId, this.configuration.getPage(), this.configuration.getPerPage());
        LOG.trace("Actions for Image {} : page {} / {} per page [{}] ", new Object[]{imageId, this.configuration.getPage(), this.configuration.getPerPage(), actions.getActions()});
        exchange.getMessage().setBody(actions.getActions());
    }

    private void updateImage(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Integer imageId = exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        if (ObjectHelper.isEmpty(imageId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        String name = exchange.getIn().getHeader("CamelDigitalOceanName", String.class);
        if (ObjectHelper.isEmpty(name)) {
            throw new IllegalArgumentException("CamelDigitalOceanName must be specified");
        }
        Image image = new Image();
        image.setId(imageId);
        image.setName(name);
        image = this.getEndpoint().getDigitalOceanClient().updateImage(image);
        LOG.trace("Update Image {} [{}] ", (Object)imageId, (Object)image);
        exchange.getMessage().setBody(image);
    }

    private void deleteImage(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Integer imageId = exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        if (ObjectHelper.isEmpty(imageId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        Delete delete = this.getEndpoint().getDigitalOceanClient().deleteImage(imageId);
        LOG.trace("Delete  Image {} [{}] ", (Object)imageId, (Object)delete);
        exchange.getMessage().setBody(delete);
    }

    private void transferImage(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Integer imageId = exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        if (ObjectHelper.isEmpty(imageId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        String region = exchange.getIn().getHeader("CamelDigitalOceanRegion", String.class);
        if (ObjectHelper.isEmpty(region)) {
            throw new IllegalArgumentException("CamelDigitalOceanRegion must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().transferImage(imageId, region);
        LOG.trace("Transfer  Image {} to Region {} [{}] ", new Object[]{imageId, region, action});
        exchange.getMessage().setBody(action);
    }

    private void convertImageToSnapshot(Exchange exchange) throws RequestUnsuccessfulException, DigitalOceanException {
        Integer imageId = exchange.getIn().getHeader("CamelDigitalOceanId", Integer.class);
        if (ObjectHelper.isEmpty(imageId)) {
            throw new IllegalArgumentException("CamelDigitalOceanId must be specified");
        }
        Action action = this.getEndpoint().getDigitalOceanClient().convertImage(imageId);
        LOG.trace("Convert Image {} [{}] ", (Object)imageId, (Object)action);
        exchange.getMessage().setBody(action);
    }
}

